/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.tileentities;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.piepenguin.rfwindmill.lib.EnergyStorage;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWindmillBlock
extends TileEntity
implements IEnergyProvider {
    private EnergyStorage storage;
    private static final int tunnelRange = 10;
    private static final int minHeight = 60;
    private static final int maxHeight = 100;
    private static final String NBT_MAXIMUM_ENERGY_GENERATION = "RFWMaximumEnergyGeneration";
    private int maximumEnergyGeneration;
    private float fractionalRF = 0.0f;
    public static final String publicName = "tileEntityWindmillBlock";
    private String name = "tileEntityWindmillBlock";

    public TileEntityWindmillBlock() {
        this(0, 0, 0);
    }

    public TileEntityWindmillBlock(int pMaximumEnergyGeneration, int pMaximumEnergyTransfer, int pCapacity) {
        this.storage = new EnergyStorage(pCapacity, pMaximumEnergyTransfer);
        this.maximumEnergyGeneration = pMaximumEnergyGeneration;
    }

    public String getName() {
        return this.name;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.generateEnergy();
            if (this.storage.getEnergyStored() > 0) {
                this.transferEnergy();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maximumEnergyGeneration = nbt.func_74762_e(NBT_MAXIMUM_ENERGY_GENERATION);
        this.storage.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a(NBT_MAXIMUM_ENERGY_GENERATION, this.maximumEnergyGeneration);
        this.storage.writeToNBT(nbt);
    }

    private void generateEnergy() {
        int deltaHeight = 40;
        if (deltaHeight <= 0) {
            deltaHeight = 1;
        }
        float heightModifier = (float)Math.min(Math.max(this.field_145848_d - 60, 0), deltaHeight) / (float)deltaHeight;
        float energyProduced = (float)(this.maximumEnergyGeneration * this.getTunnelLength()) * heightModifier * 0.5f;
        this.fractionalRF += energyProduced - (float)((int)energyProduced);
        if (this.fractionalRF >= 1.0f) {
            this.fractionalRF -= 1.0f;
            energyProduced += 1.0f;
        }
        this.storage.modifyEnergyStored((int)energyProduced);
    }

    private int getTunnelLength() {
        int i;
        int meta = this.func_145832_p();
        int northRange = 10;
        int southRange = 10;
        for (i = -1; i >= -10; --i) {
            if (meta == 0 || meta == 2) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + i).func_149688_o() == Material.field_151579_a) continue;
                northRange = -i - 1;
                break;
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d, this.field_145849_e).func_149688_o() == Material.field_151579_a) continue;
            northRange = -i - 1;
            break;
        }
        for (i = 1; i <= 10; ++i) {
            if (meta == 0 || meta == 2) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + i).func_149688_o() == Material.field_151579_a) continue;
                southRange = i - 1;
                break;
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d, this.field_145849_e).func_149688_o() == Material.field_151579_a) continue;
            southRange = i - 1;
            break;
        }
        return Math.min(northRange, southRange);
    }

    private void transferEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(tile instanceof IEnergyReceiver)) continue;
            IEnergyReceiver receiver = (IEnergyReceiver)tile;
            this.extractEnergy(direction.getOpposite(), receiver.receiveEnergy(direction.getOpposite(), this.storage.getExtract(), false), false);
        }
    }

    private ForgeDirection metadataToDirection() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.NORTH;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.canConnectEnergy(from)) {
            return this.storage.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.NORTH);
    }

    public void setEnergyStored(int pEnergy) {
        this.storage.setEnergyStored(pEnergy);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.NORTH);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != this.metadataToDirection() && from != this.metadataToDirection().getOpposite();
    }
}

