/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.doubledoordev.itemblacklist.client.ClientEventHandlers;
import net.doubledoordev.itemblacklist.client.Renderer;
import net.doubledoordev.itemblacklist.data.GlobalBanList;
import net.doubledoordev.itemblacklist.util.CommandBlockItem;
import net.doubledoordev.itemblacklist.util.CommandUnpack;
import net.doubledoordev.itemblacklist.util.ItemBlacklisted;
import net.doubledoordev.itemblacklist.util.ServerEventHandlers;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="ItemBlacklist", dependencies="before:*", useMetadata=false)
public class ItemBlacklist {
    @Mod.Instance
    public static ItemBlacklist instance;
    public static String message;
    public static Logger logger;
    public static boolean log;
    private boolean unpack4all;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        GameRegistry.registerItem((Item)ItemBlacklisted.I, (String)"blacklisted");
        if (event.getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)ClientEventHandlers.I);
            FMLCommonHandler.instance().bus().register((Object)ClientEventHandlers.I);
            MinecraftForgeClient.registerItemRenderer((Item)ItemBlacklisted.I, (IItemRenderer)new Renderer());
        }
        Configuration configuration = new Configuration(event.getSuggestedConfigurationFile());
        message = configuration.getString("message", "general", "Now is not the time to use that. ~Prof. Oak", "The message you get when using an item that is banned.");
        log = configuration.getBoolean("log", "general", false, "Log every instance of any banned item used. (SPAM WARNING!)");
        this.unpack4all = configuration.getBoolean("unpack4all", "general", true, "Let everyone unpack items by using the 'unpack' command. So items can be used in crafting.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBlockItem());
        if (this.unpack4all) {
            event.registerServerCommand((ICommand)new CommandUnpack());
        }
        GlobalBanList.init();
        MinecraftForge.EVENT_BUS.register((Object)ServerEventHandlers.I);
        FMLCommonHandler.instance().bus().register((Object)ServerEventHandlers.I);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        MinecraftForge.EVENT_BUS.unregister((Object)ServerEventHandlers.I);
        FMLCommonHandler.instance().bus().register((Object)ServerEventHandlers.I);
    }
}

