/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.api.crafting.recipes.ITransposerRecipe;
import cofh.thermalfoundation.fluid.TFFluids;
import cofh.thermalfoundation.item.TFItems;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TransposerManager {
    private static Map<List<Integer>, RecipeTransposer> recipeMapFill = new THashMap();
    private static Map<ComparableItemStackTransposer, RecipeTransposer> recipeMapExtraction = new THashMap();
    private static Set<ComparableItemStackTransposer> validationSet = new THashSet();
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 1600;

    public static RecipeTransposer getFillRecipe(ItemStack itemStack, FluidStack fluidStack) {
        return itemStack == null || fluidStack == null || fluidStack.getFluid() == null ? null : recipeMapFill.get(Arrays.asList(new ComparableItemStackTransposer(itemStack).hashCode(), fluidStack.getFluid().hashCode()));
    }

    public static RecipeTransposer getExtractionRecipe(ItemStack itemStack) {
        return itemStack == null ? null : recipeMapExtraction.get((Object)new ComparableItemStackTransposer(itemStack));
    }

    public static boolean fillRecipeExists(ItemStack itemStack, FluidStack fluidStack) {
        return TransposerManager.getFillRecipe(itemStack, fluidStack) != null;
    }

    public static boolean extractionRecipeExists(ItemStack itemStack, FluidStack fluidStack) {
        return TransposerManager.getExtractionRecipe(itemStack) != null;
    }

    public static RecipeTransposer[] getFillRecipeList() {
        return recipeMapFill.values().toArray(new RecipeTransposer[0]);
    }

    public static RecipeTransposer[] getExtractionRecipeList() {
        return recipeMapExtraction.values().toArray(new RecipeTransposer[0]);
    }

    public static boolean isItemValid(ItemStack itemStack) {
        return itemStack == null ? false : validationSet.contains((Object)new ComparableItemStackTransposer(itemStack));
    }

    public static void addDefaultRecipes() {
        String string = "RecipeManagers.Transposer.Recipes";
        boolean bl = ThermalExpansion.config.get(string, "MossyCobblestone", true);
        boolean bl2 = ThermalExpansion.config.get(string, "MossyStoneBrick", true);
        boolean bl3 = ThermalExpansion.config.get(string, "EndStone", true);
        boolean bl4 = ThermalExpansion.config.get(string, "PackedIce", true);
        boolean bl5 = ThermalExpansion.config.get(string, "NetherBrick", false);
        if (bl) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), new FluidStack(FluidRegistry.WATER, 250), false);
        }
        if (bl2) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), new FluidStack(FluidRegistry.WATER, 250), false);
        }
        if (bl3) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150322_A), new ItemStack(Blocks.field_150377_bs), new FluidStack(TFFluids.fluidEnder, 250), false);
        }
        if (bl4) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150403_cj), new FluidStack(TFFluids.fluidCryotheum, 250), false);
        }
        if (bl5) {
            TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151130_bT), new FluidStack(FluidRegistry.LAVA, 250), false);
        }
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151065_br), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Items.field_151126_ay), ItemHelper.cloneStack((ItemStack)TFItems.dustBlizz, (int)1), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack((Block)Blocks.field_150354_m), ItemHelper.cloneStack((ItemStack)TFItems.dustBlitz), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, ItemHelper.cloneStack((ItemStack)TFItems.dustObsidian, (int)1), ItemHelper.cloneStack((ItemStack)TFItems.dustBasalz, (int)1), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketRedstone, (int)1), new FluidStack(TFFluids.fluidRedstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketGlowstone, (int)1), new FluidStack(TFFluids.fluidGlowstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketEnder, (int)1), new FluidStack(TFFluids.fluidEnder, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketPyrotheum, (int)1), new FluidStack(TFFluids.fluidPyrotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketCryotheum, (int)1), new FluidStack(TFFluids.fluidCryotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketAerotheum, (int)1), new FluidStack(TFFluids.fluidAerotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketPetrotheum, (int)1), new FluidStack(TFFluids.fluidPetrotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketCoal, (int)1), new FluidStack(TFFluids.fluidCoal, 1000), true);
    }

    public static void loadRecipes() {
        TransposerManager.addFillRecipe(1600, ItemHelper.getOre((String)"oreCinnabar"), ItemHelper.cloneStack((ItemStack)TFItems.crystalCinnabar, (int)1), new FluidStack(TFFluids.fluidCryotheum, 200), false);
        for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (FluidContainerRegistry.isBucket((ItemStack)fluidContainerData.emptyContainer)) {
                TransposerManager.addFillRecipe(800, fluidContainerData, true);
                continue;
            }
            TransposerManager.addFillRecipe(1600, fluidContainerData, true);
        }
    }

    public static void refreshRecipes() {
        ComparableItemStackTransposer comparableItemStackTransposer;
        RecipeTransposer recipeTransposer;
        THashMap tHashMap = new THashMap(recipeMapFill.size());
        THashMap tHashMap2 = new THashMap(recipeMapExtraction.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<List<Integer>, RecipeTransposer> entry : recipeMapFill.entrySet()) {
            recipeTransposer = entry.getValue();
            comparableItemStackTransposer = new ComparableItemStackTransposer(recipeTransposer.input);
            FluidStack fluidStack = recipeTransposer.fluid.copy();
            tHashMap.put(Arrays.asList(comparableItemStackTransposer.hashCode(), fluidStack.getFluid().hashCode()), recipeTransposer);
            tHashSet.add(comparableItemStackTransposer);
        }
        for (Map.Entry<Object, RecipeTransposer> entry : recipeMapExtraction.entrySet()) {
            recipeTransposer = entry.getValue();
            comparableItemStackTransposer = new ComparableItemStackTransposer(recipeTransposer.input);
            tHashMap2.put(comparableItemStackTransposer, recipeTransposer);
            tHashSet.add(comparableItemStackTransposer);
        }
        recipeMapFill.clear();
        recipeMapFill = tHashMap;
        recipeMapExtraction.clear();
        recipeMapExtraction = tHashMap2;
        validationSet.clear();
        validationSet = tHashSet;
    }

    public static boolean addTEFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl) {
        if (itemStack == null || itemStack2 == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, 100);
        ComparableItemStackTransposer comparableItemStackTransposer = new ComparableItemStackTransposer(itemStack);
        recipeMapFill.put(Arrays.asList(comparableItemStackTransposer.hashCode(), fluidStack.getFluid().hashCode()), recipeTransposer);
        validationSet.add(comparableItemStackTransposer);
        if (bl) {
            TransposerManager.addTEExtractionRecipe(n, itemStack2, itemStack, fluidStack, 100, false);
        }
        return true;
    }

    public static boolean addTEExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl) {
        if (itemStack == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (itemStack2 == null && (bl || n2 != 0)) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, n2);
        ComparableItemStackTransposer comparableItemStackTransposer = new ComparableItemStackTransposer(itemStack);
        recipeMapExtraction.put(comparableItemStackTransposer, recipeTransposer);
        validationSet.add(comparableItemStackTransposer);
        if (bl) {
            TransposerManager.addTEFillRecipe(n, itemStack2, itemStack, fluidStack, false);
        }
        return true;
    }

    public static boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl, boolean bl2) {
        if (itemStack == null || itemStack2 == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (!(allowOverwrite & bl2) && TransposerManager.fillRecipeExists(itemStack, fluidStack)) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStackTransposer(itemStack).hashCode(), fluidStack.getFluid().hashCode()), recipeTransposer);
        validationSet.add(new ComparableItemStackTransposer(itemStack));
        if (bl) {
            TransposerManager.addExtractionRecipe(n, itemStack2, itemStack, fluidStack, 100, false, bl2);
        }
        return true;
    }

    public static boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl, boolean bl2) {
        if (itemStack == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (!bl2 && TransposerManager.extractionRecipeExists(itemStack, fluidStack)) {
            return false;
        }
        if (itemStack2 == null && bl || itemStack2 == null && n2 != 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, n2);
        recipeMapExtraction.put(new ComparableItemStackTransposer(itemStack), recipeTransposer);
        validationSet.add(new ComparableItemStackTransposer(itemStack));
        if (bl) {
            TransposerManager.addFillRecipe(n, itemStack2, itemStack, fluidStack, false, bl2);
        }
        return true;
    }

    public static boolean removeFillRecipe(ItemStack itemStack, FluidStack fluidStack) {
        return recipeMapFill.remove(Arrays.asList(new ComparableItemStackTransposer(itemStack).hashCode(), fluidStack.getFluid().hashCode())) != null;
    }

    public static boolean removeExtractionRecipe(ItemStack itemStack) {
        return recipeMapExtraction.remove((Object)new ComparableItemStackTransposer(itemStack)) != null;
    }

    public static boolean addFillRecipe(int n, FluidContainerRegistry.FluidContainerData fluidContainerData, boolean bl) {
        return TransposerManager.addFillRecipe(n, fluidContainerData.emptyContainer, fluidContainerData.filledContainer, fluidContainerData.fluid, bl, false);
    }

    public static boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl) {
        return TransposerManager.addFillRecipe(n, itemStack, itemStack2, fluidStack, bl, false);
    }

    public static boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl) {
        return TransposerManager.addExtractionRecipe(n, itemStack, itemStack2, fluidStack, n2, bl, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Transposer", "AllowRecipeOverwrite", false);
    }

    public static class ComparableItemStackTransposer
    extends ComparableItemStack {
        static final String ORE = "ore";
        static final String CROP = "crop";
        static final String DUST = "dust";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String GEM = "gem";

        public static boolean safeOreType(String string) {
            return string.startsWith(ORE) || string.startsWith(CROP) || string.startsWith(DUST) || string.startsWith(INGOT) || string.startsWith(NUGGET) || string.startsWith(GEM);
        }

        public static int getOreID(ItemStack itemStack) {
            ArrayList arrayList = OreDictionaryArbiter.getAllOreIDs((ItemStack)itemStack);
            if (arrayList != null) {
                int n = 0;
                int n2 = arrayList.size();
                while (n < n2) {
                    int n3;
                    if ((n3 = ((Integer)arrayList.get(n++)).intValue()) == -1 || !ComparableItemStackTransposer.safeOreType(ItemHelper.oreProxy.getOreName(n3))) continue;
                    return n3;
                }
            }
            return -1;
        }

        public static int getOreID(String string) {
            if (!ComparableItemStackTransposer.safeOreType(string)) {
                return -1;
            }
            return ItemHelper.oreProxy.getOreID(string);
        }

        public ComparableItemStackTransposer(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackTransposer.getOreID(itemStack);
        }

        public ComparableItemStackTransposer(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackTransposer.getOreID(this.toItemStack());
        }

        public ComparableItemStackTransposer set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackTransposer.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipeTransposer
    implements ITransposerRecipe {
        final ItemStack input;
        final ItemStack output;
        final FluidStack fluid;
        final int energy;
        final int chance;

        RecipeTransposer(ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n, int n2) {
            this.input = itemStack;
            this.output = itemStack2;
            this.fluid = fluidStack;
            this.energy = n;
            this.chance = n2;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            if (this.output != null) {
                return this.output.func_77946_l();
            }
            return null;
        }

        @Override
        public FluidStack getFluid() {
            return this.fluid.copy();
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }

        @Override
        public int getChance() {
            return this.chance;
        }
    }
}

