/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.container;

import cofh.api.tileentity.IAugmentable;
import cofh.core.block.TileCoFHBase;
import cofh.core.gui.slot.SlotAugment;
import cofh.lib.gui.container.ContainerBase;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.lib.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.network.PacketTEBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ContainerTEBase
extends ContainerBase
implements IAugmentableContainer {
    public final TileCoFHBase baseTile;
    protected Slot[] augmentSlots = new Slot[0];
    protected boolean[] augmentStatus = new boolean[0];
    protected boolean augmentLock = true;
    protected boolean hasAugSlots = true;
    protected boolean hasPlayerInvSlots = true;

    public ContainerTEBase() {
        this.baseTile = null;
    }

    public ContainerTEBase(TileEntity tileEntity) {
        this.baseTile = (TileCoFHBase)tileEntity;
    }

    public ContainerTEBase(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        this(inventoryPlayer, tileEntity, true, true);
    }

    public ContainerTEBase(InventoryPlayer inventoryPlayer, TileEntity tileEntity, boolean bl, boolean bl2) {
        this.baseTile = tileEntity instanceof TileCoFHBase ? (TileCoFHBase)tileEntity : null;
        this.hasAugSlots = bl;
        this.hasPlayerInvSlots = bl2;
        if (this.hasAugSlots) {
            this.addAugmentSlots();
        }
        if (this.hasPlayerInvSlots) {
            this.bindPlayerInventory(inventoryPlayer);
        }
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 84;
    }

    protected int getSizeInventory() {
        if (this.baseTile instanceof IInventory) {
            return ((IInventory)this.baseTile).func_70302_i_();
        }
        return 0;
    }

    protected void addAugmentSlots() {
        if (this.baseTile instanceof IAugmentable) {
            this.augmentSlots = new Slot[((IAugmentable)this.baseTile).getAugmentSlots().length];
            for (int i = 0; i < this.augmentSlots.length; ++i) {
                this.augmentSlots[i] = this.func_75146_a((Slot)new SlotAugment((IAugmentable)this.baseTile, null, i, 0, 0));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return this.baseTile == null ? true : this.baseTile.isUseable(entityPlayer);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.baseTile == null) {
            return;
        }
        for (int i = 0; i < ((Container)this).field_75149_d.size(); ++i) {
            this.baseTile.sendGuiNetworkData((Container)this, (ICrafting)((Container)this).field_75149_d.get(i));
        }
    }

    public void func_75137_b(int n, int n2) {
        if (this.baseTile == null) {
            return;
        }
        this.baseTile.receiveGuiNetworkData(n, n2);
    }

    protected boolean performMerge(int n, ItemStack itemStack) {
        int n2 = this.augmentSlots.length;
        int n3 = n2 + 27;
        int n4 = n3 + 9;
        int n5 = n4 + (this.baseTile == null ? 0 : this.baseTile.getInvSlotCount());
        if (n < n2) {
            return this.func_75135_a(itemStack, n2, n4, true);
        }
        if (n < n4) {
            if (!this.augmentLock && n2 > 0 && AugmentHelper.isAugmentItem((ItemStack)itemStack)) {
                return this.func_75135_a(itemStack, 0, n2, false);
            }
            return this.func_75135_a(itemStack, n4, n5, false);
        }
        return this.func_75135_a(itemStack, n2, n4, true);
    }

    public void setAugmentLock(boolean bl) {
        this.augmentLock = bl;
        if (ServerHelper.isClientWorld((World)this.baseTile.func_145831_w())) {
            PacketTEBase.sendTabAugmentPacketToServer(bl);
        }
    }

    public Slot[] getAugmentSlots() {
        return this.augmentSlots;
    }
}

