/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.strongbox;

import cofh.api.inventory.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.strongbox.BlockStrongbox;
import cofh.thermalexpansion.gui.client.GuiStrongbox;
import cofh.thermalexpansion.gui.container.ContainerStrongbox;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileStrongbox
extends TileInventory
implements IReconfigurableFacing,
ISidedInventory,
IInventoryRetainer {
    public static boolean enableSecurity = true;
    public byte type = 1;
    public byte enchant = 0;
    public byte facing = (byte)3;
    public double prevLidAngle;
    public double lidAngle;
    public int numUsingPlayers;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileStrongbox.class, (String)"thermalexpansion.Strongbox");
        TileStrongbox.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Strongboxes to be securable.";
        enableSecurity = ThermalExpansion.config.get("Security", "Strongbox.All.Securable", enableSecurity, string);
    }

    public TileStrongbox() {
    }

    public TileStrongbox(int n) {
        this.type = (byte)n;
        this.createInventory();
    }

    public String getName() {
        return "tile.thermalexpansion.strongbox." + BlockStrongbox.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        return this.rotateBlock();
    }

    public boolean func_145842_c(int n, int n2) {
        if (n == 1) {
            this.numUsingPlayers = n2;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        this.getNumPlayers();
        if (this.numUsingPlayers > 0 && !((TileEntity)this).field_145850_b.field_72995_K && ((TileEntity)this).field_145850_b.func_82737_E() % 200L == 0L) {
            ((TileEntity)this).field_145850_b.func_147452_c(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = MathHelper.approachLinear((double)this.lidAngle, (double)(this.numUsingPlayers > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.prevLidAngle >= 0.5 && this.lidAngle < 0.5) {
            ((TileEntity)this).field_145850_b.func_72908_a((double)((TileEntity)this).field_145851_c + 0.5, (double)((TileEntity)this).field_145848_d + 0.5, (double)((TileEntity)this).field_145849_e + 0.5, "random.chestclosed", 0.5f, ((TileEntity)this).field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.prevLidAngle == 0.0 && this.lidAngle > 0.0) {
            ((TileEntity)this).field_145850_b.func_72908_a((double)((TileEntity)this).field_145851_c + 0.5, (double)((TileEntity)this).field_145848_d + 0.5, (double)((TileEntity)this).field_145849_e + 0.5, "random.chestopen", 0.5f, ((TileEntity)this).field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public double getRadianLidAngle(float f) {
        double d = MathHelper.interpolate((double)this.prevLidAngle, (double)this.lidAngle, (double)f);
        d = 1.0 - d;
        d = 1.0 - d * d * d;
        return d * Math.PI * -0.5;
    }

    public int getStorageIndex() {
        return this.type > 0 ? Math.min(2 * this.type + this.enchant, CoFHProps.STORAGE_SIZE.length - 1) : 0;
    }

    public void createInventory() {
        this.inventory = new ItemStack[CoFHProps.STORAGE_SIZE[this.getStorageIndex()]];
    }

    public void getNumPlayers() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (this.numUsingPlayers != 0 && (((TileEntity)this).field_145850_b.func_82737_E() + (long)((TileEntity)this).field_145851_c + (long)((TileEntity)this).field_145848_d + (long)((TileEntity)this).field_145849_e) % 200L == 0L) {
            this.numUsingPlayers = 0;
            float f = 5.0f;
            List list = ((TileEntity)this).field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)((TileEntity)this).field_145851_c - f), (double)((float)((TileEntity)this).field_145848_d - f), (double)((float)((TileEntity)this).field_145849_e - f), (double)((float)(((TileEntity)this).field_145851_c + 1) + f), (double)((float)(((TileEntity)this).field_145848_d + 1) + f), (double)((float)(((TileEntity)this).field_145849_e + 1) + f)));
            for (EntityPlayer entityPlayer : list) {
                TileStrongbox tileStrongbox;
                if (!(entityPlayer.field_71070_bA instanceof ContainerStrongbox) || (tileStrongbox = ((ContainerStrongbox)entityPlayer.field_71070_bA).getTile()) != this) continue;
                ++this.numUsingPlayers;
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiStrongbox(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerStrongbox(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        this.type = nBTTagCompound.func_74771_c("Type");
        this.enchant = nBTTagCompound.func_74771_c("Enchant");
        this.facing = nBTTagCompound.func_74771_c("Facing");
        this.inventory = this.type > 0 ? new ItemStack[CoFHProps.STORAGE_SIZE[this.getStorageIndex()]] : new ItemStack[1];
        super.func_145839_a(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Type", this.type);
        nBTTagCompound.func_74774_a("Enchant", this.enchant);
        nBTTagCompound.func_74774_a("Facing", this.facing);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.type);
        packetCoFHBase.addByte(this.enchant);
        packetCoFHBase.addByte(this.facing);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        return null;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.type = packetCoFHBase.getByte();
        byte by = this.enchant;
        this.enchant = packetCoFHBase.getByte();
        if (!bl) {
            this.facing = packetCoFHBase.getByte();
            if (this.enchant != by || this.inventory.length <= 0) {
                this.createInventory();
            }
        } else {
            packetCoFHBase.getByte();
        }
    }

    @Override
    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        ((TileEntity)this).field_145850_b.func_147452_c(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
    }

    @Override
    public void func_70305_f() {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof BlockStrongbox) {
            --this.numUsingPlayers;
            ((TileEntity)this).field_145850_b.func_147452_c(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int n) {
        if (n < 2 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public int[] func_94128_d(int n) {
        return this.access.isPublic() ? CoFHProps.SLOTS[this.getStorageIndex()] : CoFHProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.access.isPublic();
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return this.access.isPublic();
    }
}

