/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.inventory.IInventoryConnection;
import cofh.core.RegistrySocial;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiCollector;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCollector
extends TileDeviceBase
implements IInventoryConnection {
    int areaMajor = 2;
    int areaMinor = 1;
    LinkedList<ItemStack> stuffedItems = new LinkedList();
    static float[] defaultDropChances = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    boolean ignoreFriends = true;
    boolean ignoreOwner = true;
    public boolean augmentEntityCollection;

    public static void initialize() {
        int n = BlockDevice.Types.COLLECTOR.ordinal();
        TileDeviceBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileDeviceBase.defaultSideConfig[n].numConfig = 2;
        TileDeviceBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], new int[0]};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, false};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, false};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSlot = new boolean[0];
        TileDeviceBase.defaultSideConfig[n].allowExtractionSlot = new boolean[0];
        TileDeviceBase.defaultSideConfig[n].sideTex = new int[]{0, 4};
        TileDeviceBase.defaultSideConfig[n].defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        GameRegistry.registerTileEntity(TileCollector.class, (String)"thermalexpansion.Collector");
    }

    public TileCollector() {
        super(BlockDevice.Types.COLLECTOR);
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing ^ 1] = 1;
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (((TileEntity)this).field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
            if (!this.isEmpty()) {
                this.outputBuffer();
            }
            if (this.isEmpty()) {
                this.collectItems();
            }
        }
    }

    public boolean isEmpty() {
        return this.stuffedItems.size() == 0;
    }

    public boolean doNotCollectItemsFrom(EntityPlayer entityPlayer) {
        UUID uUID;
        String string = entityPlayer.func_70005_c_();
        UUID uUID2 = this.owner.getId();
        if (uUID2.equals(uUID = SecurityHelper.getID((EntityPlayer)entityPlayer))) {
            return this.ignoreOwner;
        }
        return this.ignoreFriends && RegistrySocial.playerHasAccess((String)string, (GameProfile)this.owner);
    }

    public void collectItems() {
        int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
        this.stuffedItems.addAll(this.collectItemsInArea(((TileEntity)this).field_145850_b, nArray[0], nArray[1], nArray[2], this.facing, this.areaMajor, this.areaMinor));
        if (this.augmentEntityCollection) {
            this.stuffedItems.addAll(this.collectItemsFromEntities(((TileEntity)this).field_145850_b, nArray[0], nArray[1], nArray[2], this.facing, this.areaMajor, this.areaMinor));
        }
    }

    public void outputBuffer() {
        for (int i = 0; i < 6; ++i) {
            int[] nArray;
            TileEntity tileEntity;
            if (i == this.facing || this.sideCache[i] != 1 || !InventoryHelper.isInsertion((Object)(tileEntity = ((TileEntity)this).field_145850_b.func_147438_o((nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)i))[0], nArray[1], nArray[2])))) continue;
            LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
            for (Object object : this.stuffedItems) {
                object = object == null || object.func_77973_b() == null ? null : InventoryHelper.addToInsertion((Object)tileEntity, (int)i, (ItemStack)object);
                if (object == null) continue;
                linkedList.add((ItemStack)object);
            }
            this.stuffedItems = linkedList;
        }
    }

    public List<ItemStack> collectItemsInArea(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        List list;
        int n7 = 1 + n5;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        switch (n4) {
            case 0: 
            case 1: {
                list = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(n - n5), (double)n2, (double)(n3 - n5), (double)(n + n7), (double)(n2 + n6), (double)(n3 + n7)));
                break;
            }
            case 2: 
            case 3: {
                list = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(n - n5), (double)(n2 - n5), (double)n3, (double)(n + n7), (double)(n2 + n7), (double)(n3 + n6)));
                break;
            }
            default: {
                list = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)n, (double)(n2 - n5), (double)(n3 - n5), (double)(n + n6), (double)(n2 + n7), (double)(n3 + n7)));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityItem entityItem = (EntityItem)list.get(i);
            if (entityItem.field_70128_L || entityItem.func_92059_d().field_77994_a <= 0) continue;
            arrayList.add(entityItem.func_92059_d());
            entityItem.field_70170_p.func_72900_e((Entity)entityItem);
        }
        return arrayList;
    }

    public List<ItemStack> collectItemsFromEntities(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        List list;
        int n7 = 1 + n5;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        switch (n4) {
            case 0: 
            case 1: {
                list = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(n - n5), (double)n2, (double)(n3 - n5), (double)(n + n7), (double)(n2 + n6), (double)(n3 + n7)));
                break;
            }
            case 2: 
            case 3: {
                list = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(n - n5), (double)(n2 - n5), (double)n3, (double)(n + n7), (double)(n2 + n7), (double)(n3 + n6)));
                break;
            }
            default: {
                list = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)n, (double)(n2 - n5), (double)(n3 - n5), (double)(n + n6), (double)(n2 + n7), (double)(n3 + n7)));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)list.get(i);
            float[] fArray = defaultDropChances;
            if (entityLivingBase instanceof EntityLiving) {
                fArray = ((EntityLiving)entityLivingBase).field_82174_bp;
            } else if (this.isSecured() && entityLivingBase instanceof EntityPlayer && this.doNotCollectItemsFrom((EntityPlayer)entityLivingBase)) continue;
            for (int j = 0; j < 5; ++j) {
                ItemStack itemStack = entityLivingBase.func_71124_b(j);
                if (itemStack == null || !(fArray[j] >= 1.0f)) continue;
                arrayList.add(itemStack);
                entityLivingBase.func_70062_b(j, null);
            }
        }
        return arrayList;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiCollector(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("StuffedInv", 10);
        this.stuffedItems.clear();
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            this.stuffedItems.add(ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList = new NBTTagList();
        for (int i = 0; i < this.stuffedItems.size(); ++i) {
            if (this.stuffedItems.get(i) == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            this.stuffedItems.get(i).func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("StuffedInv", (NBTBase)nBTTagList);
    }

    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection forgeDirection) {
        if (forgeDirection != ForgeDirection.UNKNOWN && forgeDirection.ordinal() != this.facing && this.sideCache[forgeDirection.ordinal()] == 1) {
            return IInventoryConnection.ConnectionType.FORCE;
        }
        return IInventoryConnection.ConnectionType.DEFAULT;
    }
}

