/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.tileentity.ISidedTexture;
import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.crafting.RecipeAugmentable;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.device.ItemBlockDevice;
import cofh.thermalexpansion.block.device.TileActivator;
import cofh.thermalexpansion.block.device.TileBreaker;
import cofh.thermalexpansion.block.device.TileBuffer;
import cofh.thermalexpansion.block.device.TileCollector;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.block.device.TileExtender;
import cofh.thermalexpansion.block.device.TileNullifier;
import cofh.thermalexpansion.block.device.TileWorkbenchFalse;
import cofh.thermalexpansion.item.TEAugments;
import cofh.thermalexpansion.item.TEEquipment;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDevice
extends BlockTEBase {
    public static IIcon deviceSide;
    public static IIcon[] deviceFace;
    public static IIcon[] deviceActive;
    public static final String[] NAMES;
    public static boolean[] enable;
    public static ItemStack[] defaultAugments;
    public static boolean defaultRedstoneControl;
    public static boolean defaultReconfigSides;
    public static ItemStack pump;
    public static ItemStack activator;
    public static ItemStack breaker;
    public static ItemStack collector;
    public static ItemStack nullifier;
    public static ItemStack buffer;
    public static ItemStack extender;

    public BlockDevice() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.device");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case WORKBENCH_FALSE: {
                return new TileWorkbenchFalse();
            }
            case ACTIVATOR: {
                return new TileActivator();
            }
            case BREAKER: {
                return new TileBreaker();
            }
            case COLLECTOR: {
                return new TileCollector();
            }
            case NULLIFIER: {
                return new TileNullifier();
            }
            case BUFFER: {
                return new TileBuffer();
            }
            case EXTENDER: {
                return new TileExtender();
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(ItemBlockDevice.setDefaultTag(new ItemStack(item, 1, i)));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity;
        if (itemStack.field_77990_d != null && (tileEntity = world.func_147438_o(n, n2, n3)) instanceof TileAugmentable) {
            TileAugmentable tileAugmentable = (TileAugmentable)world.func_147438_o(n, n2, n3);
            tileAugmentable.readAugmentsFromNBT(itemStack.field_77990_d);
            tileAugmentable.installAugments();
            tileAugmentable.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            int n4 = BlockHelper.determineXZPlaceFacing((EntityLivingBase)entityLivingBase);
            byte by = ReconfigurableHelper.getFacing(itemStack);
            byte[] byArray = ReconfigurableHelper.getSideCache(itemStack, tileAugmentable.getDefaultSides());
            tileAugmentable.sideCache[0] = byArray[0];
            tileAugmentable.sideCache[1] = byArray[1];
            tileAugmentable.sideCache[n4] = byArray[by];
            tileAugmentable.sideCache[BlockHelper.getLeftSide((int)n4)] = byArray[BlockHelper.getLeftSide((int)by)];
            tileAugmentable.sideCache[BlockHelper.getRightSide((int)n4)] = byArray[BlockHelper.getRightSide((int)by)];
            tileAugmentable.sideCache[BlockHelper.getOppositeSide((int)n4)] = byArray[BlockHelper.getOppositeSide((int)by)];
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean isNormalCube(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        ISidedTexture iSidedTexture = (ISidedTexture)iBlockAccess.func_147438_o(n, n2, n3);
        return iSidedTexture == null ? null : iSidedTexture.getTexture(n4, BlockCoFHBase.renderPass);
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        if (n2 == Types.WORKBENCH_FALSE.ordinal()) {
            if (n == 0) {
                return IconRegistry.getIcon((String)"WorkbenchBottom", (int)1);
            }
            if (n == 1) {
                return IconRegistry.getIcon((String)"WorkbenchTop", (int)1);
            }
            return IconRegistry.getIcon((String)"WorkbenchSide", (int)1);
        }
        return n != 3 ? deviceSide : deviceFace[n2 % Types.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        deviceSide = iIconRegister.func_94245_a("thermalexpansion:device/Device_Side");
        for (int i = 0; i < Types.values().length; ++i) {
            if (i == Types.WORKBENCH_FALSE.ordinal() || i == Types.PUMP.ordinal() || i == Types.EXTENDER.ordinal()) continue;
            BlockDevice.deviceFace[i] = iIconRegister.func_94245_a("thermalexpansion:device/Device_Face_" + StringHelper.titleCase((String)NAMES[i]));
            BlockDevice.deviceActive[i] = iIconRegister.func_94245_a("thermalexpansion:device/Device_Active_" + StringHelper.titleCase((String)NAMES[i]));
        }
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileAugmentable) {
            TileAugmentable tileAugmentable = (TileAugmentable)world.func_147438_o(n, n2, n3);
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, tileAugmentable);
            nBTTagCompound.func_74768_a("Energy", tileAugmentable.getEnergyStored(ForgeDirection.UNKNOWN));
            tileAugmentable.writeAugmentsToNBT(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        NBTTagCompound nBTTagCompound = this.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileAugmentable) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            TileAugmentable tileAugmentable = (TileAugmentable)tileEntity;
            ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, tileAugmentable);
            nBTTagCompound.func_74768_a("Energy", tileAugmentable.getEnergyStored(ForgeDirection.UNKNOWN));
            tileAugmentable.writeAugmentsToNBT(nBTTagCompound);
        }
        return super.dismantleBlock(entityPlayer, nBTTagCompound, world, n, n2, n3, bl, false);
    }

    public boolean initialize() {
        TileDeviceBase.configure();
        TileWorkbenchFalse.initialize();
        TileActivator.initialize();
        TileBreaker.initialize();
        TileCollector.initialize();
        TileNullifier.initialize();
        TileBuffer.initialize();
        TileExtender.initialize();
        if (defaultRedstoneControl) {
            BlockDevice.defaultAugments[0] = ItemHelper.cloneStack((ItemStack)TEAugments.generalRedstoneControl);
        }
        if (defaultReconfigSides) {
            BlockDevice.defaultAugments[1] = ItemHelper.cloneStack((ItemStack)TEAugments.generalReconfigSides);
        }
        activator = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.ACTIVATOR.ordinal()));
        breaker = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.BREAKER.ordinal()));
        collector = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.COLLECTOR.ordinal()));
        nullifier = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.NULLIFIER.ordinal()));
        buffer = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.BUFFER.ordinal()));
        GameRegistry.registerCustomItemStack((String)"activator", (ItemStack)activator);
        GameRegistry.registerCustomItemStack((String)"breaker", (ItemStack)breaker);
        GameRegistry.registerCustomItemStack((String)"collector", (ItemStack)collector);
        GameRegistry.registerCustomItemStack((String)"nullifier", (ItemStack)nullifier);
        GameRegistry.registerCustomItemStack((String)"buffer", (ItemStack)buffer);
        return true;
    }

    public boolean postInit() {
        String string = "Device.Breaker";
        String string2 = "If enabled, The Block Breaker will require a Diamond Pickaxe instead of an Invar Pickaxe.";
        boolean bl = ThermalExpansion.config.get(string, "Recipe.RequireDiamondPickaxe", false, string2);
        ItemStack itemStack = bl ? new ItemStack(Items.field_151046_w) : TEEquipment.toolInvarPickaxe;
        String string3 = "thermalexpansion:machineTin";
        if (enable[Types.ACTIVATOR.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(activator, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150331_J, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Blocks.field_150486_ae}));
        }
        if (enable[Types.BREAKER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(breaker, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150331_J, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), itemStack}));
        }
        if (enable[Types.COLLECTOR.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(collector, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150331_J, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Blocks.field_150438_bZ}));
        }
        if (enable[Types.NULLIFIER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(nullifier, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Items.field_151129_at, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), "ingotInvar"}));
        }
        if (enable[Types.BUFFER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(buffer, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150438_bZ, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), "gearCopper"}));
        }
        if (enable[Types.EXTENDER.ordinal()]) {
            // empty if block
        }
        TECraftingHandler.addSecureRecipe(activator);
        TECraftingHandler.addSecureRecipe(breaker);
        TECraftingHandler.addSecureRecipe(collector);
        TECraftingHandler.addSecureRecipe(nullifier);
        TECraftingHandler.addSecureRecipe(buffer);
        return true;
    }

    public static void refreshItemStacks() {
        activator = ItemBlockDevice.setDefaultTag(activator);
        breaker = ItemBlockDevice.setDefaultTag(breaker);
        collector = ItemBlockDevice.setDefaultTag(collector);
        nullifier = ItemBlockDevice.setDefaultTag(nullifier);
        buffer = ItemBlockDevice.setDefaultTag(buffer);
    }

    static {
        deviceFace = new IIcon[Types.values().length];
        deviceActive = new IIcon[Types.values().length];
        NAMES = new String[]{"workbench", "pump", "activator", "breaker", "collector", "nullifier", "buffer", "extender"};
        enable = new boolean[Types.values().length];
        defaultAugments = new ItemStack[4];
        defaultRedstoneControl = true;
        defaultReconfigSides = true;
        String string = "Device.";
        for (int i = 0; i < Types.values().length; ++i) {
            BlockDevice.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
        BlockDevice.enable[Types.WORKBENCH_FALSE.ordinal()] = false;
        BlockDevice.enable[Types.PUMP.ordinal()] = false;
        BlockDevice.enable[Types.EXTENDER.ordinal()] = false;
        ThermalExpansion.config.removeCategory(string + StringHelper.titleCase((String)NAMES[Types.WORKBENCH_FALSE.ordinal()]));
        ThermalExpansion.config.removeCategory(string + StringHelper.titleCase((String)NAMES[Types.PUMP.ordinal()]));
        ThermalExpansion.config.removeCategory(string + StringHelper.titleCase((String)NAMES[Types.EXTENDER.ordinal()]));
    }

    public static enum Types {
        WORKBENCH_FALSE,
        PUMP,
        ACTIVATOR,
        BREAKER,
        COLLECTOR,
        NULLIFIER,
        BUFFER,
        EXTENDER;

    }
}

