/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.TGChiselBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class Bunker
extends Structure {
    MBlock groundBlock = new MBlock(TGBlocks.concrete, 5);
    MBlock stairsblock = new MBlock(Blocks.field_150446_ar, 0);
    MBlock wallBlock = new MBlock(TGBlocks.concrete, 6);
    MBlock roofBlock = new MBlock(TGBlocks.concrete, 3);
    MBlock sandbags = new MBlock(TGBlocks.sandbags, 0);
    MBlock ladder = new MBlock(TGBlocks.ladder01, 0);
    MBlock[] crateBlocks = new MBlock[]{TGChiselBlocks.factory_box, TGChiselBlocks.woodenCrate};
    int type = 0;

    public Bunker(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int type) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.type = type;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int dz;
        int dx;
        int zoffset;
        int xoffset;
        if (sizeX <= 4 && sizeZ >= 5) {
            if (direction == 0 || direction == 2) {
                direction = (direction + 1) % 4;
            }
        } else if (sizeZ <= 4 && sizeX >= 5 && (direction == 1 || direction == 3)) {
            direction = (direction + 1) % 4;
        }
        switch (direction) {
            case 0: {
                posX += 2;
                sizeX -= 2;
                break;
            }
            case 1: {
                posZ += 2;
                sizeZ -= 2;
                break;
            }
            case 2: {
                sizeX -= 2;
                break;
            }
            case 3: {
                sizeZ -= 2;
            }
        }
        for (int y = -1; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    if (y == -1) {
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.groundBlock.block, this.groundBlock.meta, 2);
                        continue;
                    }
                    if (y == 0) {
                        if (x == 0 || x == sizeX - 1 || z == 0 || z == sizeZ - 1) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.wallBlock.block, this.wallBlock.meta, 2);
                            continue;
                        }
                        world.func_147468_f(posX + x, posY + y, posZ + z);
                        continue;
                    }
                    if (y == 1) {
                        if (this.type == 2 || this.type == 3) {
                            if (x != 0 && x != sizeX - 1 && z != 0 && z != sizeZ - 1) continue;
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.wallBlock.block, this.wallBlock.meta, 2);
                            continue;
                        }
                        if ((x != 0 && x != sizeX - 1 || z != 0 && z != sizeZ - 1 && z % 3 != 0) && (x != 0 && x != sizeX - 1 && x % 3 != 0 || z != 0 && z != sizeZ - 1)) continue;
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.wallBlock.block, this.wallBlock.meta, 2);
                        continue;
                    }
                    if (y == 2) {
                        if (x == 0 || x == sizeX - 1 || z == 0 || z == sizeZ - 1) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.wallBlock.block, this.wallBlock.meta, 2);
                            continue;
                        }
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.roofBlock.block, this.roofBlock.meta, 2);
                        continue;
                    }
                    if (y != 3 || this.type != 1 && this.type != 3 || x != 0 && x != sizeX - 1 && z != 0 && z != sizeZ - 1) continue;
                    world.func_147465_d(posX + x, posY + y, posZ + z, this.sandbags.block, this.sandbags.meta, 2);
                }
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 2;
                dx = -1;
                dz = 0;
                break;
            }
            case 1: {
                xoffset = sizeX / 2;
                zoffset = 0;
                dx = 0;
                dz = -1;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 2;
                dx = 1;
                dz = 0;
                break;
            }
            default: {
                xoffset = sizeX / 2;
                zoffset = sizeZ - 1;
                dx = 0;
                dz = 1;
            }
        }
        world.func_147449_b(posX + xoffset, posY + 1, posZ + zoffset, Blocks.field_150350_a);
        world.func_147449_b(posX + xoffset, posY + 0, posZ + zoffset, Blocks.field_150350_a);
        ItemDoor.func_150924_a((World)world, (int)(posX + xoffset), (int)(posY + 0), (int)(posZ + zoffset), (int)BlockUtils.getBlockDirMeta(BlockUtils.BlockType.DOOR, direction), (Block)TGBlocks.door01);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : 0), posY + 0, posZ + zoffset + (dz == 0 ? 1 : 0), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : 0), posY + 1, posZ + zoffset + (dz == 0 ? 1 : 0), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : 0), posY + 0, posZ + zoffset + (dz == 0 ? -1 : 0), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : 0), posY + 1, posZ + zoffset + (dz == 0 ? -1 : 0), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : dx), posY - 1, posZ + zoffset + (dz == 0 ? 1 : dz), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : dx), posY - 1, posZ + zoffset + (dz == 0 ? -1 : dz), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : dx * 2), posY - 1, posZ + zoffset + (dz == 0 ? 1 : dz * 2), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : dx * 2), posY - 1, posZ + zoffset + (dz == 0 ? -1 : dz * 2), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : dx), posY + 0, posZ + zoffset + (dz == 0 ? 1 : dz), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : dx), posY + 0, posZ + zoffset + (dz == 0 ? -1 : dz), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : dx * 2), posY + 0, posZ + zoffset + (dz == 0 ? 1 : dz * 2), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : dx * 2), posY + 0, posZ + zoffset + (dz == 0 ? -1 : dz * 2), this.wallBlock.block, this.wallBlock.meta, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? 1 : dx), posY + 2, posZ + zoffset + (dz == 0 ? 1 : dz), (Block)TGBlocks.lamp01, 0, 2);
        world.func_147465_d(posX + xoffset + (dx == 0 ? -1 : dx), posY + 2, posZ + zoffset + (dz == 0 ? -1 : dz), (Block)TGBlocks.lamp01, 0, 2);
        world.func_147465_d(posX + xoffset, posY - 1, posZ + zoffset, this.groundBlock.block, this.groundBlock.meta, 2);
        world.func_147465_d(posX + xoffset + dx, posY - 1, posZ + zoffset + dz, this.groundBlock.block, this.groundBlock.meta, 2);
        world.func_147468_f(posX + xoffset + dx, posY + 0, posZ + zoffset + dz);
        world.func_147468_f(posX + xoffset + dx, posY + 1, posZ + zoffset + dz);
        world.func_147465_d(posX + xoffset + dx * 2, posY + 0, posZ + zoffset + dz * 2, this.stairsblock.block, BlockUtils.getBlockDirMeta(BlockUtils.BlockType.STAIRS, (direction + 2) % 4), 2);
        world.func_147468_f(posX + xoffset + dx * 2, posY + 1, posZ + zoffset + dz * 2);
        if (this.type == 2 || this.type == 3) {
            world.func_147465_d(posX + xoffset - dx, posY + 1, posZ + zoffset - dz, (Block)TGBlocks.lamp01, 0, 2);
            this.setCrateBlocks(world, posX + 2, posY, posZ + 2, sizeX - 4, 2, sizeZ - 4);
        } else {
            world.func_147465_d(posX + sizeX / 2, posY + 1, posZ + sizeZ / 2, (Block)TGBlocks.lamp01, 0, 2);
        }
        if (this.type == 1 || this.type == 3) {
            int meta = 0;
            switch (direction) {
                case 0: {
                    xoffset = sizeX - 2;
                    zoffset = sizeZ - 2;
                    dx = 1;
                    dz = 0;
                    meta = 2;
                    break;
                }
                case 1: {
                    zoffset = sizeZ - 2;
                    xoffset = 1;
                    dx = 0;
                    dz = 1;
                    meta = 0;
                    break;
                }
                case 2: {
                    xoffset = 1;
                    zoffset = 1;
                    dx = -1;
                    dz = 0;
                    meta = 3;
                    break;
                }
                case 3: {
                    xoffset = sizeX - 2;
                    zoffset = 1;
                    dx = 0;
                    dz = -1;
                    meta = 1;
                }
            }
            world.func_147468_f(posX + xoffset, posY + 2, posZ + zoffset);
            world.func_147465_d(posX + xoffset + dx, posY + 1, posZ + zoffset + dz, this.wallBlock.block, this.wallBlock.meta, 2);
            world.func_147465_d(posX + xoffset, posY + 0, posZ + zoffset, this.ladder.block, this.ladder.meta + meta, 2);
            world.func_147465_d(posX + xoffset, posY + 1, posZ + zoffset, this.ladder.block, this.ladder.meta + meta, 2);
            world.func_147465_d(posX + xoffset, posY + 2, posZ + zoffset, this.ladder.block, this.ladder.meta + meta, 2);
        }
    }

    private void setCrateBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        Random r = new Random();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    if (world.func_147437_c(posX + x, posY + y - 1, posZ + z) || !(Math.random() > 0.5)) continue;
                    int index = r.nextInt(this.crateBlocks.length);
                    world.func_147465_d(posX + x, posY + y, posZ + z, this.crateBlocks[index].block, this.crateBlocks[index].meta, 2);
                }
            }
        }
    }
}

