/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.TGChiselBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class Barracks
extends Structure {
    MBlock b_pillar = TGChiselBlocks.wood_pillar;
    MBlock b_wall = TGChiselBlocks.wood_wall;
    MBlock b_floor = TGChiselBlocks.wood_floor;
    MBlock b_scaffold = TGChiselBlocks.wood_scaffold;
    MBlock b_roof = TGChiselBlocks.wood_roof;
    MBlock b_roofSlab = TGChiselBlocks.wood_roofSlab;
    MBlock b_stairs = new MBlock(Blocks.field_150476_ad, 0);
    MBlock b_torch = new MBlock(TGBlocks.lamp01, 0);
    MBlock b_ground = new MBlock(Blocks.field_150351_n, 0);
    MBlock b_window = new MBlock(Blocks.field_150359_w, 0);

    public Barracks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int dz;
        int dx;
        int zoffset;
        int xoffset;
        switch (direction) {
            case 0: {
                posX += 2;
                sizeX -= 2;
                break;
            }
            case 1: {
                posZ += 2;
                sizeZ -= 2;
                break;
            }
            case 2: {
                sizeX -= 2;
                break;
            }
            default: {
                sizeZ -= 2;
            }
        }
        sizeX -= (sizeX - 1) % 4;
        sizeZ -= (sizeZ - 1) % 4;
        sizeY = 7;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    if (y == 0) {
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_ground.block, this.b_ground.meta, 2);
                        continue;
                    }
                    if (y == 1) {
                        if (x % 4 != 0 || z % 4 != 0) continue;
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_pillar.block, this.b_pillar.meta, 2);
                        continue;
                    }
                    if (y == 2) {
                        if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_scaffold.block, this.b_scaffold.meta, 2);
                            continue;
                        }
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_floor.block, this.b_floor.meta, 2);
                        continue;
                    }
                    if (y <= 4) {
                        if (x != 0 && z != 0 && x != sizeX - 1 && z != sizeZ - 1) continue;
                        if (x % 4 == 0 && z % 4 == 0) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_scaffold.block, this.b_scaffold.meta, 2);
                            continue;
                        }
                        if (y == 4 && (x % 4 == 2 || z % 4 == 2)) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_window.block, this.b_window.meta, 2);
                            continue;
                        }
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_wall.block, this.b_wall.meta, 2);
                        continue;
                    }
                    if (y == 5) {
                        if (x != 0 && z != 0 && x != sizeX - 1 && z != sizeZ - 1) continue;
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_scaffold.block, this.b_scaffold.meta, 2);
                        continue;
                    }
                    if (y != 6) continue;
                    if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                        world.func_147465_d(posX + x, posY + y, posZ + z, this.b_roofSlab.block, this.b_roofSlab.meta, 2);
                        continue;
                    }
                    world.func_147465_d(posX + x, posY + y, posZ + z, this.b_roof.block, this.b_roof.meta, 2);
                }
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 8 * 4 + 2;
                dx = -1;
                dz = 0;
                break;
            }
            case 1: {
                xoffset = sizeX / 8 * 4 + 2;
                zoffset = 0;
                dx = 0;
                dz = -1;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 8 * 4 + 2;
                dx = 1;
                dz = 0;
                break;
            }
            default: {
                xoffset = sizeX / 8 * 4 + 2;
                zoffset = sizeZ - 1;
                dx = 0;
                dz = 1;
            }
        }
        world.func_147449_b(posX + xoffset, posY + 4, posZ + zoffset, Blocks.field_150350_a);
        world.func_147449_b(posX + xoffset, posY + 3, posZ + zoffset, Blocks.field_150350_a);
        ItemDoor.func_150924_a((World)world, (int)(posX + xoffset), (int)(posY + 3), (int)(posZ + zoffset), (int)BlockUtils.getBlockDirMeta(BlockUtils.BlockType.DOOR, direction), (Block)Blocks.field_150466_ao);
        world.func_147465_d(posX + xoffset + dx, posY + 5, posZ + zoffset + dz, this.b_torch.block, 7, 2);
        world.func_147465_d(posX + xoffset + dx, posY + 2, posZ + zoffset + dz, this.b_stairs.block, BlockUtils.getBlockDirMeta(BlockUtils.BlockType.STAIRS, direction), 2);
        world.func_147465_d(posX + xoffset + dx * 2, posY + 1, posZ + zoffset + dz * 2, this.b_stairs.block, BlockUtils.getBlockDirMeta(BlockUtils.BlockType.STAIRS, direction), 2);
        for (int x = 1; x < sizeX - 1; ++x) {
            for (int z = 1; z < sizeZ - 1; ++z) {
                for (int y = 3; y < 6; ++y) {
                    if (x == 1 || z == 1 || x == sizeX - 2 || z == sizeZ - 2) {
                        if (y == 5 && (x % 4 == 2 || z % 4 == 2)) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, this.b_torch.block, this.b_torch.meta, 2);
                        }
                        if (y != 3 || x % 4 != 0 && z % 4 != 0 || x == xoffset || z == zoffset) continue;
                        world.func_147465_d(posX + x, posY + y, posZ + z, (Block)Blocks.field_150486_ae, 0, 2);
                        continue;
                    }
                    if (!(x != 2 && z != 2 && x != sizeX - 3 && z != sizeZ - 3 || sizeX / 4 <= 1 && sizeZ / 4 <= 1 || y != 3 || x % 4 != 2 || z % 4 != 2 || x == xoffset || z == zoffset)) {
                        if (x == 2) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, Blocks.field_150324_C, 1, 3);
                            world.func_147465_d(posX + x - 1, posY + y, posZ + z, Blocks.field_150324_C, 9, 3);
                        } else if (x == sizeX - 3) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, Blocks.field_150324_C, 3, 3);
                            world.func_147465_d(posX + x + 1, posY + y, posZ + z, Blocks.field_150324_C, 11, 3);
                        } else if (z == 2) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, Blocks.field_150324_C, 2, 3);
                            world.func_147465_d(posX + x, posY + y, posZ + z - 1, Blocks.field_150324_C, 10, 3);
                        } else if (z == sizeZ - 3) {
                            world.func_147465_d(posX + x, posY + y, posZ + z, Blocks.field_150324_C, 0, 3);
                            world.func_147465_d(posX + x, posY + y, posZ + z + 1, Blocks.field_150324_C, 8, 3);
                        }
                    }
                    if (y != 5 || x % 8 != 0 || z % 8 != 0) continue;
                    world.func_147465_d(posX + x, posY + y, posZ + z, this.b_torch.block, this.b_torch.meta, 2);
                }
            }
        }
    }
}

