/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MathUtil {
    public static final double D2R = Math.PI / 180;
    public static final double R2D = 57.29577951308232;

    public static float sin360(float arg) {
        return MathHelper.func_76126_a((float)(arg / 180.0f * (float)Math.PI));
    }

    public static float cos360(float arg) {
        return MathHelper.func_76134_b((float)(arg / 180.0f * (float)Math.PI));
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int randomInt(Random rand, int min, int max) {
        if (max >= min) {
            return min + rand.nextInt(max - min + 1);
        }
        return max + rand.nextInt(min - max + 1);
    }

    public static float randomFloat(Random rand, float min, float max) {
        return min + rand.nextFloat() * (max - min);
    }

    public static Vec2 polarOffsetXZ(double x, double z, double radius, double angle) {
        return new Vec2(x += radius * Math.cos(angle), z += radius * Math.sin(angle));
    }

    public static MovingObjectPosition traceVector(World world, Vec3 src, Vec3 direction, double distance, int steps, Entity ent, EntityLivingBase shooter) {
        direction = direction.func_72432_b();
        for (int i = 0; i < steps; ++i) {
            double maxZ;
            double minZ;
            double maxY;
            double minY;
            double maxX;
            double minX;
            Vec3 src2 = Vec3.func_72443_a((double)src.field_72450_a, (double)src.field_72448_b, (double)src.field_72449_c);
            Vec3 dst = src.func_72441_c(direction.field_72450_a * distance, direction.field_72448_b * distance, direction.field_72449_c * distance);
            Vec3 dst2 = Vec3.func_72443_a((double)dst.field_72450_a, (double)dst.field_72448_b, (double)dst.field_72449_c);
            MovingObjectPosition movingobjectposition = world.func_72933_a(src, dst);
            Entity entity = null;
            if (src2.field_72450_a < dst2.field_72450_a) {
                minX = src2.field_72450_a;
                maxX = dst2.field_72450_a;
            } else {
                maxX = src2.field_72450_a;
                minX = dst2.field_72450_a;
            }
            if (src2.field_72448_b < dst2.field_72448_b) {
                minY = src2.field_72448_b;
                maxY = dst2.field_72448_b;
            } else {
                maxY = src2.field_72448_b;
                minY = dst2.field_72448_b;
            }
            if (src2.field_72449_c < dst2.field_72449_c) {
                minZ = src2.field_72449_c;
                maxZ = dst2.field_72449_c;
            } else {
                maxZ = src2.field_72449_c;
                minZ = dst2.field_72449_c;
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b(1.0, 1.0, 1.0);
            List list = world.func_72839_b(ent, box);
            double d0 = 0.0;
            MovingObjectPosition mop = null;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1.field_70128_L || entity1 == shooter || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(src2, dst2)) == null || !((d1 = src2.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                mop = movingobjectposition1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity, mop.field_72307_f);
            }
            if (movingobjectposition != null) {
                return movingobjectposition;
            }
            src = Vec3.func_72443_a((double)dst.field_72450_a, (double)dst.field_72448_b, (double)dst.field_72449_c);
        }
        return null;
    }

    public static int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static float interpolateRotation(float par1, float par2, float partialTickTime) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + partialTickTime * f3;
    }

    public static void rotateAroundX(Vec3 vec, double angle) {
        double dc = Math.cos(angle);
        double ds = Math.sin(angle);
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b * dc + vec.field_72449_c * ds;
        double d2 = vec.field_72449_c * dc - vec.field_72448_b * ds;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    public static void rotateAroundY(Vec3 vec, double angle) {
        double dc = Math.cos(angle);
        double ds = Math.sin(angle);
        double d0 = vec.field_72450_a * dc + vec.field_72449_c * ds;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c * dc - vec.field_72450_a * ds;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    public static void rotateAroundZ(Vec3 vec, double angle) {
        double dc = Math.cos(angle);
        double ds = Math.sin(angle);
        double d0 = vec.field_72450_a * dc + vec.field_72448_b * ds;
        double d1 = vec.field_72448_b * dc - vec.field_72450_a * ds;
        double d2 = vec.field_72449_c;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    public static class Vec2 {
        public double x;
        public double y;

        public Vec2(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double lenSquared() {
            return this.x * this.x + this.y * this.y;
        }

        public double len() {
            return Math.sqrt(this.lenSquared());
        }

        public void normalize() {
            double len = this.len();
            if (len > 0.0) {
                double f = 1.0 / len;
                this.x *= f;
                this.y *= f;
            }
        }

        public Vec2 getNormalized() {
            double len = this.len();
            if (len > 0.0) {
                double f = 1.0 / len;
                return new Vec2(this.x * f, this.y * f);
            }
            return new Vec2(0.0, 0.0);
        }

        public static Vec2 substract(Vec2 A, Vec2 B) {
            return new Vec2(B.x - A.x, B.y - A.y);
        }

        public static Vec2 add(Vec2 A, Vec2 B) {
            return new Vec2(B.x + A.x, B.y + A.y);
        }

        public Vec2 getVecTo(Vec2 endpoint) {
            return Vec2.substract(endpoint, this);
        }

        public Vec2 getVecFrom(Vec2 startpoint) {
            return Vec2.substract(this, startpoint);
        }

        public double dot(Vec2 other) {
            return this.x * other.x + this.y * other.y;
        }

        public Vec2 getRotated(float degree) {
            double ynew = this.y * (double)MathUtil.cos360(degree) - this.x * (double)MathUtil.sin360(degree);
            double xnew = this.y * (double)MathUtil.sin360(degree) + this.x * (double)MathUtil.cos360(degree);
            return new Vec2(xnew, ynew);
        }

        @Deprecated
        public static double getAngleBetween(Vec2 A, Vec2 B) {
            Vec2 vec1 = A.getNormalized();
            Vec2 vec2 = B.getNormalized();
            return Math.acos(vec1.dot(vec2) / 180.0 * 3.1415927410125732);
        }
    }
}

