/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import techguns.TGBlocks;
import techguns.blocks.GenericBlock;
import techguns.util.BlockUtils;

public class MBlock {
    public Block block;
    public int meta;
    public boolean hasRotation;
    public BlockUtils.BlockType rotationType;
    public int pass;
    protected static Random RND = new Random();

    public MBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public MBlock(Block block, int meta, boolean hasRotation, BlockUtils.BlockType rotationType) {
        this.block = block;
        this.meta = meta;
        this.hasRotation = hasRotation;
        this.rotationType = rotationType;
    }

    public MBlock setPass(int pass) {
        this.pass = pass;
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof MBlock) {
            MBlock o = (MBlock)other;
            return this.block == o.block && this.meta == o.meta;
        }
        return false;
    }

    public boolean isAirBlock() {
        return this.block == TGBlocks.airMarker;
    }

    public int getRotationMeta(int rotationOffset) {
        if (this.hasRotation) {
            switch (this.rotationType) {
                case TG: {
                    if (this.block instanceof GenericBlock) {
                        return ((GenericBlock)this.block).getRotationMeta(this.meta, rotationOffset);
                    }
                    return this.meta;
                }
                case DOOR: {
                    int m = this.meta;
                    block44: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 0: {
                                m = 3;
                                continue block44;
                            }
                            case 3: {
                                m = 2;
                                continue block44;
                            }
                            case 2: {
                                m = 1;
                                continue block44;
                            }
                            case 1: {
                                m = 0;
                                continue block44;
                            }
                            case 7: {
                                m = 6;
                                continue block44;
                            }
                            case 6: {
                                m = 5;
                                continue block44;
                            }
                            case 5: {
                                m = 4;
                                continue block44;
                            }
                            case 4: {
                                m = 7;
                            }
                        }
                    }
                    return m;
                }
                case FENCE_GATE: {
                    if (this.meta < 4) {
                        return (this.meta + rotationOffset) % 4;
                    }
                    return 4 + (this.meta + rotationOffset) % 4;
                }
                case LADDER: {
                    int m = this.meta;
                    block45: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 5: {
                                m = 2;
                                continue block45;
                            }
                            case 4: {
                                m = 3;
                                continue block45;
                            }
                            case 3: {
                                m = 5;
                                continue block45;
                            }
                            case 2: {
                                m = 4;
                            }
                        }
                    }
                    return m;
                }
                case STAIRS: {
                    int m = this.meta;
                    block46: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 2: {
                                m = 0;
                                continue block46;
                            }
                            case 1: {
                                m = 2;
                                continue block46;
                            }
                            case 3: {
                                m = 1;
                                continue block46;
                            }
                            case 0: {
                                m = 3;
                                continue block46;
                            }
                            case 4: {
                                m = 7;
                                continue block46;
                            }
                            case 6: {
                                m = 4;
                                continue block46;
                            }
                            case 5: {
                                m = 6;
                                continue block46;
                            }
                            case 7: {
                                m = 5;
                            }
                        }
                    }
                    return m;
                }
                case BED: {
                    int m = this.meta;
                    block47: for (int i = 0; i < rotationOffset; ++i) {
                        switch (m) {
                            case 8: {
                                m = 11;
                                continue block47;
                            }
                            case 0: {
                                m = 3;
                                continue block47;
                            }
                            case 11: {
                                m = 10;
                                continue block47;
                            }
                            case 3: {
                                m = 2;
                                continue block47;
                            }
                            case 10: {
                                m = 9;
                                continue block47;
                            }
                            case 2: {
                                m = 1;
                                continue block47;
                            }
                            case 9: {
                                m = 8;
                                continue block47;
                            }
                            case 1: {
                                m = 0;
                            }
                        }
                    }
                    return m;
                }
            }
            return this.meta;
        }
        return this.meta;
    }

    public void setBlock(World world, int posX, int posY, int posZ, int rotation) {
        if (this.isAirBlock()) {
            world.func_147468_f(posX, posY, posZ);
        } else {
            TileEntityChest tileentitychest;
            world.func_147465_d(posX, posY, posZ, this.block, this.getRotationMeta(rotation), 2);
            if (this.block == Blocks.field_150486_ae && (tileentitychest = (TileEntityChest)world.func_147438_o(posX, posY, posZ)) != null) {
                WeightedRandomChestContent.func_76293_a((Random)RND, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"dungeonChest", (Random)RND), (IInventory)tileentitychest, (int)ChestGenHooks.getCount((String)"dungeonChest", (Random)RND));
            }
        }
    }
}

