/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.util.MBlock;
import techguns.util.MathUtil;
import techguns.util.MultiMBlock;
import techguns.worldgen.structures.Structure;

public class BlockUtils {
    private static final String FILEPATH = "/assets/techguns/structures/";
    public static final float[][] FILTER_GAUSSIAN_3x3 = new float[][]{{0.0625f, 0.125f, 0.0625f}, {0.125f, 0.25f, 0.125f}, {0.0625f, 0.125f, 0.0625f}};
    public static final float[][] FILTER_GAUSSIAN_5x5 = new float[][]{{0.00325f, 0.01375f, 0.0235f, 0.01375f, 0.00325f}, {0.01375f, 0.059f, 0.097f, 0.059f, 0.01375f}, {0.0235f, 0.097f, 0.159f, 0.097f, 0.0235f}, {0.01375f, 0.059f, 0.097f, 0.059f, 0.01375f}, {0.00325f, 0.01375f, 0.0235f, 0.01375f, 0.00325f}};

    public static void fillBlocks(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ, Block block) {
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    world.func_147449_b(x + i, y + k, z + j, block);
                }
            }
        }
    }

    public static void fillBlocksAir(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    world.func_147449_b(x + i, y + k, z + j, Blocks.field_150350_a);
                }
            }
        }
    }

    public static void fillBlocksWithMeta(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ, Block block, int meta, int type) {
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    world.func_147465_d(x + i, y + k, z + j, block, meta, type);
                }
            }
        }
    }

    public static void fillBlocksHollow(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ, Block block) {
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    if (j != 0 && j != sizeZ - 1 && i != 0 && i != sizeX - 1) continue;
                    world.func_147449_b(x + i, y + k, z + j, block);
                }
            }
        }
    }

    public static int getGroundY(World world, int x, int z) {
        return world.func_72976_f(x, z) - 1;
    }

    public static void flattenArea(World world, int posX, int posZ, int sizeX, int sizeZ, int maxHeightDiff) {
        int heightSum = 0;
        int count = sizeX * sizeZ;
        int min = -1;
        int max = 0;
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                heights.add(new Integer(y));
                heightSum += y;
                if (y > max) {
                    max = y;
                }
                if (y >= min && min != -1) continue;
                min = y;
            }
        }
        int span = max - min;
        float median = 0.0f;
        Collections.sort(heights);
        if (heights.size() > 2) {
            median = heights.size() % 2 == 0 ? (float)(((Integer)heights.get((int)Math.floor(heights.size() / 2) - 1) + (Integer)heights.get((int)Math.ceil(heights.size() / 2) - 1)) / 2) : (float)((Integer)heights.get(heights.size() / 2 - 1)).intValue();
        }
        float averageHeight = median;
        float f = averageHeight - (float)maxHeightDiff / 2.0f;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                int newY = span <= maxHeightDiff ? y : Math.round((float)(y - min) / (float)span * (float)maxHeightDiff + f);
                BlockUtils.adjustHeightAtPos(world, posX + x, posZ + z, y, newY);
            }
        }
    }

    public static void flattenAreaToMaxHeight(World world, int posX, int posZ, int sizeX, int sizeZ) {
        int y;
        int z;
        int x;
        int max = 0;
        for (x = 0; x < sizeX; ++x) {
            for (z = 0; z < sizeZ; ++z) {
                y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                if (y <= max) continue;
                max = y;
            }
        }
        for (x = 0; x < sizeX; ++x) {
            for (z = 0; z < sizeZ; ++z) {
                y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                int newY = max;
                BlockUtils.adjustHeightAtPos(world, posX + x, posZ + z, y, newY);
            }
        }
    }

    private static void adjustHeightAtPos(World world, int x, int z, int y, int newY) {
        block4: {
            block3: {
                if (newY <= y) break block3;
                Block b = world.func_147439_a(x, y, z);
                if (!BlockUtils.isGroundBlock(b)) {
                    b = Blocks.field_150346_d;
                }
                int m = world.func_72805_g(x, y, z);
                for (int i = y + 1; i <= newY; ++i) {
                    world.func_147465_d(x, i, z, b, m, 2);
                }
                break block4;
            }
            if (newY >= y) break block4;
            for (int i = y; i > newY; --i) {
                world.func_147468_f(x, i, z);
            }
        }
    }

    private static boolean isGroundBlock(Block b) {
        Material mat = b.func_149688_o();
        return mat == Material.field_151578_c || mat == Material.field_151577_b || mat == Material.field_151576_e || mat == Material.field_151595_p || mat == Material.field_151571_B;
    }

    public static void apply2DHeightmapFilter(World world, int posX, int posZ, int sizeX, int sizeZ, float[][] filter) {
        int xoffset = -filter.length / 2;
        int zoffset = -filter[0].length / 2;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                float newY = 0.0f;
                for (int i = 0; i < filter.length; ++i) {
                    for (int j = 0; j < filter[i].length; ++j) {
                        newY += ((float)BlockUtils.getHeightValueNoTrees(world, posX + x + xoffset + i, posZ + z + zoffset + j) - 1.0f) * filter[i][j];
                    }
                }
                BlockUtils.adjustHeightAtPos(world, posX + x, posZ + z, y, Math.round(newY));
            }
        }
    }

    @Deprecated
    public static void removeJunkInAreaOLD(World world, int posX, int posZ, int sizeX, int sizeZ) {
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                boolean stop = false;
                for (int y = world.func_72976_f(posX + x, posZ + z) - 1; y > 0 && !stop; --y) {
                    Block b = world.func_147439_a(posX + x, y, posZ + z);
                    if (!BlockUtils.isGroundBlock(b)) {
                        world.func_147468_f(posX + x, y, posZ + z);
                        continue;
                    }
                    stop = true;
                }
            }
        }
    }

    public static void removeJunkInArea(World world, int posX, int posZ, int sizeX, int sizeZ) {
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                boolean stop = false;
                for (int y = BlockUtils.getHeightValueTopBlockAll(world, posX + x, posZ + z); y > 0 && !stop; --y) {
                    Block b = world.func_147439_a(posX + x, y, posZ + z);
                    if (!BlockUtils.isGroundBlock(b)) {
                        world.func_147468_f(posX + x, y, posZ + z);
                        continue;
                    }
                    stop = true;
                }
            }
        }
    }

    public static int getBlockForgeDirMeta(BlockType type, ForgeDirection fdir) {
        int dir = 0;
        switch (fdir) {
            case DOWN: {
                dir = 4;
                break;
            }
            case EAST: {
                dir = 2;
                break;
            }
            case NORTH: {
                dir = 1;
                break;
            }
            case SOUTH: {
                dir = 3;
                break;
            }
            case UP: {
                dir = 5;
                break;
            }
            default: {
                dir = 0;
            }
        }
        return BlockUtils.getBlockDirMeta(type, dir);
    }

    public static int getBlockDirMeta(BlockType type, int direction) {
        switch (type) {
            case DOOR: {
                switch (direction) {
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                }
                break;
            }
            case FENCE_GATE: {
                return (direction + 1) % 4;
            }
            case LADDER: {
                switch (direction) {
                    case 0: {
                        return 5;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 2;
                    }
                }
                break;
            }
            case STAIRS: {
                switch (direction) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 3;
                    }
                }
                break;
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public static void setBlock(World world, int posX, int posY, int posZ, MBlock mblock, int rotationOffset) {
        mblock.setBlock(world, posX, posY, posZ, rotationOffset);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, MultiMBlock mblock, int rotationOffset) {
        mblock.setBlock(world, posX, posY, posZ, rotationOffset);
    }

    public static void setBlockRotated(World world, MBlock mblock, int posX, int posY, int posZ, int x, int z, int cntX, int cntZ, int rotation) {
        int a = x - cntX;
        int b = z - cntZ;
        for (int i = 0; i < rotation; ++i) {
            int a2 = a;
            a = b;
            b = -a2;
        }
        x = a + cntX;
        z = b + cntZ;
        BlockUtils.setBlock(world, posX + x, posY, posZ + z, mblock, rotation);
    }

    public static void setBlockRotatedReplaceAirOnly(World world, MBlock mblock, int posX, int posY, int posZ, int x, int z, int cntX, int cntZ, int rotation) {
        int a = x - cntX;
        int b = z - cntZ;
        for (int i = 0; i < rotation; ++i) {
            int a2 = a;
            a = b;
            b = -a2;
        }
        x = a + cntX;
        z = b + cntZ;
        if (world.func_147437_c(posX + x, posY, posZ + z)) {
            BlockUtils.setBlock(world, posX + x, posY, posZ + z, mblock, rotation);
        }
    }

    public static boolean exists(String path, String postfix) {
        ResourceLocation rl = new ResourceLocation("techguns", "textures/blocks/" + path + postfix + ".png");
        try {
            Minecraft.func_71410_x().func_110442_L().func_135056_b(rl);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static int getHeightValueTopBlockAll(World w, int xCoord, int zCoord) {
        Chunk chunk = w.func_72938_d(xCoord, zCoord);
        int x = xCoord;
        int z = zCoord;
        xCoord &= 0xF;
        zCoord &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            Block block = chunk.func_150810_a(xCoord, k, zCoord);
            if (block.isAir((IBlockAccess)w, x, k, z)) continue;
            return k + 1;
        }
        return -1;
    }

    public static int getHeightValueNoTrees(World w, int x, int z) {
        int y = BlockUtils.getTopSolidOrLiquidBlock(w, x, z);
        Block b = w.func_147439_a(x, y, z);
        while (y > 0 && (b.isLeaves((IBlockAccess)w, x, y, z) || b.isWood((IBlockAccess)w, x, y, z) || b.isFoliage((IBlockAccess)w, x, y, z))) {
            b = w.func_147439_a(x, --y, z);
        }
        return y;
    }

    public static int getHeightValueNoTreesIgnoreLiquid(World w, int x, int z) {
        int y = w.func_72825_h(x, z);
        Block b = w.func_147439_a(x, y, z);
        if (b.func_149688_o().func_76224_d()) {
            return -1;
        }
        while (y > 0 && (b.isLeaves((IBlockAccess)w, x, y, z) || b.isWood((IBlockAccess)w, x, y, z) || b.isFoliage((IBlockAccess)w, x, y, z))) {
            b = w.func_147439_a(x, --y, z);
        }
        return y;
    }

    private static int getTopSolidOrLiquidBlock(World w, int posx, int posz) {
        Chunk chunk = w.func_72938_d(posx, posz);
        int x = posx;
        int z = posz;
        posx &= 0xF;
        posz &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            Block block = chunk.func_150810_a(posx, k, posz);
            if ((!block.func_149688_o().func_76230_c() || block.func_149688_o() == Material.field_151584_j || block.isFoliage((IBlockAccess)w, x, k, z)) && !block.func_149688_o().func_76224_d()) continue;
            return k + 1;
        }
        return -1;
    }

    public static boolean blockIsValidSpawn(Block b) {
        return !b.func_149688_o().func_76224_d();
    }

    private static int getMedianHeight(int h0, int h1, int h2, int h3) {
        int[] height = new int[]{h0, h1, h2, h3};
        Arrays.sort(height);
        return (height[1] + height[2]) / 2;
    }

    public static int getValidSpawnY(World world, int x, int z, int sizeX, int sizeZ, int heightDiffLimit) {
        int h0 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x, z);
        int h1 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x + sizeX, z);
        int h2 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x, z + sizeZ);
        int h3 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x + sizeX, z + sizeZ);
        if (h0 < 0 || h1 < 0 || h2 < 0 || h3 < 0) {
            return -1;
        }
        if (MathUtil.abs(h0 - h1) >= heightDiffLimit || MathUtil.abs(h0 - h2) >= heightDiffLimit || MathUtil.abs(h0 - h3) >= heightDiffLimit) {
            return -1;
        }
        return BlockUtils.getMedianHeight(h0, h1, h2, h3);
    }

    public static BiomeColorType getBiomeType(World world, int posX, int posZ) {
        BiomeGenBase biome = world.func_72807_a(posX, posZ);
        if (biome == BiomeGenBase.field_76787_r || biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s || biome == BiomeGenBase.field_150589_Z || biome == BiomeGenBase.field_150608_ab || biome == BiomeGenBase.field_150607_aa || biome == BiomeGenBase.field_150588_X || biome == BiomeGenBase.field_150587_Y) {
            return BiomeColorType.DESERT;
        }
        if (biome == BiomeGenBase.field_150577_O || biome == BiomeGenBase.field_150584_S || biome == BiomeGenBase.field_150579_T || biome == BiomeGenBase.field_76776_l || biome == BiomeGenBase.field_76777_m || biome == BiomeGenBase.field_76775_o || biome == BiomeGenBase.field_76774_n || biome == BiomeGenBase.field_150578_U || biome == BiomeGenBase.field_150581_V || biome == BiomeGenBase.field_76768_g || biome == BiomeGenBase.field_76784_u) {
            return BiomeColorType.SNOW;
        }
        if (biome == BiomeGenBase.field_76778_j) {
            return BiomeColorType.NETHER;
        }
        return BiomeColorType.WOODLAND;
    }

    public static short[][] loadStructureFromFile(String filename) {
        try {
            String line;
            String path = FILEPATH + filename;
            BufferedReader br = new BufferedReader(new InputStreamReader(Structure.class.getResourceAsStream(path)));
            int count = Integer.parseInt(br.readLine());
            short[][] blocks = new short[count][4];
            int i = 0;
            while ((line = br.readLine()) != null) {
                String[] s = line.split(",");
                for (int j = 0; j < s.length; ++j) {
                    blocks[i][j] = Short.parseShort(s[j]);
                }
                ++i;
            }
            return blocks;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new short[0][0];
        }
    }

    public static void placeScannedStructure(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass) {
        for (int i = 0; i < blocks.length; ++i) {
            short x = blocks[i][0];
            short y = blocks[i][1];
            short z = blocks[i][2];
            MBlock block = blockList.get(blocks[i][3]);
            if (block.pass != pass) continue;
            BlockUtils.setBlockRotated(world, block, posX, posY + y, posZ, x, z, centerX, centerZ, rotation);
        }
    }

    public static void placeFoundation(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass, int range) {
        for (int i = 0; i < blocks.length; ++i) {
            short x = blocks[i][0];
            short y = blocks[i][1];
            short z = blocks[i][2];
            if (y != 0) continue;
            MBlock block = blockList.get(blocks[i][3]);
            if (block.pass != pass) continue;
            for (int o = 1; o <= range; ++o) {
                BlockUtils.setBlockRotatedReplaceAirOnly(world, block, posX, posY - o, posZ, x, z, centerX, centerZ, rotation);
            }
        }
    }

    public static List<Entity> selectEntitiesWithinAABB(World world, AxisAlignedBB bb, IEntitySelector filter) {
        int i = MathHelper.func_76128_c((double)((bb.field_72340_a - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((bb.field_72336_d + World.MAX_ENTITY_RADIUS) / 16.0));
        int k = MathHelper.func_76128_c((double)((bb.field_72339_c - World.MAX_ENTITY_RADIUS) / 16.0));
        int l = MathHelper.func_76128_c((double)((bb.field_72334_f + World.MAX_ENTITY_RADIUS) / 16.0));
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                Chunk chunk = world.func_72964_e(i1, j1);
                if (chunk == null) continue;
                BlockUtils.getEntitiesWithinAAAB(chunk, bb, arraylist, filter);
            }
        }
        return arraylist;
    }

    private static void getEntitiesWithinAAAB(Chunk chunk, AxisAlignedBB bb, List entityList, IEntitySelector filter) {
        int i = MathHelper.func_76128_c((double)((bb.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((bb.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(chunk.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(chunk.field_76645_j.length - 1));
        for (int k = i; k <= j; ++k) {
            List list1 = chunk.field_76645_j[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity = (Entity)list1.get(l);
                if (!entity.field_70121_D.func_72326_a(bb) || filter != null && !filter.func_82704_a(entity)) continue;
                entityList.add(entity);
            }
        }
    }

    public static void fillSphere(World world, int posX, int posY, int posZ, float radius, MBlock block) {
        Vec3 center = Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
        float rsquared = (float)Math.pow(radius, 2.0);
        int r = (int)radius;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int x = posX + i;
                    int y = posY + j;
                    int z = posZ + k;
                    Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    float dsquared = (float)center.func_72436_e(v);
                    if (!(dsquared < rsquared)) continue;
                    block.setBlock(world, x, y, z, 0);
                }
            }
        }
    }

    public static void fillSphere2(World world, int posX, int posY, int posZ, float radius, MBlock block1, MBlock block2) {
        BlockUtils.fillSphere2(world, posX, posY, posZ, radius, 1.0f, block1, block2);
    }

    public static void fillSphere2(World world, int posX, int posY, int posZ, float radius, float thickness, MBlock block1, MBlock block2) {
        Vec3 center = Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
        float rsquared = (float)Math.pow(radius, 2.0);
        float rsquared2 = (float)Math.pow(radius - thickness, 2.0);
        int r = (int)radius;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int x = posX + i;
                    int y = posY + j;
                    int z = posZ + k;
                    Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    float dsquared = (float)center.func_72436_e(v);
                    if (dsquared < rsquared2) {
                        block1.setBlock(world, x, y, z, 0);
                        continue;
                    }
                    if (!(dsquared < rsquared)) continue;
                    block2.setBlock(world, x, y, z, 0);
                }
            }
        }
    }

    public static void fillCylinder(World world, int x1, int y1, int z1, int x2, int y2, int z2, float radius, MBlock block1, MBlock block2) {
        Vec3 v1 = Vec3.func_72443_a((double)x1, (double)y1, (double)z1);
        Vec3 v2 = Vec3.func_72443_a((double)x2, (double)y2, (double)z2);
        Vec3 v2v1 = v2.func_72444_a(v1);
        double l = v2v1.func_72433_c();
        int tmp = 0;
        if (x1 > x2) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y1 > y2) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        if (z1 > z2) {
            tmp = z2;
            z2 = z1;
            z1 = tmp;
        }
        int r = (int)radius;
        for (int x = x1 - r; x < x2 + r; ++x) {
            for (int y = y1 - r; y < y2 + r; ++y) {
                for (int z = z1 - r; z < z2 + r; ++z) {
                    Vec3 v0 = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    Vec3 v1v0 = v0.func_72444_a(v1);
                    Vec3 v_ = v2v1.func_72431_c(v1v0);
                    double distance = v_.func_72433_c() / l;
                    if (distance < (double)(radius - 1.0f)) {
                        block1.setBlock(world, x, y, z, 0);
                        continue;
                    }
                    if (!(distance < (double)radius)) continue;
                    block2.setBlock(world, x, y, z, 0);
                }
            }
        }
    }

    public static void drawLine(World world, int x1, int y1, int z1, int x2, int y2, int z2, MBlock block) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int ax = Math.abs(dx) << 1;
        int ay = Math.abs(dy) << 1;
        int az = Math.abs(dz) << 1;
        int signx = (int)Math.signum(dx);
        int signy = (int)Math.signum(dy);
        int signz = (int)Math.signum(dz);
        int x = x1;
        int y = y1;
        int z = z1;
        if (ax >= Math.max(ay, az)) {
            int deltay = ay - (ax >> 1);
            int deltaz = az - (ax >> 1);
            while (true) {
                block.setBlock(world, x, y, z, 0);
                if (x == x2) {
                    return;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ax;
                }
                x += signx;
                deltay += ay;
                deltaz += az;
            }
        }
        if (ay >= Math.max(ax, az)) {
            int deltax = ax - (ay >> 1);
            int deltaz = az - (ay >> 1);
            while (true) {
                block.setBlock(world, x, y, z, 0);
                if (y == y2) {
                    return;
                }
                if (deltax >= 0) {
                    block.setBlock(world, x + signx, y, z, 0);
                    x += signx;
                    deltax -= ay;
                }
                if (deltaz >= 0) {
                    block.setBlock(world, x, y, z + signz, 0);
                    z += signz;
                    deltaz -= ay;
                }
                y += signy;
                deltax += ax;
                deltaz += az;
            }
        }
        if (az >= Math.max(ax, ay)) {
            int deltax = ax - (az >> 1);
            int deltay = ay - (az >> 1);
            while (true) {
                block.setBlock(world, x, y, z, 0);
                if (z == z2) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= az;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= az;
                }
                z += signz;
                deltax += ax;
                deltay += ay;
            }
        }
    }

    public static enum BiomeColorType {
        WOODLAND,
        SNOW,
        DESERT,
        NETHER;

    }

    public static enum BlockType {
        STAIRS,
        LADDER,
        DOOR,
        FENCE_GATE,
        TG,
        BED,
        STAIRS2_CHISEL;

    }
}

