/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.TGItems;
import techguns.inventory.FabricatorRecipe;
import techguns.inventory.ItemStackOreDict;
import techguns.tileentities.FabricatorTileEntSlave;
import techguns.tileentities.MultiBlockMasterTileEntBase;
import techguns.util.BlockCoords;

public class FabricatorTileEntMaster
extends MultiBlockMasterTileEntBase {
    public static byte SLOT_INPUT = 0;
    public static byte SLOT_WIRES = 1;
    public static byte SLOT_POWDER = (byte)2;
    public static byte SLOT_PLATE = (byte)3;
    public static byte SLOT_OUTPUT = (byte)4;
    public static byte SLOT_UPGRADE = (byte)5;
    public static short RF_TICK = (short)80;
    public byte dir;
    public boolean haspower = false;
    public ItemStack plateUsed;

    public FabricatorTileEntMaster() {
        super(6, 100000);
        this.complete = false;
        this.dir = 0;
        this.useRangeSquared = 64.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.complete) {
            return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 1.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 2), (double)((double)this.field_145849_e + 1.5));
        }
        return super.getRenderBoundingBox();
    }

    public void setComplete(boolean complete, byte dir) {
        super.setComplete(complete);
        this.dir = dir;
    }

    public int[] func_94128_d(int side) {
        if (!this.complete || side == this.dir) {
            return new int[0];
        }
        return new int[]{SLOT_INPUT, SLOT_WIRES, SLOT_POWDER, SLOT_PLATE, SLOT_OUTPUT};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (!this.complete || side == this.dir) {
            return false;
        }
        return slot == SLOT_INPUT || slot == SLOT_WIRES || slot == SLOT_POWDER || slot == SLOT_PLATE;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        if (!this.complete || side == this.dir) {
            return false;
        }
        return slot == SLOT_OUTPUT;
    }

    public String func_145825_b() {
        return "techguns.container.fabricator";
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return this.getValidSlotForItemInMachine(item) == slot;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        if (this.complete) {
            return dir.ordinal() != this.dir;
        }
        return false;
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        NBTTagCompound plate;
        super.readEntityDataFromNBT(tags);
        if (this.complete) {
            this.haspower = tags.func_74767_n("hasPower");
            this.dir = tags.func_74771_c("dir");
        }
        this.plateUsed = (plate = tags.func_74775_l("plateUsed")).func_82582_d() ? null : ItemStack.func_77949_a((NBTTagCompound)plate);
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        if (this.complete) {
            tags.func_74757_a("hasPower", this.haspower);
            tags.func_74774_a("dir", this.dir);
        }
        if (this.plateUsed != null) {
            NBTTagCompound plate = new NBTTagCompound();
            this.plateUsed.func_77955_b(plate);
            tags.func_74782_a("plateUsed", (NBTBase)plate);
        }
    }

    @Override
    public void notifiyMultiblockBreak() {
        this.unform();
    }

    public void unform() {
        if (this.isComplete()) {
            BlockCoords masterPos = new BlockCoords(this);
            ArrayList<BlockCoords> positions = null;
            if (this.dir == 2) {
                positions = masterPos.getBoxWithOffsets(0, 1, 0, 1, 0, 1, false);
            } else if (this.dir == 3) {
                positions = masterPos.getBoxWithOffsets(-1, 0, 0, 1, -1, 0, false);
            } else if (this.dir == 4) {
                positions = masterPos.getBoxWithOffsets(0, 1, 0, 1, -1, 0, false);
            } else if (this.dir == 5) {
                positions = masterPos.getBoxWithOffsets(-1, 0, 0, 1, 0, 1, false);
            }
            if (positions != null) {
                for (int i = 0; i < positions.size(); ++i) {
                    BlockCoords pos = positions.get(i);
                    TileEntity tile = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
                    if (tile == null || !(tile instanceof FabricatorTileEntSlave)) continue;
                    FabricatorTileEntSlave slave = (FabricatorTileEntSlave)tile;
                    slave.unlink();
                    slave.needUpdate();
                }
            }
            this.setComplete(false, (byte)0);
            this.needUpdate();
        }
    }

    private boolean itemStackInList(ArrayList<ItemStackOreDict> list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStackOreDict orestack = list.get(i);
            if (!orestack.isEqualWithOreDict(stack)) continue;
            return true;
        }
        return false;
    }

    public int getValidSlotForItemInMachine(ItemStack stack) {
        if (this.itemStackInList(FabricatorRecipe.items_wireslot, stack)) {
            return SLOT_WIRES;
        }
        if (this.itemStackInList(FabricatorRecipe.items_powderslot, stack)) {
            return SLOT_POWDER;
        }
        if (this.itemStackInList(FabricatorRecipe.items_plateslot, stack)) {
            return SLOT_PLATE;
        }
        if (stack.func_77973_b() == TGItems.sharedItem && stack.func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return SLOT_UPGRADE;
        }
        return SLOT_INPUT;
    }

    protected int getStackMultiplier() {
        ItemStack upgrades = this.content[SLOT_UPGRADE];
        if (upgrades != null && upgrades.func_77973_b() == TGItems.sharedItem && upgrades.func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return Math.min(upgrades.field_77994_a + 1, 8);
        }
        return 1;
    }

    private void consume(int slot, int amount) {
        if (this.content[slot] != null) {
            this.content[slot].field_77994_a -= amount;
            if (this.content[slot].field_77994_a <= 0) {
                this.content[slot] = null;
            }
        }
    }

    public boolean checkAndStartOperation() {
        FabricatorRecipe.RecipeData data = FabricatorRecipe.getRecipeDataFor(this.content[SLOT_INPUT], this.content[SLOT_WIRES], this.content[SLOT_POWDER], this.content[SLOT_PLATE], this.getStackMultiplier(), this.content[SLOT_OUTPUT]);
        if (data != null) {
            ItemStack plate;
            this.currentOperation = data.output.func_77946_l();
            this.currentOperation.field_77994_a = data.outputAmount;
            if (data.plateConsumption > 0 && (plate = this.content[SLOT_PLATE]) != null) {
                this.plateUsed = plate.func_77946_l();
                this.plateUsed.field_77994_a = 1;
            }
            this.consume(SLOT_INPUT, data.inputConsumption * data.stackMultiplier);
            this.consume(SLOT_WIRES, data.wireConsumption * data.stackMultiplier);
            this.consume(SLOT_POWDER, data.powderConsumption * data.stackMultiplier);
            this.consume(SLOT_PLATE, data.plateConsumption * data.stackMultiplier);
            this.stackmultiplier = data.stackMultiplier;
            this.progress = 0;
            this.totalTime = 100;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.consumePower(RF_TICK * this.stackmultiplier)) {
                    ++this.progress;
                    if (this.field_145850_b.field_72995_K) {
                        this.playAmbientSound();
                    }
                    if (!this.field_145850_b.field_72995_K && this.progress >= this.totalTime) {
                        if (this.content[SLOT_OUTPUT] == null) {
                            this.content[FabricatorTileEntMaster.SLOT_OUTPUT] = new ItemStack(this.currentOperation.func_77973_b(), this.currentOperation.field_77994_a * this.stackmultiplier, this.currentOperation.func_77960_j());
                        } else {
                            this.content[FabricatorTileEntMaster.SLOT_OUTPUT].field_77994_a += this.currentOperation.field_77994_a * this.stackmultiplier;
                        }
                        this.progress = 0;
                        this.totalTime = 0;
                        this.currentOperation = null;
                        this.stackmultiplier = 1;
                        this.plateUsed = null;
                        this.checkAndStartOperation();
                        this.needUpdate();
                    }
                }
            } else if (!this.field_145850_b.field_72995_K && this.checkAndStartOperation()) {
                this.needUpdate();
            }
        }
    }

    private void playAmbientSound() {
        if (this.progress == 1) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.fabricatorWork", 1.0f, 1.0f, true);
        }
    }
}

