/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.Techguns;
import techguns.tileentities.BasicInventoryTileEnt;
import techguns.util.BlockCoords;

public class ExplosiveChargeTileEnt
extends BasicInventoryTileEnt {
    public byte orientation = 0;
    protected short maxBlastradius = (short)3;
    protected short minBlastradius = (short)3;
    protected short minBlastLength = (short)2;
    protected short maxBlastLength = (short)5;
    protected short minFuseTime = (short)60;
    protected short maxFuseTime = (short)200;
    protected short blastradius = (short)3;
    protected short blastlength = (short)3;
    protected short fusetime = (short)100;
    protected boolean armed = false;
    protected String soundInit = "techguns:tntcharge.init";
    protected String soundTick = "techguns:tntcharge.tick";
    protected String soundPlant = "techguns:tntcharge.plant";

    public String getSoundPlant() {
        return this.soundPlant;
    }

    protected int getBladRadiusForCuboid() {
        return this.blastradius / 2;
    }

    public void func_145845_h() {
        if (this.armed) {
            this.fusetime = (short)(this.fusetime - 1);
            if (!this.field_145850_b.field_72995_K && this.fusetime > 0 && this.fusetime % 20 == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.soundTick, 4.0f, 1.0f);
            }
            if (this.fusetime <= 0) {
                BlockCoords pos = new BlockCoords(this);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72908_a((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, "random.explode", 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                }
                pos.shift(this.getDirection(), 1);
                ArrayList<BlockCoords> blocks = pos.getCuboid(this.getDirection(), this.getBladRadiusForCuboid(), this.blastlength, this.blastradius % 2 == 0);
                for (BlockCoords coords : blocks) {
                    Block block = this.field_145850_b.func_147439_a(coords.x, coords.y, coords.z);
                    if (!(block.func_149712_f(this.field_145850_b, coords.x, coords.y, coords.z) >= 0.0f)) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        block.func_149697_b(this.field_145850_b, coords.x, coords.y, coords.z, this.field_145850_b.func_72805_g(coords.x, coords.y, coords.z), 0);
                        this.field_145850_b.func_147449_b(coords.x, coords.y, coords.z, Blocks.field_150350_a);
                        continue;
                    }
                    if (!(this.field_145850_b.field_73012_v.nextFloat() > 0.5f)) continue;
                    Techguns.proxy.spawnParticle("LargeSmoke", this.field_145850_b, (double)coords.x + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)coords.y + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)coords.z + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, 0.0, 0.045f, 0.0);
                    Techguns.proxy.spawnParticle("Explosion", this.field_145850_b, (double)coords.x + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)coords.y + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)coords.z + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, 0.0, 0.045f, 0.0);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
                }
            }
        }
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.orientation = tags.func_74771_c("orientation");
        this.blastradius = tags.func_74765_d("blastradius");
        this.blastlength = tags.func_74765_d("blastlength");
        this.fusetime = tags.func_74765_d("fusetime");
        this.armed = tags.func_74767_n("armed");
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74774_a("orientation", this.orientation);
        tags.func_74777_a("blastradius", this.blastradius);
        tags.func_74777_a("blastlength", this.blastlength);
        tags.func_74777_a("fusetime", this.fusetime);
        tags.func_74757_a("armed", this.armed);
    }

    public ExplosiveChargeTileEnt() {
        super(0);
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    public String func_145825_b() {
        return "techguns.inventory.explosivecharge";
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return false;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte orientation) {
        this.orientation = orientation;
    }

    public short getBlastradius() {
        return this.blastradius;
    }

    public short getBlastlength() {
        return this.blastlength;
    }

    public short getFusetime() {
        return this.fusetime;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public ForgeDirection getDirection() {
        if (this.orientation == 0) {
            return ForgeDirection.UP;
        }
        if (this.orientation == 1) {
            return ForgeDirection.DOWN;
        }
        if (this.orientation == 2) {
            return ForgeDirection.SOUTH;
        }
        if (this.orientation == 3) {
            return ForgeDirection.NORTH;
        }
        if (this.orientation == 4) {
            return ForgeDirection.EAST;
        }
        if (this.orientation == 5) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply) {
        if (!this.armed) {
            if (id == 0 && this.func_70300_a(ply)) {
                this.armed = true;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.soundInit, 4.0f, 1.0f);
                    this.needUpdate();
                }
            } else if (id == 1) {
                if (this.blastradius < this.maxBlastradius) {
                    this.blastradius = (short)(this.blastradius + 1);
                    this.needUpdate();
                }
            } else if (id == 2) {
                if (this.blastradius > this.minBlastradius) {
                    this.blastradius = (short)(this.blastradius - 1);
                    this.needUpdate();
                }
            } else if (id == 3) {
                if (this.blastlength < this.maxBlastLength) {
                    this.blastlength = (short)(this.blastlength + 1);
                    this.needUpdate();
                }
            } else if (id == 4) {
                if (this.blastlength > this.minBlastLength) {
                    this.blastlength = (short)(this.blastlength - 1);
                    this.needUpdate();
                }
            } else if (id == 5) {
                if (this.fusetime < this.maxFuseTime) {
                    this.fusetime = (short)(this.fusetime + 20);
                    this.needUpdate();
                }
            } else if (id == 6 && this.fusetime > this.minFuseTime) {
                this.fusetime = (short)(this.fusetime - 20);
                this.needUpdate();
            }
        }
    }
}

