/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import techguns.client.ClientProxy;

public class PacketSpawnParticle
implements IMessage {
    String name;
    double posX;
    double posY;
    double posZ;
    double motionX = 0.0;
    double motionY = 0.0;
    double motionZ = 0.0;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(String name, double posX, double posY, double posZ) {
        this.name = name;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public PacketSpawnParticle(String name, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        this.name = name;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        ByteBuf bytes = buf.readBytes((int)len);
        this.name = new String(bytes.array());
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.motionX = buf.readDouble();
        this.motionY = buf.readDouble();
        this.motionZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        byte[] bytes = this.name.getBytes();
        buf.writeShort(bytes.length);
        buf.writeBytes(bytes);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticle, IMessage> {
        public IMessage onMessage(PacketSpawnParticle m, MessageContext ctx) {
            ClientProxy.get().createFX(m.name, Minecraft.func_71410_x().field_71439_g.field_70170_p, m.posX, m.posY, m.posZ, m.motionX, m.motionY, m.motionZ);
            return null;
        }
    }
}

