/*
 * Decompiled with CFR 0.152.
 */
package techguns.inventory;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class AmmoPressRecipe {
    public static ArrayList<AmmoPressRecipe> recipes = new ArrayList();
    protected ItemStack output;
    protected ItemStack[] inputs;

    public AmmoPressRecipe(ItemStack output, ItemStack[] inputs) {
        this.output = output;
        this.inputs = inputs;
    }

    public AmmoPressRecipe(ItemStack output, String[] inputs, int[] count) {
        this.output = output;
        this.inputs = new ItemStack[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            ArrayList ores = OreDictionary.getOres((String)inputs[i]);
            if (!ores.isEmpty()) {
                this.inputs[i] = (ItemStack)ores.get(0);
                this.inputs[i].field_77994_a = count[i];
                continue;
            }
            System.out.println("No Ore known for " + inputs[i]);
        }
    }

    private boolean itemStacksEqualForRecipe(ItemStack i1, ItemStack i2) {
        return (Item.func_150891_b((Item)i1.func_77973_b()) == Item.func_150891_b((Item)i1.func_77973_b()) || OreDictionary.itemMatches((ItemStack)i1, (ItemStack)i2, (boolean)false)) && i2.field_77994_a >= i1.field_77994_a;
    }

    protected boolean isInputFor(ItemStack[] content) {
        boolean ret = true;
        for (int i = 0; i < this.inputs.length; ++i) {
            if (this.itemStacksEqualForRecipe(this.inputs[i], content[i])) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static void addRecipe(ItemStack output, ItemStack[] slots) {
        recipes.add(new AmmoPressRecipe(output, slots));
    }

    public static void addRecipe(ItemStack output, String[] inputs, int[] count) {
        recipes.add(new AmmoPressRecipe(output, inputs, count));
    }

    public static ItemStack isRecipe(ItemStack[] contents) {
        for (int i = 0; i < recipes.size(); ++i) {
            AmmoPressRecipe r = recipes.get(i);
            if (!r.isInputFor(contents)) continue;
            return r.output;
        }
        return null;
    }

    public static int[] getAmmountsForRecipe(ItemStack[] contents) {
        int[] values = new int[contents.length];
        for (int i = 0; i < recipes.size(); ++i) {
            AmmoPressRecipe r = recipes.get(i);
            if (!r.isInputFor(contents)) continue;
            for (i = 0; i < contents.length; ++i) {
                values[i] = r.inputs[i].field_77994_a;
            }
            return values;
        }
        return null;
    }
}

