/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import techguns.TGArmors;
import techguns.TGItems;
import techguns.TGuns;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.INpcTGDamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.ai.EntityAIHurtByTargetTGFactions;
import techguns.entities.ai.EntityAIRangedAttack;
import techguns.entities.npc.INPCTechgunsShooter;
import techguns.entities.npc.ITGNpcTeam;
import techguns.entities.npc.TGNpcFaction;
import techguns.items.armors.GenericArmor;
import techguns.items.guns.GenericGun;

public class GenericNPC
extends EntityMob
implements IRangedAttackMob,
INPCTechgunsShooter,
INpcTGDamageSystem,
ITGNpcTeam {
    private EntityAIRangedAttack aiRangedAttack = null;
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false);
    protected boolean hasAimedBowAnim;

    public GenericNPC(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTargetTGFactions((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
        this.hasAimedBowAnim = true;
    }

    public boolean getHasAimedBowAnim() {
        return this.hasAimedBowAnim;
    }

    private GenericGun pickRandomGun() {
        GenericGun gun;
        Random r = new Random();
        switch (r.nextInt(4)) {
            case 0: {
                gun = (GenericGun)TGuns.revolver;
                break;
            }
            case 1: {
                gun = (GenericGun)TGuns.thompson;
                break;
            }
            case 2: {
                gun = (GenericGun)TGuns.as50;
                break;
            }
            case 3: {
                gun = (GenericGun)TGuns.grimreaper;
                break;
            }
            default: {
                gun = (GenericGun)TGuns.handcannon;
            }
        }
        return gun;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "mob.villager.idle";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block block) {
        super.func_145780_a(par1, par2, par3, block);
    }

    public boolean func_70652_k(Entity target) {
        return super.func_70652_k(target);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
    }

    protected void func_70600_l(int i1) {
        if (this.func_70694_bm() != null) {
            this.func_70099_a(new ItemStack(this.func_70694_bm().func_77973_b(), 1), 0.0f);
        }
    }

    protected void func_70628_a(boolean hitByPlayer, int level) {
        int j = this.field_70146_Z.nextInt(3 + level);
        for (int k = 0; k < j; ++k) {
            ItemStack it = this.getRandomItemFromLoottable();
            if (it == null) continue;
            this.func_70099_a(TGItems.newStack(it, it.field_77994_a), 0.0f);
        }
    }

    protected ItemStack getRandomItemFromLoottable() {
        return null;
    }

    protected void func_82164_bB() {
        this.func_70062_b(0, new ItemStack((Item)this.pickRandomGun()));
        this.func_70062_b(4, new ItemStack(TGArmors.t1_combat_Helmet));
        this.func_70062_b(3, new ItemStack(TGArmors.t1_combat_Chestplate));
        this.func_70062_b(2, new ItemStack(TGArmors.t1_combat_Leggings));
        this.func_70062_b(1, new ItemStack(TGArmors.t1_combat_Boots));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_110161_a(p_110161_1_);
        this.func_82164_bB();
        this.func_82162_bC();
        this.setCombatTask();
        return p_110161_1_;
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiRangedAttack);
        ItemStack itemstack = this.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() instanceof GenericGun) {
            GenericGun gun = (GenericGun)itemstack.func_77973_b();
            this.aiRangedAttack = gun.getAIAttack(this);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiRangedAttack);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        if (this.func_70694_bm() == null) {
            return;
        }
        Item gun = this.func_70694_bm().func_77973_b();
        if (gun instanceof GenericGun) {
            EnumDifficulty difficulty = this.field_70170_p.field_73013_u;
            float acc = 1.0f;
            switch (difficulty) {
                case EASY: {
                    acc = 1.3f;
                    break;
                }
                case NORMAL: {
                    acc = 1.15f;
                    break;
                }
                case HARD: {
                    acc = 1.0f;
                    break;
                }
            }
            ((GenericGun)gun).fireWeaponFromNPC((EntityLivingBase)this, 0.5f, acc);
        }
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setCombatTask();
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
    }

    public void func_70062_b(int slot, ItemStack item) {
        super.func_70062_b(slot, item);
        if (!this.field_70170_p.field_72995_K && slot == 0) {
            this.setCombatTask();
        }
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }

    @Override
    public float getWeaponPosX() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosY() {
        return 1.6f;
    }

    @Override
    public float getWeaponPosZ() {
        return 0.0f;
    }

    @Override
    public float getTotalArmorAgainstType(TGDamageSource dmgsrc) {
        ItemStack[] inv = new ItemStack[]{this.func_71124_b(1), this.func_71124_b(2), this.func_71124_b(3), this.func_71124_b(4)};
        float totalArmor = 0.0f;
        for (ItemStack stack : inv) {
            float armorvalue;
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            if (stack.func_77973_b() instanceof GenericArmor) {
                GenericArmor genArmor = (GenericArmor)stack.func_77973_b();
                armorvalue = genArmor.getArmorValue(stack, dmgsrc.field_76373_n);
                totalArmor += armorvalue;
                continue;
            }
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            armorvalue = armor.func_82812_d().func_78044_b(armor.field_77881_a);
            armorvalue = DamageSystem.getArmorAgainstDamageTypeDefault((EntityLivingBase)this, armorvalue, dmgsrc.field_76373_n);
            totalArmor += armorvalue;
        }
        return totalArmor;
    }

    @Override
    public float getPenetrationResistance(TGDamageSource dmgsrc) {
        return 0.0f;
    }

    @Override
    public TGNpcFaction getTGFaction() {
        return TGNpcFaction.HOSTILE;
    }
}

