/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import techguns.TGItems;
import techguns.Techguns;
import techguns.damagesystem.INpcTGDamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.entities.projectiles.RocketProjectile;

public class AttackHelicopter
extends EntityFlying
implements IMob,
IBossDisplayData,
INpcTGDamageSystem {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private Entity targetedEntity;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;
    private int explosionStrength = 1;
    private static final String __OBFID = "CL_00001689";
    private float preferredHeight = 25.0f;
    private int ambientSoundTick = 0;
    public int maxDeathTime = 100;

    public AttackHelicopter(World p_i1735_1_) {
        super(p_i1735_1_);
        this.func_70105_a(10.0f, 4.0f);
        this.field_70728_aV = 50;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110182_bF() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (--this.ambientSoundTick <= 0 && this.field_70725_aQ == 0) {
            this.func_85030_a("techguns:npcs.apacheRotor", 6.0f, 1.0f);
            this.ambientSoundTick = 61;
        }
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 0) {
            this.func_85030_a("techguns:npcs.apacheDie", 6.0f, 1.0f);
        }
        ++this.field_70725_aQ;
        float yoffset = (float)(Math.pow((float)this.field_70725_aQ / (float)this.maxDeathTime, 2.0) * 10.0);
        if (this.field_70725_aQ % 5 == 0) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            Techguns.proxy.spawnParticle("LargeSmoke", this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
        }
        if (this.field_70725_aQ % 6 == 0) {
            float v = 1.0f;
            float angle = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            float x = (float)Math.cos(angle);
            float z = (float)Math.sin(angle);
            float r = 0.5f + this.field_70146_Z.nextFloat() * 0.5f;
            Techguns.proxy.spawnParticle("Fireblast", this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u - (double)yoffset, this.field_70161_v + (double)z, x * v * r, r, z * v * r);
            Techguns.proxy.spawnParticle("Fireblast", this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u - (double)yoffset, this.field_70161_v + (double)z, x * v * r * 0.75f, r, z * v * r * 0.75f);
            Techguns.proxy.spawnParticle("Fireblast", this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u - (double)yoffset, this.field_70161_v + (double)z, x * v * r * 1.25f, r, z * v * r * 1.25f);
        }
        if (this.field_70725_aQ == this.maxDeathTime) {
            if (!this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.func_85030_a("techguns:npcs.apacheExplode", 6.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                Techguns.proxy.spawnParticle("ExplosionHuge", this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f) - 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
                Techguns.proxy.spawnParticle("LargeSmoke", this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f) - 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
            }
        }
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        if ("fireball".equals(p_70097_1_.func_76355_l()) && p_70097_1_.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(p_70097_1_, 1000.0f);
            return true;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    protected void func_70626_be() {
        byte b0;
        byte b1;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        this.prevAttackCounter = this.attackCounter;
        double d0 = this.waypointX - this.field_70165_t;
        double d1 = this.waypointY - this.field_70163_u;
        double d2 = this.waypointZ - this.field_70161_v;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        if (d3 < 1.0 || d3 > 3600.0) {
            this.waypointY = this.field_70146_Z.nextFloat() > 0.25f ? (double)(this.getGroundLevel() + this.preferredHeight) : this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                this.field_70159_w += d0 / d3 * 0.1;
                this.field_70181_x += d1 / d3 * 0.1;
                this.field_70179_y += d2 / d3 * 0.1;
            } else {
                this.waypointX = this.field_70165_t;
                this.waypointY = this.field_70163_u;
                this.waypointZ = this.field_70161_v;
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.field_70170_p.func_72856_b((Entity)this, 100.0);
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
        double d4 = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < d4 * d4) {
            double d5 = this.targetedEntity.field_70165_t - this.field_70165_t;
            double d6 = this.targetedEntity.field_70121_D.field_72338_b + (double)(this.targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d7 = this.targetedEntity.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
            if (this.func_70685_l(this.targetedEntity)) {
                double pitch;
                Vec3 v2;
                Vec3 v1;
                Vec3 vec3;
                double d8;
                ++this.attackCounter;
                if (this.attackCounter > 15) {
                    if (this.attackCounter == 16) {
                        this.field_70170_p.func_72956_a((Entity)this, "techguns:npcs.apacheBurst", 5.0f, 1.0f);
                    }
                    if (this.attackCounter % 2 != 0) {
                        d8 = 8.0;
                        vec3 = this.func_70676_i(1.0f);
                        v1 = Vec3.func_72443_a((double)(this.targetedEntity.field_70165_t - this.field_70165_t), (double)0.0, (double)(this.targetedEntity.field_70161_v - this.field_70161_v)).func_72432_b();
                        v2 = Vec3.func_72443_a((double)(this.targetedEntity.field_70165_t - this.field_70165_t), (double)(this.targetedEntity.field_70163_u - (this.field_70163_u + 2.25)), (double)(this.targetedEntity.field_70161_v - this.field_70161_v)).func_72432_b();
                        pitch = Math.acos(v1.func_72430_b(v2)) * 57.29577951308232;
                        GenericProjectile bullet = new GenericProjectile(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, (float)pitch, 12.0f, 1.0f, 100, 0.05f, 30, 40, 8.0f, 0.25f, false);
                        bullet.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
                        bullet.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) - 1.5;
                        bullet.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
                        this.field_70170_p.func_72838_d((Entity)bullet);
                        float fireX = (float)(this.field_70165_t + (double)(4.0f * (float)Math.cos(Math.PI * (double)(-this.field_70761_aq) / 180.0)));
                        float fireY = (float)(this.field_70163_u - 0.25);
                        float fireZ = (float)(this.field_70161_v - (double)(4.0f * (float)Math.sin(Math.PI * (double)(-this.field_70761_aq) / 180.0)));
                        Techguns.proxy.spawnParticle("Fireblast", this.field_70170_p, fireX + (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f, fireY + (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f, fireZ + (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.attackCounter == 30) {
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                    d8 = 8.0;
                    vec3 = this.func_70676_i(1.0f);
                    v1 = Vec3.func_72443_a((double)(this.targetedEntity.field_70165_t - this.field_70165_t), (double)0.0, (double)(this.targetedEntity.field_70161_v - this.field_70161_v)).func_72432_b();
                    v2 = Vec3.func_72443_a((double)(this.targetedEntity.field_70165_t - this.field_70165_t), (double)(this.targetedEntity.field_70163_u - this.field_70163_u), (double)(this.targetedEntity.field_70161_v - this.field_70161_v)).func_72432_b();
                    pitch = Math.acos(v1.func_72430_b(v2)) * 57.29577951308232;
                    RocketProjectile rocket = new RocketProjectile(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, (float)(pitch *= 1.18), 20.0f, 2.0f, 1.0f, 100, 0.05f, 0.0f, false, 0.0f);
                    rocket.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
                    rocket.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) - 1.0;
                    rocket.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
                    this.field_70170_p.func_72838_d((Entity)rocket);
                    this.field_70170_p.func_72956_a((Entity)this, "techguns:guns.rocketFire", 5.0f, 1.0f);
                    this.attackCounter = -40;
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
        if (!this.field_70170_p.field_72995_K && (b1 = this.field_70180_af.func_75683_a(16)) != (b0 = (byte)(this.attackCounter > 10 ? 1 : 0))) {
            this.field_70180_af.func_75692_b(16, (Object)b0);
        }
    }

    private float getGroundLevel() {
        return this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v);
    }

    private boolean isCourseTraversable(double p_70790_1_, double p_70790_3_, double p_70790_5_, double p_70790_7_) {
        double d4 = (this.waypointX - this.field_70165_t) / p_70790_7_;
        double d5 = (this.waypointY - this.field_70163_u) / p_70790_7_;
        double d6 = (this.waypointZ - this.field_70161_v) / p_70790_7_;
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < p_70790_7_) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.field_70170_p.func_72945_a((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String func_70639_aQ() {
        return "";
    }

    protected String func_70621_aR() {
        return "techguns:npcs.apacheHit";
    }

    protected String func_70673_aS() {
        return "npcs.apacheHit";
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        this.func_70099_a(TGItems.newStack(TGItems.rifleBullets, 16 + this.field_70146_Z.nextInt(16)), 0.0f);
        this.func_70099_a(TGItems.newStack(TGItems.rocketAmmo, 8 + this.field_70146_Z.nextInt(8)), 0.0f);
        this.func_70099_a(TGItems.newStack(TGItems.cyberneticParts, 2 + this.field_70146_Z.nextInt(2)), 0.0f);
        this.func_70099_a(new ItemStack(Blocks.field_150339_S, 4 + this.field_70146_Z.nextInt(4)), 0.0f);
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = p_70037_1_.func_74762_e("ExplosionPower");
        }
    }

    @Override
    public float getTotalArmorAgainstType(TGDamageSource dmgsrc) {
        switch (dmgsrc.field_76373_n) {
            case EXPLOSION: {
                return 5.0f;
            }
            case LIGHTNING: 
            case ENERGY: {
                return 10.0f;
            }
            case FIRE: 
            case ICE: 
            case PHYSICAL: 
            case PROJECTILE: 
            case POISON: 
            case RADIATION: {
                return 20.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getPenetrationResistance(TGDamageSource dmgsrc) {
        switch (dmgsrc.field_76373_n) {
            case PROJECTILE: {
                return 0.4f;
            }
            case EXPLOSION: 
            case LIGHTNING: 
            case ENERGY: 
            case FIRE: 
            case ICE: 
            case PHYSICAL: 
            case POISON: 
            case RADIATION: 
            case UNRESISTABLE: {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

