/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.client.particle.EntityParticleSystem;
import techguns.client.particle.FXType;
import techguns.client.renderer.TGRenderHelper;
import techguns.util.MathUtil;

public class ParticleSystemType
extends FXType {
    TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.SOLID;
    ResourceLocation texture = new ResourceLocation("techguns:textures/fx/fireball.png");
    int rows = 1;
    int columns = 1;
    int frames = 1;
    boolean hasVariations = false;
    boolean randomRotation = false;
    int lifetimeMin = 20;
    int lifetimeMax = 20;
    int initialDelayMin = 0;
    int initialDelayMax = 0;
    float animationSpeedMin = 1.0f;
    float animationSpeedMax = 1.0f;
    float sizeMin = 1.0f;
    float sizeMax = 2.0f;
    float sizeRateMin = 1.0f;
    float sizeRateMax = 1.0f;
    float sizeRateDampingMin = 1.0f;
    float sizeRateDampingMax = 1.0f;
    float startSizeRateMin = 0.0f;
    float startSizeRateMax = 0.0f;
    float startSizeRateDampingMin = 1.0f;
    float startSizeRateDampingMax = 1.0f;
    List<ColorEntry> colorEntries = new ArrayList<ColorEntry>();
    List<AlphaEntry> alphaEntries = new ArrayList<AlphaEntry>();
    int particleCountMin = 1;
    int particleCountMax = 1;
    int spawnDelayMin = 1;
    int spawnDelayMax = 1;
    int systemLifetimeMin = 5;
    int systemLifetimeMax = 5;
    IVelocityType velocityType = VEL_SPHERICAL;
    float[] velocityDataMin = new float[3];
    float[] velocityDataMax = new float[3];
    float velocityDampingMin = 0.98f;
    float velocityDampingMax = 0.98f;
    float velocityDampingOnGroundMin = 1.0f;
    float velocityDampingOnGroundMax = 1.0f;
    float gravity = 0.02f;
    float systemVelocityFactorMin = 0.0f;
    float systemVelocityFactorMax = 0.0f;
    Vec3 offset = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    IVolumeType volumeType;
    float[] volumeData = new float[3];
    boolean isHollow;
    boolean removeOnGround = false;
    boolean particlesMoveWithSystem = false;
    public static IVelocityType VEL_ORTHO = new IVelocityType(){

        @Override
        public Vec3 getVelocity(EntityParticleSystem sys, Vec3 dir) {
            Random rand = new Random();
            Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            if (sys.type.velocityDataMin.length >= 3) {
                float x = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                float y = MathUtil.randomFloat(rand, sys.type.velocityDataMin[1], sys.type.velocityDataMax[1]);
                float z = MathUtil.randomFloat(rand, sys.type.velocityDataMin[2], sys.type.velocityDataMax[2]);
                velocity.field_72450_a = x;
                velocity.field_72448_b = y;
                velocity.field_72449_c = z;
            }
            return velocity;
        }
    };
    public static IVelocityType VEL_OUTWARD = new IVelocityType(){

        @Override
        public Vec3 getVelocity(EntityParticleSystem sys, Vec3 dir) {
            Random rand = new Random();
            Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            if (sys.type.velocityDataMin.length >= 2) {
                float r = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                float y = MathUtil.randomFloat(rand, sys.type.velocityDataMin[1], sys.type.velocityDataMax[1]);
                if (dir.field_72450_a != 0.0 || dir.field_72448_b != 0.0 || dir.field_72449_c != 0.0) {
                    velocity.field_72450_a = dir.field_72450_a * (double)r;
                    velocity.field_72449_c = dir.field_72449_c * (double)r;
                    velocity.field_72448_b = y;
                } else {
                    double angle = rand.nextDouble() * 2.0 * Math.PI;
                    velocity.field_72450_a = (double)r * Math.cos(angle);
                    velocity.field_72449_c = (double)r * Math.sin(angle);
                    velocity.field_72448_b = y;
                }
            }
            return velocity;
        }
    };
    public static IVelocityType VEL_SPHERICAL = new IVelocityType(){

        @Override
        public Vec3 getVelocity(EntityParticleSystem sys, Vec3 dir) {
            Random rand = new Random();
            Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            if (sys.type.velocityDataMin.length >= 1) {
                float r = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                if (dir.field_72450_a != 0.0 || dir.field_72448_b != 0.0 || dir.field_72449_c != 0.0) {
                    velocity.field_72450_a = dir.field_72450_a * (double)r;
                    velocity.field_72448_b = dir.field_72448_b * (double)r;
                    velocity.field_72449_c = dir.field_72449_c * (double)r;
                } else {
                    double angle = rand.nextDouble() * 2.0 * Math.PI;
                    double y = 1.0 - rand.nextDouble() * 2.0;
                    double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                    velocity.field_72450_a = (double)r * a * Math.cos(angle);
                    velocity.field_72449_c = (double)r * a * Math.sin(angle);
                    velocity.field_72448_b = (double)r * y;
                }
            }
            return velocity;
        }
    };
    public static IVelocityType VEL_HEMISPHERICAL = new IVelocityType(){

        @Override
        public Vec3 getVelocity(EntityParticleSystem sys, Vec3 dir) {
            Random rand = new Random();
            Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            if (sys.type.velocityDataMin.length >= 1) {
                float r = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                if (dir.field_72450_a != 0.0 || dir.field_72448_b != 0.0 || dir.field_72449_c != 0.0) {
                    velocity.field_72450_a = dir.field_72450_a * (double)r;
                    velocity.field_72448_b = dir.field_72448_b * (double)r;
                    velocity.field_72449_c = dir.field_72449_c * (double)r;
                } else {
                    double angle = rand.nextDouble() * 2.0 * Math.PI;
                    double y = rand.nextDouble();
                    double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                    velocity.field_72450_a = (double)r * a * Math.cos(angle);
                    velocity.field_72449_c = (double)r * a * Math.sin(angle);
                    velocity.field_72448_b = (double)r * y;
                }
            }
            return velocity;
        }
    };
    public static IVolumeType VOL_POINT = new IVolumeType(){

        @Override
        public Vec3 getPosition(EntityParticleSystem sys, Vec3 dir, int i, int count) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    };
    public static IVolumeType VOL_CYLINDER = new IVolumeType(){

        @Override
        public Vec3 getPosition(EntityParticleSystem sys, Vec3 dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 2) {
                float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                float y = rand.nextFloat() * sys.type.volumeData[1];
                dir.field_72450_a = 1.0;
                dir.field_72448_b = 0.0;
                dir.field_72449_c = 0.0;
                dir.func_72442_b(angle);
                Vec3 position = Vec3.func_72443_a((double)(dir.field_72450_a * (double)r), (double)y, (double)(dir.field_72449_c * (double)r));
                return position;
            }
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    };
    public static IVolumeType VOL_CYLINDER2 = new IVolumeType(){

        @Override
        public Vec3 getPosition(EntityParticleSystem sys, Vec3 dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 2) {
                float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                float x = rand.nextFloat() * sys.type.volumeData[1];
                dir.field_72450_a = 0.0;
                dir.field_72448_b = 1.0;
                dir.field_72449_c = 0.0;
                dir.func_72440_a(angle);
                Vec3 position = Vec3.func_72443_a((double)x, (double)(dir.field_72448_b * (double)r), (double)(dir.field_72449_c * (double)r));
                return position;
            }
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    };
    public static IVolumeType VOL_SPHERE = new IVolumeType(){

        @Override
        public Vec3 getPosition(EntityParticleSystem sys, Vec3 dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 1) {
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double y = 1.0 - rand.nextDouble() * 2.0;
                double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                dir.field_72450_a = a * Math.cos(angle);
                dir.field_72449_c = a * Math.sin(angle);
                dir.field_72448_b = y;
                Vec3 position = Vec3.func_72443_a((double)(dir.field_72450_a * (double)r), (double)(dir.field_72448_b * (double)r), (double)(dir.field_72449_c * (double)r));
                return position;
            }
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    };
    public static IVolumeType VOL_HEMISPHERE = new IVolumeType(){

        @Override
        public Vec3 getPosition(EntityParticleSystem sys, Vec3 dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 1) {
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double y = rand.nextDouble();
                double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                dir.field_72450_a = a * Math.cos(angle);
                dir.field_72449_c = a * Math.sin(angle);
                dir.field_72448_b = y;
                Vec3 position = Vec3.func_72443_a((double)(dir.field_72450_a * (double)r), (double)(dir.field_72448_b * (double)r), (double)(dir.field_72449_c * (double)r));
                return position;
            }
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    };
    public static IVolumeType VOL_TRAIL = new IVolumeType(){

        @Override
        public Vec3 getPosition(EntityParticleSystem sys, Vec3 dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 1) {
                Entity ent = sys.entity;
                if (ent == null) {
                    return Vec3.func_72443_a((double)sys.field_70165_t, (double)sys.field_70163_u, (double)sys.field_70161_v);
                }
                Vec3 motion = Vec3.func_72443_a((double)ent.field_70159_w, (double)ent.field_70181_x, (double)ent.field_70179_y).func_72432_b();
                float len = sys.type.volumeData[0];
                float t = (float)i * 1.0f / ((float)count * 1.0f) * len;
                Vec3 position = Vec3.func_72443_a((double)(-motion.field_72450_a * (double)t), (double)(-motion.field_72448_b * (double)t), (double)(-motion.field_72449_c * (double)t));
                return position;
            }
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    };

    public void extend(ParticleSystemType other) {
        this.alphaEntries = other.alphaEntries;
        this.animationSpeedMax = other.animationSpeedMax;
        this.animationSpeedMin = other.animationSpeedMin;
        this.colorEntries = other.colorEntries;
        this.columns = other.columns;
        this.frames = other.frames;
        this.gravity = other.gravity;
        this.hasVariations = other.hasVariations;
        this.initialDelayMax = other.initialDelayMin;
        this.isHollow = other.isHollow;
        this.lifetimeMax = other.lifetimeMax;
        this.lifetimeMin = other.lifetimeMin;
        this.particleCountMax = other.particleCountMax;
        this.randomRotation = other.randomRotation;
        this.removeOnGround = other.removeOnGround;
        this.renderType = other.renderType;
        this.rows = other.rows;
        this.sizeMax = other.sizeMax;
        this.sizeMin = other.sizeMin;
        this.sizeRateDampingMax = other.sizeRateDampingMax;
        this.sizeRateDampingMin = other.sizeRateDampingMin;
        this.sizeRateMax = other.sizeRateMax;
        this.sizeRateMin = other.sizeRateMin;
        this.spawnDelayMax = other.spawnDelayMax;
        this.spawnDelayMin = other.spawnDelayMin;
        this.texture = other.texture;
        this.velocityDampingMax = other.velocityDampingMax;
        this.velocityDampingMin = other.velocityDampingMin;
        this.velocityDampingOnGroundMax = other.velocityDampingOnGroundMax;
        this.velocityDampingOnGroundMin = other.velocityDampingOnGroundMin;
        this.velocityDataMax = other.velocityDataMax;
        this.velocityDataMin = other.velocityDataMin;
        this.velocityType = other.velocityType;
        this.volumeData = other.volumeData;
        this.volumeType = other.volumeType;
        this.offset = other.offset;
        this.particlesMoveWithSystem = other.particlesMoveWithSystem;
    }

    @Override
    public List<EntityParticleSystem> createParticleSystems(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        ArrayList<EntityParticleSystem> list = new ArrayList<EntityParticleSystem>();
        list.add(new EntityParticleSystem(world, this, posX, posY, posZ, motionX, motionY, motionZ));
        return list;
    }

    @Override
    public List<EntityParticleSystem> createParticleSystemsOnEntity(Entity ent) {
        ArrayList<EntityParticleSystem> list = new ArrayList<EntityParticleSystem>();
        list.add(new EntityParticleSystem(ent, this));
        return list;
    }

    public static interface IVolumeType {
        public Vec3 getPosition(EntityParticleSystem var1, Vec3 var2, int var3, int var4);
    }

    public static interface IVelocityType {
        public Vec3 getVelocity(EntityParticleSystem var1, Vec3 var2);
    }

    public static class AlphaEntry {
        float time;
        float alpha;

        public AlphaEntry(float alpha, float time) {
            this.time = time;
            this.alpha = 1.0f - alpha;
        }
    }

    public static class ColorEntry {
        float time;
        float r;
        float g;
        float b;

        public ColorEntry(int r, int g, int b, float time) {
            this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, time);
        }

        public ColorEntry(float r, float g, float b, float time) {
            this.time = time;
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

