/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import techguns.client.particle.EntityParticleSystem;
import techguns.client.particle.FXList;
import techguns.client.particle.FXType;

public class FXListType
extends FXType {
    ArrayList<ParticleSystemEntry> particleSystems = new ArrayList();

    public FXListType() {
        this.isList = true;
    }

    public void addParticleSystem(String particleSystem) {
        this.particleSystems.add(new ParticleSystemEntry(particleSystem));
    }

    @Override
    public List<EntityParticleSystem> createParticleSystems(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        ArrayList<EntityParticleSystem> list = new ArrayList<EntityParticleSystem>();
        for (ParticleSystemEntry system : this.particleSystems) {
            if (!FXList.FXList.containsKey(system.particleSystem)) continue;
            FXType fxtype = FXList.FXList.get(system.particleSystem);
            list.addAll(fxtype.createParticleSystems(world, posX, posY, posZ, motionX, motionY, motionZ));
        }
        return list;
    }

    @Override
    public List<EntityParticleSystem> createParticleSystemsOnEntity(Entity ent) {
        ArrayList<EntityParticleSystem> list = new ArrayList<EntityParticleSystem>();
        for (ParticleSystemEntry system : this.particleSystems) {
            if (!FXList.FXList.containsKey(system.particleSystem)) continue;
            FXType fxtype = FXList.FXList.get(system.particleSystem);
            list.addAll(fxtype.createParticleSystemsOnEntity(ent));
        }
        return list;
    }

    class ParticleSystemEntry {
        String particleSystem;

        public ParticleSystemEntry(String particleSystem) {
            this.particleSystem = particleSystem;
        }
    }
}

