/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.client.ClientProxy;
import techguns.client.particle.EntityParticle;
import techguns.client.particle.ParticleSystemType;
import techguns.util.MathUtil;

public class EntityParticleSystem
extends Entity
implements IEntityAdditionalSpawnData {
    ParticleSystemType type;
    int systemLifetime;
    int spawnDelay = 0;
    public float scale;
    public float field_70177_z;
    public float field_70125_A;
    public int initialDelay;
    public int field_70173_aa = 0;
    public float startSizeRate;
    public float startSizeRateDamping;
    public float startSize = 0.0f;
    Entity entity;

    public EntityParticleSystem(World world) {
        super(world);
    }

    public EntityParticleSystem(Entity entity, ParticleSystemType type) {
        this(entity.field_70170_p, type, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
        this.entity = entity;
    }

    public EntityParticleSystem(World world, ParticleSystemType type, double posX, double posY, double posZ) {
        this(world, type, posX, posY, posZ, 0.0, 0.0, 0.0);
    }

    public EntityParticleSystem(World world, ParticleSystemType type, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world);
        this.type = type;
        this.field_70165_t = posX;
        this.field_70163_u = posY;
        this.field_70161_v = posZ;
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        this.init();
    }

    protected void init() {
        this.systemLifetime = MathUtil.randomInt(this.field_70146_Z, this.type.systemLifetimeMin, this.type.systemLifetimeMax);
        this.initialDelay = MathUtil.randomInt(this.field_70146_Z, this.type.initialDelayMin, this.type.initialDelayMax);
        this.startSizeRate = MathUtil.randomFloat(this.field_70146_Z, this.type.startSizeRateMin, this.type.startSizeRateMax);
        this.startSizeRateDamping = MathUtil.randomFloat(this.field_70146_Z, this.type.startSizeRateDampingMin, this.type.startSizeRateDampingMax);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.type == null) {
            this.func_70106_y();
            return;
        }
        if (this.entity != null) {
            this.field_70165_t = this.entity.field_70165_t;
            this.field_70163_u = this.entity.field_70163_u;
            this.field_70161_v = this.entity.field_70161_v;
            this.field_70125_A = this.entity.field_70125_A;
            this.field_70177_z = this.entity.field_70177_z;
        } else {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
        }
        if (this.initialDelay-- > 0) {
            return;
        }
        this.startSize += this.startSizeRate;
        this.startSizeRate *= this.startSizeRateDamping;
        if (this.spawnDelay-- <= 0) {
            int count = MathUtil.randomInt(this.field_70146_Z, this.type.particleCountMin, this.type.particleCountMax);
            for (int i = 0; i < count; ++i) {
                Vec3 dir = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                Vec3 position = this.type.volumeType.getPosition(this, dir, i, count);
                position = position.func_72441_c(this.type.offset.field_72450_a, this.type.offset.field_72448_b, this.type.offset.field_72449_c);
                Vec3 motion = this.type.velocityType.getVelocity(this, dir);
                MathUtil.rotateAroundZ(motion, (double)this.field_70125_A * (Math.PI / 180));
                MathUtil.rotateAroundY(motion, (-90.0 - (double)this.field_70177_z) * (Math.PI / 180));
                if (this.type.volumeType != ParticleSystemType.VOL_TRAIL) {
                    MathUtil.rotateAroundZ(position, (double)this.field_70125_A * (Math.PI / 180));
                    MathUtil.rotateAroundY(position, (double)(-90.0f - this.field_70177_z) * (Math.PI / 180));
                }
                double mf = 0.05;
                EntityParticle particle = new EntityParticle(this.field_70170_p, this.field_70165_t + position.field_72450_a, this.field_70163_u + position.field_72448_b, this.field_70161_v + position.field_72449_c, motion.field_72450_a * mf, motion.field_72448_b * mf, motion.field_72449_c * mf, this);
                ClientProxy.spawnParticle(particle);
            }
            this.spawnDelay = MathUtil.randomInt(this.field_70146_Z, this.type.spawnDelayMin, this.type.spawnDelayMax);
        }
        if (this.entity != null) {
            if (this.entity.field_70128_L) {
                this.func_70106_y();
            } else if (this.systemLifetime > 0 && this.field_70173_aa >= this.systemLifetime) {
                this.func_70106_y();
            }
        } else if (this.field_70173_aa >= this.systemLifetime) {
            this.func_70106_y();
        }
        ++this.field_70173_aa;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.entity != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.entity.func_145782_y());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        boolean hasEnt = additionalData.readBoolean();
        if (hasEnt) {
            int entID = additionalData.readInt();
            this.entity = this.field_70170_p.func_73045_a(entID);
        }
    }
}

