/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines;

import com.cricketcraft.chisel.api.ICarvable;
import com.cricketcraft.chisel.api.carving.CarvableHelper;
import com.cricketcraft.chisel.api.carving.IVariationInfo;
import com.cricketcraft.chisel.api.rendering.ClientUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.Techguns;
import techguns.blocks.ItemBlockOreDrill;
import techguns.tileentities.BasicInventoryTileEnt;
import techguns.tileentities.BasicPoweredTileEnt;
import techguns.tileentities.OreDrillTileEntMaster;
import techguns.tileentities.OreDrillTileEntSlave;
import techguns.util.TextUtil;

public class OreDrillBlock
extends BlockContainer
implements ICarvable {
    private static final int MAXMETADATA_VALUE = 5;
    public CarvableHelper carverHelper = new CarvableHelper((Block)this);

    public OreDrillBlock() {
        super(Material.field_151573_f);
        this.func_149663_c("OreDrillBlock");
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(Techguns.tabTechgun);
        this.func_149711_c(8.0f);
        this.func_149752_b(20.0f);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile;
        Block block = world.func_147439_a(x, y, z);
        int x2 = x - Facing.field_71586_b[side];
        int y2 = y - Facing.field_71587_c[side];
        int z2 = z - Facing.field_71585_d[side];
        int meta = world.func_72805_g(x2, y2, z2);
        if (meta == 1 && (tile = world.func_147438_o(x2, y2, z2)) != null && ((OreDrillTileEntSlave)tile).hasMaster() && ((OreDrillTileEntSlave)tile).isBottomrow()) {
            return false;
        }
        if (meta == 2 && (tile = world.func_147438_o(x2, y2, z2)) != null && ((OreDrillTileEntSlave)tile).hasMaster()) {
            return false;
        }
        if (world.func_72805_g(x, y, z) != world.func_72805_g(x - Facing.field_71586_b[side], y - Facing.field_71587_c[side], z - Facing.field_71585_d[side])) {
            return true;
        }
        if (block == this) {
            return false;
        }
        return block == this ? false : super.func_149646_a(world, x, y, z, side);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149651_a(IIconRegister register) {
        this.carverHelper.registerBlockIcons("Techguns", (Block)this, register);
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        for (IVariationInfo info : this.carverHelper.infoList) {
            if (info.getVariation().getBlockMeta() > 4) continue;
            list.add(new ItemStack((Block)this, 1, info.getVariation().getItemMeta()));
        }
    }

    public IIcon func_149673_e(IBlockAccess b, int x, int y, int z, int side) {
        TileEntity tile;
        int meta = b.func_72805_g(x, y, z);
        if (meta != 4 && ((OreDrillTileEntSlave)(tile = b.func_147438_o(x, y, z))).hasMaster()) {
            if (meta == 3) {
                byte dir = ((OreDrillTileEntSlave)tile).getDirection();
                switch (dir) {
                    case 0: 
                    case 1: {
                        if (side != 0 && side != 1) break;
                        ++meta;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (side != 2 && side != 3) break;
                        ++meta;
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (side != 4 && side != 5) break;
                        ++meta;
                        break;
                    }
                }
            }
            meta += 8;
        }
        return this.carverHelper.getIcon(side, meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.carverHelper.getIcon(side, meta);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof OreDrillTileEntSlave) {
                OreDrillTileEntSlave slave = (OreDrillTileEntSlave)tile;
                slave.notifyMasterMultiblockBreak();
            }
            if (tile instanceof BasicInventoryTileEnt) {
                ((BasicInventoryTileEnt)tile).onBlockBreak();
            }
            world.func_147475_p(x, y, z);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i1, float f1, float f2, float f3) {
        int i;
        boolean finished;
        boolean valid;
        int rodlength;
        int enginelength;
        int[] coords;
        byte dir;
        block28: {
            TileEntity tile = world.func_147438_o(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (meta == 4 && !player.func_70093_af()) {
                OreDrillTileEntMaster mastertile = (OreDrillTileEntMaster)tile;
                if (!mastertile.isComplete()) {
                    dir = this.getDirectionForMultiblockDrill(world, x, y, z);
                    if (dir == -1) {
                        if (!world.field_72995_K) return true;
                        player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalidmulti.dir")));
                        return true;
                    }
                    coords = OreDrillBlock.getNextBlockInDir(x, y, z, dir);
                    enginelength = 0;
                    rodlength = 0;
                    valid = true;
                    finished = false;
                    break block28;
                } else {
                    if (!player.field_70170_p.field_72995_K && !mastertile.hasDrill) {
                        mastertile.checkAndStartOperation();
                    }
                    player.openGui((Object)"Techguns", 16, world, x, y, z);
                    return true;
                }
            }
            if (tile instanceof OreDrillTileEntSlave) {
                OreDrillTileEntSlave tileent = (OreDrillTileEntSlave)tile;
                int[] masterpos = tileent.getMasterPos();
                if (masterpos == null) return false;
                TileEntity master = world.func_147438_o(masterpos[0], masterpos[1], masterpos[2]);
                if (master == null) return false;
                if (!(master instanceof OreDrillTileEntMaster)) return false;
                player.openGui((Object)"Techguns", 16, world, masterpos[0], masterpos[1], masterpos[2]);
                return true;
            }
            if (!(tile instanceof OreDrillTileEntMaster)) return false;
            player.openGui((Object)"Techguns", 16, world, x, y, z);
            return true;
        }
        while (valid && !finished) {
            if (rodlength == 0) {
                if (ItemBlockOreDrill.isBlock(world, coords[0], coords[1], coords[2], (Block)TGBlocks.oreDrill, 3)) {
                    ++enginelength;
                } else if (ItemBlockOreDrill.isBlock(world, coords[0], coords[1], coords[2], (Block)TGBlocks.oreDrill, 2)) {
                    ++rodlength;
                } else {
                    valid = false;
                    if (world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid1")));
                    }
                }
                coords = OreDrillBlock.getNextBlockInDir(coords[0], coords[1], coords[2], dir);
                continue;
            }
            if (ItemBlockOreDrill.isBlock(world, coords[0], coords[1], coords[2], (Block)TGBlocks.oreDrill, 2)) {
                ++rodlength;
                coords = OreDrillBlock.getNextBlockInDir(coords[0], coords[1], coords[2], dir);
                continue;
            }
            if (ItemBlockOreDrill.isOreCluster(world, coords[0], coords[1], coords[2])) {
                finished = true;
                continue;
            }
            valid = false;
            if (!world.field_72995_K) continue;
            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid1")));
        }
        if (!valid) return false;
        coords = OreDrillBlock.getNextBlockInDir(x, y, z, dir);
        int radius = 0;
        for (i = 4; i > 0; --i) {
            if (!this.checkSliceInDir(world, coords[0], coords[1], coords[2], dir, i, 0, 0, (Block)TGBlocks.oreDrill, 3)) continue;
            radius = i;
            break;
        }
        if (radius == 0 && (enginelength > 0 || rodlength > 1)) {
            if (!world.field_72995_K) return false;
            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid2")));
            return false;
        }
        if (radius == 1 && (enginelength < 1 || rodlength < 2)) {
            if (!world.field_72995_K) return false;
            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid2.1")));
            return false;
        }
        if (radius == 2 && (enginelength < 2 || rodlength < 3)) {
            if (!world.field_72995_K) return false;
            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid2.2")));
            return false;
        }
        if (radius == 3 && (enginelength < 2 || rodlength < 3 || enginelength + rodlength < 7)) {
            if (!world.field_72995_K) return false;
            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid2.2")));
            return false;
        }
        if (radius == 4 && (enginelength < 2 || rodlength < 3 || enginelength + rodlength < 9)) {
            if (!world.field_72995_K) return false;
            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid2.2")));
            return false;
        }
        for (i = 1; i < enginelength && valid; ++i) {
            if (this.checkSliceInDir(world, (coords = OreDrillBlock.getNextBlockInDir(coords[0], coords[1], coords[2], dir))[0], coords[1], coords[2], dir, radius, 0, 1, (Block)TGBlocks.oreDrill, 3)) continue;
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid3") + " (" + coords[0] + "," + coords[1] + "," + coords[2] + ") "));
            }
            valid = false;
        }
        for (i = 1; i <= rodlength && valid; ++i) {
            coords = OreDrillBlock.getNextBlockInDir(coords[0], coords[1], coords[2], dir);
            if (i < rodlength) {
                if (this.checkSliceInDir(world, coords[0], coords[1], coords[2], dir, radius, 0, 1, Blocks.field_150350_a, -1)) continue;
                if (world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid3") + " (" + coords[0] + "," + coords[1] + "," + coords[2] + ") "));
                }
                valid = false;
                continue;
            }
            if (this.checkSliceInDir(world, coords[0], coords[1], coords[2], dir, radius, 0, 0, (Block)TGBlocks.oreDrill, 1)) continue;
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.oredrill.invalid3") + " (" + coords[0] + "," + coords[1] + "," + coords[2] + ") "));
            }
            valid = false;
        }
        if (!valid) return false;
        if (!world.field_72995_K) {
            OreDrillBlock.createMultiblockDrillerTileentities(world, x, y, z, dir, radius, enginelength, rodlength);
            return true;
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.oredrill.formed1") + radius + " " + TextUtil.trans("techguns.msg.oredrill.formed2") + enginelength + " " + TextUtil.trans("techguns.msg.oredrill.formed3") + rodlength));
        return true;
    }

    public static int[] getNextBlockInDir(int x, int y, int z, byte dir) {
        int[] pos = new int[]{x, y, z};
        switch (dir) {
            case 0: {
                pos[1] = pos[1] + 1;
                break;
            }
            case 1: {
                pos[1] = pos[1] - 1;
                break;
            }
            case 2: {
                pos[0] = pos[0] + 1;
                break;
            }
            case 3: {
                pos[0] = pos[0] - 1;
                break;
            }
            case 4: {
                pos[2] = pos[2] + 1;
                break;
            }
            case 5: {
                pos[2] = pos[2] - 1;
            }
        }
        return pos;
    }

    public static int[] getNextBlockInDirOffset(int x, int y, int z, byte dir, int offset) {
        int[] pos = new int[]{x, y, z};
        switch (dir) {
            case 0: {
                pos[1] = pos[1] + offset;
                break;
            }
            case 1: {
                pos[1] = pos[1] - offset;
                break;
            }
            case 2: {
                pos[0] = pos[0] + offset;
                break;
            }
            case 3: {
                pos[0] = pos[0] - offset;
                break;
            }
            case 4: {
                pos[2] = pos[2] + offset;
                break;
            }
            case 5: {
                pos[2] = pos[2] - offset;
            }
        }
        return pos;
    }

    public boolean checkSliceInDir(World w, int x, int y, int z, byte dir, int radius, int metacorner, int metaside, Block inner, int metainner) {
        int MIN = 0;
        int MAX = 2 * radius;
        int offset = radius;
        int px = x;
        int py = y;
        int pz = z;
        if (dir == 0 || dir == 1) {
            px = x - offset;
            pz = z - offset;
            for (int i = 0; i < 1 + 2 * radius; ++i) {
                for (int j = 0; j < 1 + 2 * radius; ++j) {
                    if (px + i == x && pz + j == z || !(!(i != MIN && i != MAX || j != MIN && j != MAX) ? !ItemBlockOreDrill.isBlock(w, px + i, py, pz + j, (Block)TGBlocks.oreDrill, metacorner) : (i == MIN || i == MAX || j == MIN || j == MAX ? !ItemBlockOreDrill.isBlock(w, px + i, py, pz + j, (Block)TGBlocks.oreDrill, metaside) : !ItemBlockOreDrill.isBlock(w, px + i, py, pz + j, inner, metainner)))) continue;
                    return false;
                }
            }
        } else if (dir == 2 || dir == 3) {
            pz = z - offset;
            py = y - offset;
            for (int i = 0; i < 1 + 2 * radius; ++i) {
                for (int j = 0; j < 1 + 2 * radius; ++j) {
                    if (py + i == y && pz + j == z || !(!(i != MIN && i != MAX || j != MIN && j != MAX) ? !ItemBlockOreDrill.isBlock(w, px, py + i, pz + j, (Block)TGBlocks.oreDrill, metacorner) : (i == MIN || i == MAX || j == MIN || j == MAX ? !ItemBlockOreDrill.isBlock(w, px, py + i, pz + j, (Block)TGBlocks.oreDrill, metaside) : !ItemBlockOreDrill.isBlock(w, px, py + i, pz + j, inner, metainner)))) continue;
                    return false;
                }
            }
        } else if (dir == 4 || dir == 5) {
            px = x - offset;
            py = y - offset;
            for (int i = 0; i < 1 + 2 * radius; ++i) {
                for (int j = 0; j < 1 + 2 * radius; ++j) {
                    if (px + i == x && py + j == y || !(!(i != MIN && i != MAX || j != MIN && j != MAX) ? !ItemBlockOreDrill.isBlock(w, px + i, py + j, pz, (Block)TGBlocks.oreDrill, metacorner) : (i == MIN || i == MAX || j == MIN || j == MAX ? !ItemBlockOreDrill.isBlock(w, px + i, py + j, pz, (Block)TGBlocks.oreDrill, metaside) : !ItemBlockOreDrill.isBlock(w, px + i, py + j, pz, inner, metainner)))) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected byte getDirectionForMultiblockDrill(World world, int x, int y, int z) {
        OreDrillBlock drill = TGBlocks.oreDrill;
        byte dir = -1;
        if (ItemBlockOreDrill.isBlock(world, x, y + 1, z, (Block)drill, 2) || ItemBlockOreDrill.isBlock(world, x, y + 1, z, (Block)drill, 3)) {
            dir = 0;
        }
        if (ItemBlockOreDrill.isBlock(world, x, y - 1, z, (Block)drill, 2) || ItemBlockOreDrill.isBlock(world, x, y - 1, z, (Block)drill, 3)) {
            if (dir == -1) {
                dir = 1;
            } else {
                return -1;
            }
        }
        if (ItemBlockOreDrill.isBlock(world, x + 1, y, z, (Block)drill, 2) || ItemBlockOreDrill.isBlock(world, x + 1, y, z, (Block)drill, 3)) {
            if (dir == -1) {
                dir = 2;
            } else {
                return -1;
            }
        }
        if (ItemBlockOreDrill.isBlock(world, x - 1, y, z, (Block)drill, 2) || ItemBlockOreDrill.isBlock(world, x - 1, y, z, (Block)drill, 3)) {
            if (dir == -1) {
                dir = 3;
            } else {
                return -1;
            }
        }
        if (ItemBlockOreDrill.isBlock(world, x, y, z + 1, (Block)drill, 2) || ItemBlockOreDrill.isBlock(world, x, y, z + 1, (Block)drill, 3)) {
            if (dir == -1) {
                dir = 4;
            } else {
                return -1;
            }
        }
        if (ItemBlockOreDrill.isBlock(world, x, y, z - 1, (Block)drill, 2) || ItemBlockOreDrill.isBlock(world, x, y, z - 1, (Block)drill, 3)) {
            if (dir == -1) {
                dir = 5;
            } else {
                return -1;
            }
        }
        return dir;
    }

    public static void createMultiblockDrillerTileentities(World w, int x, int y, int z, byte dir, int radius, int enginelength, int rodlength) {
        int[] coords = OreDrillBlock.getNextBlockInDir(x, y, z, dir);
        int length = enginelength + rodlength;
        for (int i = 0; i < length; ++i) {
            boolean hollow = i >= enginelength && i != length - 1;
            OreDrillBlock.updateTileEntsInSlice(w, coords[0], coords[1], coords[2], dir, radius, hollow, x, y, z, i == length - 1);
            coords = OreDrillBlock.getNextBlockInDir(coords[0], coords[1], coords[2], dir);
        }
        OreDrillTileEntMaster master = (OreDrillTileEntMaster)w.func_147438_o(x, y, z);
        master.setMultiblockFormed(dir, (byte)radius, (short)enginelength, (short)rodlength);
        master.needUpdate();
    }

    public static void updateTileEntsInSlice(World w, int x, int y, int z, byte dir, int radius, boolean hollow, int masterX, int masterY, int masterZ, boolean bottomrow) {
        block10: {
            int pz;
            int py;
            int px;
            int offset;
            int MAX;
            int MIN;
            block11: {
                block9: {
                    MIN = 0;
                    MAX = 2 * radius;
                    offset = radius;
                    px = x;
                    py = y;
                    pz = z;
                    if (dir != 0 && dir != 1) break block9;
                    px = x - offset;
                    pz = z - offset;
                    for (int i = 0; i < 1 + 2 * radius; ++i) {
                        for (int j = 0; j < 1 + 2 * radius; ++j) {
                            if ((px + i != x || pz + j != z) && hollow && i != MIN && i != MAX && j != MIN && j != MAX) continue;
                            OreDrillTileEntSlave tile = (OreDrillTileEntSlave)w.func_147438_o(px + i, py, pz + j);
                            tile.updateMaster(masterX, masterY, masterZ);
                            if (bottomrow) {
                                tile.setBottomrow(true);
                            }
                            tile.setDirection(dir);
                            tile.needUpdate();
                        }
                    }
                    break block10;
                }
                if (dir != 2 && dir != 3) break block11;
                pz = z - offset;
                py = y - offset;
                for (int i = 0; i < 1 + 2 * radius; ++i) {
                    for (int j = 0; j < 1 + 2 * radius; ++j) {
                        if ((py + i != y || pz + j != z) && hollow && i != MIN && i != MAX && j != MIN && j != MAX) continue;
                        OreDrillTileEntSlave tile = (OreDrillTileEntSlave)w.func_147438_o(px, py + i, pz + j);
                        tile.updateMaster(masterX, masterY, masterZ);
                        if (bottomrow) {
                            tile.setBottomrow(true);
                        }
                        tile.setDirection(dir);
                        tile.needUpdate();
                    }
                }
                break block10;
            }
            if (dir != 4 && dir != 5) break block10;
            px = x - offset;
            py = y - offset;
            for (int i = 0; i < 1 + 2 * radius; ++i) {
                for (int j = 0; j < 1 + 2 * radius; ++j) {
                    if ((px + i != x || py + j != y) && hollow && i != MIN && i != MAX && j != MIN && j != MAX) continue;
                    OreDrillTileEntSlave tile = (OreDrillTileEntSlave)w.func_147438_o(px + i, py + j, pz);
                    tile.updateMaster(masterX, masterY, masterZ);
                    if (bottomrow) {
                        tile.setBottomrow(true);
                    }
                    tile.setDirection(dir);
                    tile.needUpdate();
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == 4) {
            return new OreDrillTileEntMaster();
        }
        return new OreDrillTileEntSlave();
    }

    public int func_149645_b() {
        return ClientUtils.renderCTMId;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof BasicPoweredTileEnt) {
            ((BasicPoweredTileEnt)tile).onNeighborBlockChange();
        }
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public IVariationInfo getManager(IBlockAccess world, int x, int y, int z, int metadata) {
        TileEntity tile;
        int meta = metadata;
        if (metadata != 4 && ((OreDrillTileEntSlave)(tile = world.func_147438_o(x, y, z))).hasMaster()) {
            meta += 8;
        }
        return this.carverHelper.getVariation(meta);
    }

    public IVariationInfo getManager(int meta) {
        return this.carverHelper.getVariation(meta);
    }
}

