/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.collection;

import com.sk89q.worldedit.util.collection.FastListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class TupleArrayList<A, B>
extends ArrayList<Map.Entry<A, B>> {
    public void put(A a, B b) {
        this.add(new Tuple(a, b));
    }

    public Iterator<Map.Entry<A, B>> iterator(boolean reverse) {
        return reverse ? this.reverseIterator() : this.iterator();
    }

    @Override
    public Iterator<Map.Entry<A, B>> iterator() {
        return FastListIterator.forwardIterator(this);
    }

    public Iterator<Map.Entry<A, B>> reverseIterator() {
        return FastListIterator.reverseIterator(this);
    }

    private static class Tuple<A, B>
    implements Map.Entry<A, B> {
        private A key;
        private B value;

        private Tuple(A key, B value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public A getKey() {
            return this.key;
        }

        @Override
        public B getValue() {
            return this.value;
        }

        @Override
        public B setValue(B value) {
            throw new UnsupportedOperationException();
        }
    }
}

