/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.vec.Matrix4;
import cofh.repack.codechicken.lib.vec.Quat;
import cofh.repack.codechicken.lib.vec.RedundantTransformation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.VariableTransformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class Rotation
extends Transformation {
    public static Transformation[] quarterRotations = new Transformation[]{new RedundantTransformation(), new VariableTransformation(new Matrix4(0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            double d = vector3.x;
            double d2 = vector3.z;
            vector3.x = -d2;
            vector3.z = d;
        }

        @Override
        public Transformation inverse() {
            return quarterRotations[3];
        }
    }, new VariableTransformation(new Matrix4(-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            vector3.x = -vector3.x;
            vector3.z = -vector3.z;
        }

        @Override
        public Transformation inverse() {
            return this;
        }
    }, new VariableTransformation(new Matrix4(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            double d;
            double d2 = vector3.x;
            vector3.x = d = vector3.z;
            vector3.z = -d2;
        }

        @Override
        public Transformation inverse() {
            return quarterRotations[1];
        }
    }};
    public static Transformation[] sideRotations = new Transformation[]{new RedundantTransformation(), new VariableTransformation(new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            vector3.y = -vector3.y;
            vector3.z = -vector3.z;
        }

        @Override
        public Transformation inverse() {
            return this;
        }
    }, new VariableTransformation(new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            double d = vector3.y;
            double d2 = vector3.z;
            vector3.y = -d2;
            vector3.z = d;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[3];
        }
    }, new VariableTransformation(new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            double d;
            double d2 = vector3.y;
            vector3.y = d = vector3.z;
            vector3.z = -d2;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[2];
        }
    }, new VariableTransformation(new Matrix4(0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            double d;
            double d2 = vector3.x;
            vector3.x = d = vector3.y;
            vector3.y = -d2;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[5];
        }
    }, new VariableTransformation(new Matrix4(0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vector3) {
            double d = vector3.x;
            double d2 = vector3.y;
            vector3.x = -d2;
            vector3.y = d;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[4];
        }
    }};
    public static Vector3[] axes = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    public static int[] sideRotMap = new int[]{3, 4, 2, 5, 3, 5, 2, 4, 1, 5, 0, 4, 1, 4, 0, 5, 1, 2, 0, 3, 1, 3, 0, 2};
    public static int[] rotSideMap = new int[]{-1, -1, 2, 0, 1, 3, -1, -1, 2, 0, 3, 1, 2, 0, -1, -1, 3, 1, 2, 0, -1, -1, 1, 3, 2, 0, 1, 3, -1, -1, 2, 0, 3, 1, -1, -1};
    public static int[] sideRotOffsets = new int[]{0, 2, 2, 0, 1, 3};
    public double angle;
    public Vector3 axis;
    private Quat quat;

    public static int rotateSide(int n, int n2) {
        return sideRotMap[n << 2 | n2];
    }

    public static int rotationTo(int n, int n2) {
        if ((n & 6) == (n2 & 6)) {
            throw new IllegalArgumentException("Faces " + n + " and " + n2 + " are opposites");
        }
        return rotSideMap[n * 6 + n2];
    }

    public static int getSidedRotation(EntityPlayer entityPlayer, int n) {
        Vector3 vector3 = new Vector3(entityPlayer.func_70676_i(1.0f));
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            Vector3 vector32 = axes[Rotation.rotateSide(n ^ 1, i)];
            double d2 = vector3.scalarProject(vector32);
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }

    public static Transformation sideOrientation(int n, int n2) {
        return quarterRotations[(n2 + sideRotOffsets[n]) % 4].with(sideRotations[n]);
    }

    public static int getSideFromLookAngle(EntityLivingBase entityLivingBase) {
        Vector3 vector3 = new Vector3(entityLivingBase.func_70676_i(1.0f));
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            double d2 = vector3.scalarProject(axes[i]);
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public Rotation(double d, Vector3 vector3) {
        this.angle = d;
        this.axis = vector3;
    }

    public Rotation(double d, double d2, double d3, double d4) {
        this(d, new Vector3(d2, d3, d4));
    }

    public Rotation(Quat quat) {
        this.quat = quat;
        this.angle = Math.acos(quat.s) * 2.0;
        if (this.angle == 0.0) {
            this.axis = new Vector3(0.0, 1.0, 0.0);
        } else {
            double d = Math.sin(this.angle * 0.5);
            this.axis = new Vector3(quat.x / d, quat.y / d, quat.z / d);
        }
    }

    @Override
    public void apply(Vector3 vector3) {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(this.axis, this.angle);
        }
        vector3.rotate(this.quat);
    }

    @Override
    public void applyN(Vector3 vector3) {
        this.apply(vector3);
    }

    @Override
    public void apply(Matrix4 matrix4) {
        matrix4.rotate(this.angle, this.axis);
    }

    public Quat toQuat() {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(this.axis, this.angle);
        }
        return this.quat;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        GL11.glRotatef((float)((float)(this.angle * 57.29577951308232)), (float)((float)this.axis.x), (float)((float)this.axis.y), (float)((float)this.axis.z));
    }

    @Override
    public Transformation inverse() {
        return new Rotation(-this.angle, this.axis);
    }

    @Override
    public Transformation merge(Transformation transformation) {
        if (transformation instanceof Rotation) {
            Rotation rotation = (Rotation)transformation;
            if (rotation.axis.equalsT(this.axis)) {
                return new Rotation(this.angle + rotation.angle, this.axis);
            }
            return new Rotation(this.toQuat().copy().multiply(rotation.toQuat()));
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return MathHelper.between(-1.0E-5, this.angle, 1.0E-5);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Rotation(" + new BigDecimal(this.angle, mathContext) + ", " + new BigDecimal(this.axis.x, mathContext) + ", " + new BigDecimal(this.axis.y, mathContext) + ", " + new BigDecimal(this.axis.z, mathContext) + ")";
    }
}

