/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.util.vector.Matrix4f;

public class ShaderProgram {
    int programID = ARBShaderObjects.glCreateProgramObjectARB();

    public ShaderProgram() {
        if (this.programID == 0) {
            throw new RuntimeException("Unable to allocate shader program object.");
        }
    }

    public void attach(int n, String string) {
        InputStream inputStream = ShaderProgram.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new RuntimeException("Unable to locate resource: " + string);
        }
        this.attach(n, inputStream);
    }

    public void use() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
    }

    public static void restore() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public void link() {
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35714) == 0) {
            throw new RuntimeException("Error linking program: " + ShaderProgram.getInfoLog(this.programID));
        }
        ARBShaderObjects.glValidateProgramARB((int)this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35715) == 0) {
            throw new RuntimeException("Error validating program: " + ShaderProgram.getInfoLog(this.programID));
        }
        this.use();
        this.onLink();
        ShaderProgram.restore();
    }

    public void attach(int n, InputStream inputStream) {
        if (inputStream == null) {
            throw new RuntimeException("Invalid shader inputstream");
        }
        int n2 = 0;
        try {
            n2 = ARBShaderObjects.glCreateShaderObjectARB((int)n);
            if (n2 == 0) {
                throw new RuntimeException("Unable to allocate shader object.");
            }
            try {
                ARBShaderObjects.glShaderSourceARB((int)n2, (CharSequence)ShaderProgram.asString(inputStream));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error reading inputstream.", iOException);
            }
            ARBShaderObjects.glCompileShaderARB((int)n2);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)n2, (int)35713) == 0) {
                throw new RuntimeException("Error compiling shader: " + ShaderProgram.getInfoLog(n2));
            }
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)n2);
        }
        catch (RuntimeException runtimeException) {
            ARBShaderObjects.glDeleteObjectARB((int)n2);
            throw runtimeException;
        }
    }

    public static String asString(InputStream inputStream) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append('\n');
        }
        inputStream.close();
        return stringBuilder.toString();
    }

    private static String getInfoLog(int n) {
        return ARBShaderObjects.glGetInfoLogARB((int)n, (int)ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)35716));
    }

    public int getUniformLoc(String string) {
        return ARBShaderObjects.glGetUniformLocationARB((int)this.programID, (CharSequence)string);
    }

    public int getAttribLoc(String string) {
        return ARBVertexShader.glGetAttribLocationARB((int)this.programID, (CharSequence)string);
    }

    public void uniformTexture(String string, int n) {
        ARBShaderObjects.glUniform1iARB((int)this.getUniformLoc(string), (int)n);
    }

    public void onLink() {
    }

    public void glVertexAttributeMat4(int n, Matrix4f matrix4f) {
        ARBVertexShader.glVertexAttrib4fARB((int)n, (float)matrix4f.m00, (float)matrix4f.m01, (float)matrix4f.m02, (float)matrix4f.m03);
        ARBVertexShader.glVertexAttrib4fARB((int)(n + 1), (float)matrix4f.m10, (float)matrix4f.m11, (float)matrix4f.m12, (float)matrix4f.m13);
        ARBVertexShader.glVertexAttrib4fARB((int)(n + 2), (float)matrix4f.m20, (float)matrix4f.m21, (float)matrix4f.m22, (float)matrix4f.m23);
        ARBVertexShader.glVertexAttrib4fARB((int)(n + 3), (float)matrix4f.m30, (float)matrix4f.m31, (float)matrix4f.m32, (float)matrix4f.m33);
    }
}

