/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.listbox.IListBoxElement;
import cofh.lib.util.helpers.StringHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class ElementListBox
extends ElementBase {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    protected int _marginTop = 2;
    protected int _marginLeft = 2;
    protected int _marginRight = 2;
    protected int _marginBottom = 2;
    protected final List<IListBoxElement> _elements = new LinkedList<IListBoxElement>();
    protected int _firstIndexDisplayed;
    protected int _selectedIndex;
    protected int scrollHoriz;

    public ElementListBox(GuiBase guiBase, int n, int n2, int n3, int n4) {
        super(guiBase, n, n2, n3, n4);
    }

    public void add(IListBoxElement iListBoxElement) {
        this._elements.add(iListBoxElement);
    }

    public void add(Collection<? extends IListBoxElement> collection) {
        this._elements.addAll(collection);
    }

    public void remove(IListBoxElement iListBoxElement) {
        int n = this._elements.indexOf(iListBoxElement);
        if (this._elements.remove(iListBoxElement)) {
            if (n < this._firstIndexDisplayed) {
                --this._firstIndexDisplayed;
            }
            if (n < this._selectedIndex) {
                --this._selectedIndex;
            }
        }
    }

    public void removeAt(int n) {
        this.scrollHoriz = 0;
        this._firstIndexDisplayed = 0;
        this._selectedIndex = -1;
        this._elements.remove(n);
    }

    public void removeAll() {
        this._elements.clear();
    }

    public int getInternalWidth() {
        int n = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            n = Math.max(this._elements.get(i).getWidth(), n);
        }
        return n;
    }

    public int getInternalHeight() {
        int n = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            n += this._elements.get(i).getHeight();
        }
        return n;
    }

    public int getContentWidth() {
        return this.sizeX - this._marginLeft - this._marginRight;
    }

    public int getContentHeight() {
        return this.sizeY - this._marginTop - this._marginBottom;
    }

    public int getContentTop() {
        return this.posY + this._marginTop;
    }

    public int getContentLeft() {
        return this.posX + this._marginLeft;
    }

    public final int getContentBottom() {
        return this.getContentTop() + this.getContentHeight();
    }

    public final int getContentRight() {
        return this.getContentLeft() + this.getContentWidth();
    }

    public ElementListBox setTextColor(Number number, Number number2) {
        if (number != null) {
            this.textColor = number.intValue();
        }
        if (number2 != null) {
            this.selectedTextColor = number2.intValue();
        }
        return this;
    }

    public ElementListBox setSelectionColor(Number number) {
        if (number != null) {
            this.selectedLineColor = number.intValue();
        }
        return this;
    }

    public ElementListBox setBackgroundColor(Number number, Number number2) {
        if (number != null) {
            this.backgroundColor = number.intValue();
        }
        if (number2 != null) {
            this.borderColor = number2.intValue();
        }
        return this;
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.backgroundColor);
    }

    @Override
    public void drawForeground(int n, int n2) {
        int n3 = 0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2960);
        this.drawStencil(this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.scrollHoriz), (double)0.0, (double)0.0);
        int n4 = this._elements.size();
        for (int i = this._firstIndexDisplayed; i < n4 && n3 <= this.getContentHeight(); n3 += this.drawElement(i, this.getContentLeft(), this.getContentTop() + n3), ++i) {
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2960);
        GL11.glPopMatrix();
    }

    protected int drawElement(int n, int n2, int n3) {
        IListBoxElement iListBoxElement = this._elements.get(n);
        if (n == this._selectedIndex) {
            iListBoxElement.draw(this, n2, n3, this.selectedLineColor, this.selectedTextColor);
        } else {
            iListBoxElement.draw(this, n2, n3, this.backgroundColor, this.textColor);
        }
        return iListBoxElement.getHeight();
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n5 <= this.getContentHeight(); n5 += n4, ++i) {
            n4 = this._elements.get(i).getHeight();
            if (this.getContentTop() + n5 > n2 || this.getContentTop() + n5 + n4 < n2) continue;
            this.setSelectedIndex(i);
            this.onElementClicked(this._elements.get(i));
            break;
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int n, int n2, int n3) {
        if (StringHelper.isControlKeyDown()) {
            if (n3 > 0) {
                this.scrollLeft();
            } else if (n3 < 0) {
                this.scrollRight();
            }
        } else if (n3 > 0) {
            this.scrollUp();
        } else if (n3 < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int n = 0;
        int n2 = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n + this._elements.get(i).getHeight() <= this.sizeY; ++i) {
            n += this._elements.get(i).getHeight();
            ++n2;
        }
        if (this._firstIndexDisplayed + n2 < this._elements.size()) {
            ++this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollLeft() {
        this.scrollHoriz = Math.max(this.scrollHoriz - 15, 0);
        this.onScrollH(this.scrollHoriz);
    }

    public void scrollRight() {
        this.scrollHoriz = Math.min(this.scrollHoriz + 15, this.getLastScrollPositionH());
        this.onScrollH(this.scrollHoriz);
    }

    public int getLastScrollPosition() {
        int n;
        int n2 = this._elements.size() - 1;
        if (n2 < 0) {
            return 0;
        }
        for (n = 0; n2 >= 0 && n < this.sizeY; n += this._elements.get(n2--).getHeight()) {
        }
        if (n > this.sizeY) {
            ++n2;
        }
        return n2 + 1;
    }

    public int getLastScrollPositionH() {
        return Math.max(this.getInternalWidth() - this.getContentWidth(), 0);
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getIndexOf(Object object) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!this._elements.get(i).getValue().equals(object)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        if (this._selectedIndex == -1 || this._selectedIndex >= this._elements.size()) {
            return null;
        }
        return this._elements.get(this._selectedIndex);
    }

    public void setSelectedIndex(int n) {
        if (n >= -1 && n != this._selectedIndex && n < this._elements.size()) {
            this._selectedIndex = n;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int n) {
        return this._elements.get(n);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    public void scrollToV(int n) {
        if (n >= 0 && n < this._elements.size()) {
            this._firstIndexDisplayed = n;
        }
    }

    public void scrollToH(int n) {
        if (n >= 0 && n <= this.getLastScrollPositionH()) {
            this.scrollHoriz = n;
        }
    }

    protected void onElementClicked(IListBoxElement iListBoxElement) {
    }

    protected void onScrollV(int n) {
    }

    protected void onScrollH(int n) {
    }

    protected void onSelectionChanged(int n, IListBoxElement iListBoxElement) {
    }
}

