/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import team.chisel.init.ChiselBlocks;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class HouseMedium
extends Structure {
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public HouseMedium(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1);
        BlockUtils.placeFoundation(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 4);
    }

    static {
        Block roofStairsBlock = Blocks.field_150387_bl;
        Block interiorStairs = Blocks.field_150476_ad;
        Block darkStairs = Blocks.field_150401_cl;
        blockList.add(new MBlock(TGBlocks.airMarker, 0));
        blockList.add(new MBlock(TGBlocks.lamp01, 7, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(roofStairsBlock, 0, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock((Block)ChiselBlocks.cobblestone, 1));
        blockList.add(new MBlock((Block)ChiselBlocks.cobblestone, 10));
        blockList.add(new MBlock(Blocks.field_150466_ao, 4, true, BlockUtils.BlockType.DOOR).setPass(0));
        blockList.add(new MBlock(Blocks.field_150466_ao, 8, true, BlockUtils.BlockType.DOOR).setPass(1));
        blockList.add(new MBlock(Blocks.field_150410_aZ, 0));
        blockList.add(new MBlock((Block)ChiselBlocks.cobblestone, 13));
        blockList.add(new MBlock(roofStairsBlock, 5, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock((Block)ChiselBlocks.cobblestone, 4));
        blockList.add(new MBlock((Block)ChiselBlocks.carpet, 8));
        blockList.add(new MBlock(Blocks.field_150444_as, 2, true, BlockUtils.BlockType.LADDER).setPass(1));
        blockList.add(new MBlock(interiorStairs, 1, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(Blocks.field_150342_X, 0));
        blockList.add(new MBlock(darkStairs, 4, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(roofStairsBlock, 2, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(Blocks.field_150385_bj, 0));
        blockList.add(new MBlock(darkStairs, 3, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(darkStairs, 1, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(Blocks.field_150324_C, 9, true, BlockUtils.BlockType.BED));
        blockList.add(new MBlock((Block)ChiselBlocks.carpet, 4));
        blockList.add(new MBlock((Block)Blocks.field_150486_ae, 2));
        blockList.add(new MBlock(Blocks.field_150422_aJ, 0));
        blockList.add(new MBlock(Blocks.field_150443_bT, 0).setPass(1));
        blockList.add(new MBlock(Blocks.field_150324_C, 1, true, BlockUtils.BlockType.BED));
        blockList.add(new MBlock(Blocks.field_150344_f, 5));
        blockList.add(new MBlock(TGBlocks.lamp01, 1, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(TGBlocks.lamp01, 5, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(new MBlock((Block)ChiselBlocks.leadblock, 1));
        blockList.add(new MBlock(TGBlocks.lamp01, 6, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock((Block)ChiselBlocks.copperblock, 1));
        blockList.add(new MBlock(Blocks.field_150466_ao, 6, true, BlockUtils.BlockType.DOOR));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_block, 3));
        blockList.add(new MBlock((Block)ChiselBlocks.tinblock, 1));
        blockList.add(new MBlock((Block)ChiselBlocks.carpet, 10));
        blockList.add(new MBlock((Block)Blocks.field_150486_ae, 4, true, BlockUtils.BlockType.LADDER));
        blockList.add(new MBlock(roofStairsBlock, 3, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_block, 7));
        blockList.add(new MBlock((Block)ChiselBlocks.gold_block, 5));
        blockList.add(new MBlock(roofStairsBlock, 4, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(roofStairsBlock, 1, true, BlockUtils.BlockType.STAIRS));
        blockList.add(new MBlock(Blocks.field_150466_ao, 3, true, BlockUtils.BlockType.DOOR).setPass(1));
        blockList.add(new MBlock(TGBlocks.lamp01, 3, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_bars, 5));
        blockList.add(new MBlock(TGBlocks.ladder01, 1, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(Blocks.field_150466_ao, 5, true, BlockUtils.BlockType.DOOR).setPass(0));
        blockList.add(new MBlock(TGBlocks.lamp01, 4, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock((Block)Blocks.field_150486_ae, 3, true, BlockUtils.BlockType.LADDER));
        blockList.add(new MBlock(Blocks.field_150466_ao, 1, true, BlockUtils.BlockType.DOOR).setPass(1));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_block, 1));
        blockList.add(new MBlock(Blocks.field_150324_C, 3, true, BlockUtils.BlockType.BED));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_block, 10));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_block, 9));
        blockList.add(new MBlock(Blocks.field_150324_C, 11, true, BlockUtils.BlockType.BED));
        blocks = BlockUtils.loadStructureFromFile("houseMedium");
    }
}

