/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import techguns.TGBlocks;
import techguns.Techguns;

public class OreGenerator
implements IWorldGenerator {
    private boolean doLead;
    private boolean doCopperTin;
    private boolean doTitanium;
    private boolean doUranium;

    public OreGenerator(boolean doLead, boolean doCopperTin, boolean doTitanium, boolean doUranium) {
        this.doLead = doLead;
        this.doCopperTin = doCopperTin;
        this.doTitanium = doTitanium;
        this.doUranium = doUranium;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            if (this.doCopperTin) {
                this.addOreSpawn(Techguns.oreCopper, 0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 16, 16, 5 + random.nextInt(3), 12, 5, 80);
                this.addOreSpawn(Techguns.oreTin, 0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 16, 16, 4 + random.nextInt(3), 10, 5, 60);
            }
            if (this.doLead) {
                this.addOreSpawn(Techguns.oreLead, 0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 16, 16, 4 + random.nextInt(2), 8, 5, 50);
            }
            if (this.doTitanium) {
                this.addOreSpawn(TGBlocks.oreTitanIron, 0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 16, 16, 4 + random.nextInt(2), 4, 4, 24);
            }
            if (this.doUranium) {
                this.addOreSpawn(TGBlocks.oreTitanIron, 1, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 16, 16, 4 + random.nextInt(4), 5, 4, 32);
            }
        }
    }

    public void addOreSpawn(Block block, int meta, Block SpawnBlock, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, meta, maxVeinSize, SpawnBlock).func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

