/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.blocks.TGChiselBlocks;
import techguns.util.BlockUtils;
import techguns.worldgen.GenericCitySegment;
import techguns.worldgen.structures.CityBuilding;
import techguns.worldgen.structures.CityBuildingType;
import techguns.worldgen.structures.CityRoad;
import techguns.worldgen.structures.EmptyPlane;
import techguns.worldgen.structures.IRoad;
import techguns.worldgen.structures.Structure;

public class GenericCity {
    public static final int SET_AIR_HEIGHT = 3;
    public static GenericCity testCity = new GenericCity(20, 80, 12, 30, -1, new int[]{6, 4, 4, 2, 1}, new CityRoad(TGChiselBlocks.concrete_dark, TGChiselBlocks.concrete), 0.5f);
    int sizeMin;
    int sizeMax;
    int minSubSegmentSize = 10;
    int maxSubSegmentSize = 25;
    int maxHeightDiff = 3;
    float fuzzyBorder = 0.0f;
    ArrayList<Structure> structures;
    int[] roadWidth;
    public IRoad roadType;

    public GenericCity(int sizeMin, int sizeMax, int minSubSegmentSize, int maxSubSegmentSize, int maxHeightDiff, int[] roadWidth, IRoad roadType, float fuzzyBorder) {
        this.sizeMin = sizeMin;
        this.sizeMax = sizeMax;
        this.minSubSegmentSize = minSubSegmentSize;
        this.maxSubSegmentSize = maxSubSegmentSize;
        this.maxHeightDiff = maxHeightDiff;
        this.roadWidth = roadWidth;
        this.roadType = roadType;
        this.structures = new ArrayList();
        this.fuzzyBorder = fuzzyBorder;
    }

    public void createCity(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, BlockUtils.BiomeColorType colorType) {
        this.minSubSegmentSize = Math.min(sizeX, sizeZ) < 10 ? 5 : 7;
        this.maxSubSegmentSize = Math.min(sizeX, sizeZ) <= 45 ? 15 : Math.min(sizeX, sizeZ) / 3;
        if (colorType == null) {
            colorType = BlockUtils.getBiomeType(world, posX + sizeX / 2, posZ + sizeZ / 2);
        }
        GenericCitySegment rootSegment = new GenericCitySegment(this, posX, posY, posZ, sizeX, sizeZ, this.roadWidth[0], 0, colorType, world.field_73012_v, null);
        rootSegment.isCenter = true;
        rootSegment.splitStep = 0;
        System.out.println("Generate Subsegments...");
        boolean b = rootSegment.generateSubSegments();
        if (b) {
            System.out.println("Generate Subsegments... DONE!");
            this.setBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, colorType, rootSegment);
        } else {
            System.out.println("Generate Subsegments... ERROR!");
        }
    }

    private void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, BlockUtils.BiomeColorType colorType, GenericCitySegment rootSegment) {
        BlockUtils.removeJunkInArea(world, posX - 1, posZ - 1, sizeX + 2, sizeZ + 2);
        BlockUtils.apply2DHeightmapFilter(world, posX - 1, posZ - 1, sizeX + 2, sizeZ + 2, BlockUtils.FILTER_GAUSSIAN_5x5);
        if (this.maxHeightDiff != -1) {
            BlockUtils.flattenArea(world, posX, posZ, sizeX, sizeZ, this.maxHeightDiff);
        }
        System.out.println("Set Blocks...");
        rootSegment.setBlocks(world);
        System.out.println("Set Blocks...DONE!");
    }

    public void placeStructure(World world, GenericCitySegment segment) {
        if (segment.isBorderSegment() && segment.splitStep > 2 && segment.rand.nextFloat() < this.fuzzyBorder) {
            return;
        }
        BlockUtils.fillBlocksAir(world, segment.x, segment.y + 1, segment.z, segment.sizeX, 3, segment.sizeZ);
        Structure structure = this.getMatchingStructure(segment.sizeX, -1, segment.sizeZ, segment.rand);
        int height = structure.maxY == -1 || structure.maxY < structure.minY ? structure.minY : structure.minY + segment.rand.nextInt(structure.maxY + 1 - structure.minY);
        BlockUtils.flattenArea(world, segment.x, segment.z, segment.sizeX, segment.sizeZ, 0);
        int y = BlockUtils.getGroundY(world, segment.x + segment.sizeX / 2, segment.z + segment.sizeZ / 2);
        structure.setBlocks(world, segment.x, segment.y, segment.z, segment.sizeX, height, segment.sizeZ, segment.direction, segment.colorType);
    }

    protected Structure getMatchingStructure(int sizeX, int sizeY, int sizeZ, Random rand) {
        ArrayList<Structure> matchingStructures = new ArrayList<Structure>();
        for (Structure str : this.structures) {
            if (str.canSwapXZ) {
                if ((sizeX < str.minX || sizeZ < str.minZ) && (sizeZ < str.minX || sizeX < str.minZ) || (str.maxX != -1 && sizeX > str.maxX || str.maxZ != -1 && sizeZ > str.maxZ) && (str.maxX != -1 && sizeZ > str.maxX || str.maxZ != -1 && sizeX > str.maxZ)) continue;
                matchingStructures.add(str);
                continue;
            }
            if (sizeX < str.minX || sizeZ < str.minZ || str.maxX != -1 && sizeX > str.maxX || str.maxZ != -1 && sizeZ > str.maxZ) continue;
            matchingStructures.add(str);
        }
        if (!matchingStructures.isEmpty()) {
            return (Structure)matchingStructures.get(rand.nextInt(matchingStructures.size()));
        }
        return new EmptyPlane(Blocks.field_150347_e);
    }

    static {
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building1, 3, 5, 5, -1, 16, -1).setSwapXZ(true));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building2, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building3, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building4, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building5, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building6, 4, 5, 4, -1, 16, -1));
    }
}

