/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.BlockBugSlime;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MathUtil;
import techguns.util.MultiMBlock;

public class AlienBugNest {
    static int MAX_RADIUS = 10;
    static int MIN_RADIUS = 3;
    static int MAX_SEGMENTS;
    static MBlock wallBlock;
    static MBlock wallBlock2;
    static MBlock innerBlock;
    static MBlock slimeLadder;
    static MBlock slimyBlock;
    static MBlock spawner;
    static MBlock eggsBlock;
    public BugNestSegment mainSegment;

    public AlienBugNest(int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, Random rand) {
        int segments = 5;
        boolean largeNest = true;
        int startRadius = Math.min(MAX_RADIUS, MIN_RADIUS + segments / 2);
        int x = posX + sizeX / 2;
        int y = posY + sizeY / 2;
        int z = posZ + sizeZ / 2;
        BugNestSegment entrance = new BugNestSegment(x, y, z, 2, 2);
        int mainY = y - (startRadius + 5 + rand.nextInt(7));
        this.mainSegment = new BugNestSegment(x + rand.nextInt(3), mainY, z + rand.nextInt(3), startRadius, 0);
        this.mainSegment.neighbors.add(entrance);
        float angle = (float)(Math.PI * 2 / (double)segments);
        BugNestSegment prev = this.mainSegment;
        for (int i = 0; i < segments; ++i) {
            int radius = Math.max(MIN_RADIUS, startRadius - rand.nextInt(i + 1));
            double dist = (double)(startRadius + radius) + 5.0 + rand.nextDouble() * 8.0;
            MathUtil.Vec2 xz = MathUtil.polarOffsetXZ(x, z, dist, angle * (float)i);
            int segY = mainY + rand.nextInt(startRadius * 3) - startRadius * 2;
            BugNestSegment seg = new BugNestSegment((int)xz.x, segY, (int)xz.y, radius, 1);
            if (prev == this.mainSegment) {
                this.mainSegment.neighbors.add(seg);
            } else if (rand.nextBoolean()) {
                prev.neighbors.add(seg);
                if (rand.nextBoolean()) {
                    this.mainSegment.neighbors.add(seg);
                }
            } else {
                this.mainSegment.neighbors.add(seg);
            }
            if (largeNest && rand.nextBoolean()) {
                radius = Math.max(MIN_RADIUS, startRadius - rand.nextInt(i + 1));
                dist = (double)(startRadius + radius) + 5.0 + rand.nextDouble() * 8.0;
                xz = MathUtil.polarOffsetXZ(xz.x, xz.y, dist, (double)(angle * (float)i) + 1.5707963267948966 * (rand.nextDouble() - 0.5));
                segY = mainY + rand.nextInt(startRadius * 3) - startRadius * 2;
                BugNestSegment seg2 = new BugNestSegment((int)xz.x, segY, (int)xz.y, radius, 1);
                seg.neighbors.add(seg2);
            }
            prev = seg;
        }
    }

    public void setBlocks(World world) {
        this.placeSegment(world, this.mainSegment);
        this.placeConnections(world, this.mainSegment);
        this.placeInterior(world, this.mainSegment);
    }

    private void placeSegment(World world, BugNestSegment segment) {
        if (segment.status >= 1) {
            return;
        }
        if (segment.type != 2) {
            BlockUtils.fillSphere2(world, segment.posX, segment.posY, segment.posZ, segment.radius, 1.0f, new MBlock(Blocks.field_150350_a, 0), wallBlock);
            segment.status = 1;
            for (BugNestSegment seg : segment.neighbors) {
                this.placeSegment(world, seg);
            }
        }
    }

    private void placeConnections(World world, BugNestSegment segment) {
        if (segment.status >= 2) {
            return;
        }
        segment.status = 2;
        for (BugNestSegment seg : segment.neighbors) {
            Vec3 pos1 = Vec3.func_72443_a((double)segment.posX, (double)segment.posY, (double)segment.posZ);
            Vec3 pos2 = Vec3.func_72443_a((double)seg.posX, (double)seg.posY, (double)seg.posZ);
            Vec3 v2v1 = pos1.func_72444_a(pos2);
            double distance = v2v1.func_72433_c();
            Vec3 dir = v2v1.func_72432_b();
            double d2 = distance - (double)seg.radius;
            if (seg.type == 2) {
                d2 += 5.0;
            }
            int x1 = (int)((double)segment.posX + dir.field_72450_a * (double)segment.radius);
            int y1 = (int)((double)segment.posY + dir.field_72448_b * (double)segment.radius);
            int z1 = (int)((double)segment.posZ + dir.field_72449_c * (double)segment.radius);
            int x2 = (int)((double)segment.posX + dir.field_72450_a * d2);
            int y2 = (int)((double)segment.posY + dir.field_72448_b * d2);
            int z2 = (int)((double)segment.posZ + dir.field_72449_c * d2);
            int r = Math.min(segment.radius, Math.min(2 + world.field_73012_v.nextInt(2), seg.radius));
            BlockUtils.fillCylinder(world, x1, y1, z1, x2, y2, z2, r, new MBlock(Blocks.field_150350_a, 0), wallBlock2);
            if (seg.type == 2) {
                AlienBugNest.createSlimeLadder(world, x1, y1, z1, x2, y2, z2, r - 1);
            }
            this.placeConnections(world, seg);
        }
    }

    private void placeInterior(World world, BugNestSegment segment) {
        if (segment.status >= 3) {
            return;
        }
        if (segment.type != 2) {
            BlockUtils.fillSphere(world, segment.posX, segment.posY, segment.posZ, segment.radius - 1, new MBlock(Blocks.field_150350_a, 0));
            segment.status = 3;
            if (segment.type == 1) {
                this.placeEggs(world, segment);
            }
            for (BugNestSegment seg : segment.neighbors) {
                if (segment.type == 0 && seg.type == 2) {
                    int k = 1;
                    double angle = world.field_73012_v.nextDouble() * 2.0 * Math.PI;
                    for (int i = 0; i < k; ++i) {
                        MathUtil.Vec2 xz = MathUtil.polarOffsetXZ(0.0, 0.0, 1.0 + world.field_73012_v.nextDouble() * 0.66, angle + Math.PI * 2 / (double)k * (double)i);
                        int xo = (int)xz.x;
                        int zo = (int)xz.y;
                        Vec3 pos1 = Vec3.func_72443_a((double)segment.posX, (double)segment.posY, (double)segment.posZ);
                        Vec3 pos2 = Vec3.func_72443_a((double)seg.posX, (double)seg.posY, (double)seg.posZ);
                        Vec3 v2v1 = pos1.func_72444_a(pos2);
                        double distance = v2v1.func_72433_c();
                        Vec3 dir = v2v1.func_72432_b();
                        double d2 = (segment.radius - 1) * 2;
                        int x1 = (int)((double)(segment.posX + xo) + dir.field_72450_a * (double)(-(segment.radius + 1)));
                        int y1 = (int)((double)segment.posY + dir.field_72448_b * (double)(-(segment.radius + 1)));
                        int z1 = (int)((double)(segment.posZ + zo) + dir.field_72449_c * (double)(-(segment.radius + 1)));
                        int x2 = (int)((double)(segment.posX + xo) + dir.field_72450_a * d2);
                        int y2 = (int)((double)segment.posY + dir.field_72448_b * d2);
                        int z2 = (int)((double)(segment.posZ + zo) + dir.field_72449_c * d2);
                        BlockUtils.drawLine(world, x1, y1, z1, x2, y2, z2, slimyBlock);
                    }
                }
                this.placeInterior(world, seg);
            }
        }
    }

    public void placeEggs(World world, BugNestSegment segment) {
        int r;
        int ri = r = segment.radius - 2;
        if (r > 1) {
            --ri;
        }
        int spawnerX = world.field_73012_v.nextInt(2 * ri) - ri;
        int spawnerZ = world.field_73012_v.nextInt(2 * ri) - ri;
        for (int i = -r; i < r; ++i) {
            block1: for (int j = -r; j < r; ++j) {
                if (i == spawnerX && j == spawnerZ) {
                    int x = segment.posX + i;
                    int z = segment.posZ + j;
                    int y = segment.posY - (segment.radius - 2);
                    spawner.setBlock(world, x, y, z, 0);
                    continue;
                }
                float f1 = (float)(r - Math.abs(i)) / (float)r;
                float f2 = (float)(r - Math.abs(j)) / (float)r;
                if (!(world.field_73012_v.nextDouble() < (double)((f1 + f2) / 2.0f))) continue;
                int x = segment.posX + i;
                int z = segment.posZ + j;
                for (int k = 0; k < segment.radius; ++k) {
                    int y = segment.posY - (segment.radius - 1) + k;
                    if (world.func_147437_c(x, y, z)) {
                        eggsBlock.setBlock(world, x, y, z, 0);
                    }
                    if (world.field_73012_v.nextDouble() > (double)((f1 + f2) / 3.0f)) continue block1;
                }
            }
        }
    }

    public static void createSlimeLadder(World world, int x1, int y1, int z1, int x2, int y2, int z2, float radius) {
        Vec3 v1 = Vec3.func_72443_a((double)x1, (double)y1, (double)z1);
        Vec3 v2 = Vec3.func_72443_a((double)x2, (double)y2, (double)z2);
        Vec3 v2v1 = v2.func_72444_a(v1);
        double l = v2v1.func_72433_c();
        int tmp = 0;
        if (x1 > x2) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y1 > y2) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        if (z1 > z2) {
            tmp = z2;
            z2 = z1;
            z1 = tmp;
        }
        int r = (int)radius;
        for (int x = x1 - r; x < x2 + r; ++x) {
            for (int y = y1 - r; y < y2 + r; ++y) {
                for (int z = z1 - r; z < z2 + r; ++z) {
                    Vec3 v0 = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    Vec3 v1v0 = v0.func_72444_a(v1);
                    Vec3 v_ = v2v1.func_72431_c(v1v0);
                    double distance = v_.func_72433_c() / l;
                    if (!(distance < (double)radius) || !TGBlocks.bugnestslimy.func_149742_c(world, x, y, z)) continue;
                    slimeLadder.setBlock(world, x, y, z, 0);
                    world.func_72921_c(x, y, z, ((BlockBugSlime)TGBlocks.bugnestslimy).getDirectionMeta(world, x, y, z), 2);
                }
            }
        }
    }

    static {
        wallBlock = new MultiMBlock(new Block[]{TGBlocks.bugnest, TGBlocks.bugnesteggs, Blocks.field_150322_A}, new int[]{0, 0, 0}, new int[]{16, 1, 2});
        wallBlock2 = new MultiMBlock(new Block[]{TGBlocks.bugnest, Blocks.field_150322_A}, new int[]{0, 0}, new int[]{12, 1});
        innerBlock = new MBlock(Blocks.field_150350_a, 0);
        slimeLadder = new MBlock(TGBlocks.bugnestslimy, 0);
        slimyBlock = new MBlockSlime(TGBlocks.bugnest, 0);
        spawner = new MBlock(TGBlocks.monsterspawner, 0);
        eggsBlock = new MBlock(TGBlocks.bugnesteggs, 0);
    }

    static class MBlockSlime
    extends MBlock {
        public MBlockSlime(Block block, int meta) {
            super(block, meta);
        }

        @Override
        public void setBlock(World world, int posX, int posY, int posZ, int rotation) {
            super.setBlock(world, posX, posY, posZ, rotation);
            this.placeSlimeAt(world, posX - 1, posY, posZ);
            this.placeSlimeAt(world, posX + 1, posY, posZ);
            this.placeSlimeAt(world, posX, posY, posZ - 1);
            this.placeSlimeAt(world, posX, posY, posZ + 1);
        }

        private void placeSlimeAt(World world, int x, int y, int z) {
            if (world.func_147437_c(x, y, z) && TGBlocks.bugnestslimy.func_149742_c(world, x, y, z)) {
                slimeLadder.setBlock(world, x, y, z, 0);
                world.func_72921_c(x, y, z, ((BlockBugSlime)TGBlocks.bugnestslimy).getDirectionMeta(world, x, y, z), 2);
            }
        }
    }

    class BugNestSegment {
        int posX;
        int posY;
        int posZ;
        int radius;
        byte type;
        int status = 0;
        ArrayList<BugNestSegment> neighbors = new ArrayList();

        public BugNestSegment(int posX, int posY, int posZ, int radius, int type) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.radius = radius;
            this.type = (byte)type;
        }
    }
}

