/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import techguns.TGItems;
import techguns.Techguns;
import techguns.inventory.ReactionBeamFocus;
import techguns.inventory.ReactionChamberRecipe;
import techguns.items.TGSlotType;
import techguns.tileentities.MultiBlockMasterTileEntBase;
import techguns.tileentities.ReactionChamberOperation;
import techguns.tileentities.ReactionChamberTileEntSlave;
import techguns.util.BlockCoords;

public class ReactionChamberTileEntMaster
extends MultiBlockMasterTileEntBase
implements IFluidHandler {
    public boolean haspower = false;
    public FluidTank inputTank = new FluidTank(10000);
    public ItemStack lastStack = null;
    public ReactionChamberOperation currentReaction = null;
    public byte intensity = 0;
    public byte liquidLevel = 0;
    public byte dir;

    public ReactionChamberTileEntMaster() {
        super(6, 1000000);
        this.complete = false;
        this.dir = 0;
        this.useRangeSquared = 144.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.complete) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
        }
        return super.getRenderBoundingBox();
    }

    public BlockCoords getCenterPos() {
        BlockCoords pos = new BlockCoords(this);
        switch (this.dir) {
            case 2: {
                pos.shift(ForgeDirection.SOUTH, 1);
                break;
            }
            case 3: {
                pos.shift(ForgeDirection.NORTH, 1);
                break;
            }
            case 4: {
                pos.shift(ForgeDirection.EAST, 1);
                break;
            }
            case 5: {
                pos.shift(ForgeDirection.WEST, 1);
            }
        }
        pos.shift(ForgeDirection.UP, 1);
        return pos;
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    public String func_145825_b() {
        return "techguns.container.reactionChamber";
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot == 0;
    }

    public void setComplete(boolean complete, byte dir) {
        super.setComplete(complete);
        this.dir = dir;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return false;
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        NBTTagCompound tankIn;
        super.readEntityDataFromNBT(tags);
        if (this.complete) {
            this.haspower = tags.func_74767_n("hasPower");
            this.dir = tags.func_74771_c("dir");
        }
        if ((tankIn = tags.func_74775_l("inputTank")) != null) {
            this.inputTank.readFromNBT(tankIn);
        }
        this.intensity = tags.func_74771_c("intensity");
        this.liquidLevel = tags.func_74771_c("liquidLevel");
        NBTTagCompound opdata = tags.func_74775_l("operationData");
        if (!opdata.func_82582_d()) {
            if (this.currentReaction == null) {
                this.currentReaction = new ReactionChamberOperation(null);
            }
            this.currentReaction.readDataFromNBT(opdata);
            short recID = opdata.func_74765_d("ID");
            this.currentReaction.recipe = ReactionChamberRecipe.getById(recID);
        } else {
            this.currentReaction = null;
        }
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        if (this.complete) {
            tags.func_74757_a("hasPower", this.haspower);
            tags.func_74774_a("dir", this.dir);
        }
        NBTTagCompound tagInputTank = new NBTTagCompound();
        this.inputTank.writeToNBT(tagInputTank);
        tags.func_74782_a("inputTank", (NBTBase)tagInputTank);
        tags.func_74774_a("intensity", this.intensity);
        tags.func_74774_a("liquidLevel", this.liquidLevel);
        if (this.currentReaction != null) {
            this.currentReaction.writeDataToNBT(tags);
        }
    }

    private void mergeOutput() {
        ArrayList<ItemStack> outputs = this.currentReaction.recipe.outputs;
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = outputs.get(i).func_77946_l();
            int leftover = Techguns.addItemToInventory(this.content, output, 2, 6);
            if (leftover <= 0 || this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, TGItems.newStack(output, leftover)));
        }
        if (this.currentReaction.recipe.liquidConsumtion > 0) {
            this.inputTank.drain(this.currentReaction.recipe.liquidConsumtion, true);
        }
    }

    @Override
    public void notifiyMultiblockBreak() {
        this.unform();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isComplete() && this.isRedstoneEnabled()) {
            if (this.currentReaction == null) {
                if (!this.field_145850_b.field_72995_K) {
                    ReactionChamberRecipe rec = ReactionChamberRecipe.getMatchingRecipe(this.content[0], this.content[1], this.inputTank.getFluid(), this.liquidLevel, this.intensity);
                    if (rec != null) {
                        this.startOperation(rec);
                        this.needUpdate();
                    }
                    if (this.lastStack != this.content[0]) {
                        this.needUpdate();
                        this.lastStack = this.content[0];
                    }
                    if (this.inputTank.getFluid() != null && this.inputTank.getFluidAmount() <= 0) {
                        this.inputTank.setFluid(null);
                        this.needUpdate();
                    }
                }
            } else {
                boolean state = this.currentReaction.tick(this.intensity, this.liquidLevel, this.field_145850_b.field_72995_K, this, this.currentReaction.powerPerRecipeTick);
                if (!this.field_145850_b.field_72995_K && state) {
                    if (this.currentReaction.isSuccess()) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.mergeOutput();
                        }
                        this.setFinished();
                    } else if (this.currentReaction.isFailure()) {
                        this.setFinished();
                    }
                    this.needUpdate();
                }
                if (this.field_145850_b.field_72995_K && this.currentReaction.nextTick == ReactionChamberOperation.RECIPE_TICKRATE - 1) {
                    this.playAmbientSound(this.currentReaction.preferedIntensity == this.intensity);
                }
            }
        }
    }

    private void startOperation(ReactionChamberRecipe rec) {
        this.currentReaction = new ReactionChamberOperation(rec);
        this.currentOperation = this.content[0].func_77946_l();
        this.currentOperation.field_77994_a = 1;
        --this.content[0].field_77994_a;
        if (this.content[0].field_77994_a <= 0) {
            this.content[0] = null;
        }
    }

    private void setFinished() {
        this.currentReaction = null;
        this.currentOperation = null;
    }

    public void unform() {
        if (this.isComplete()) {
            BlockCoords masterPos = new BlockCoords(this);
            ArrayList<BlockCoords> positions = null;
            if (this.dir == 2) {
                positions = masterPos.getBoxWithOffsets(-1, 1, 0, 3, 0, 2, false);
            } else if (this.dir == 3) {
                positions = masterPos.getBoxWithOffsets(-1, 1, 0, 3, -2, 0, false);
            } else if (this.dir == 4) {
                positions = masterPos.getBoxWithOffsets(0, 2, 0, 3, -1, 1, false);
            } else if (this.dir == 5) {
                positions = masterPos.getBoxWithOffsets(-2, 0, 0, 3, -1, 1, false);
            }
            if (positions != null) {
                for (int i = 0; i < positions.size(); ++i) {
                    BlockCoords pos = positions.get(i);
                    TileEntity tile = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
                    if (tile == null || !(tile instanceof ReactionChamberTileEntSlave)) continue;
                    ReactionChamberTileEntSlave slave = (ReactionChamberTileEntSlave)tile;
                    slave.unlink();
                    slave.needBlockUpdate();
                    slave.needUpdate();
                }
            }
            this.setComplete(false, (byte)0);
            this.needBlockUpdate();
            this.needUpdate();
        }
    }

    public int fillFromSlave(ForgeDirection from, FluidStack resource, boolean doFill) {
        int max = this.getCurrentMaxFluidValue() - this.inputTank.getFluidAmount();
        if (max < 0) {
            max = 0;
        }
        FluidStack f2 = resource.copy();
        if (f2.amount > max) {
            f2.amount = max;
        }
        return this.inputTank.fill(f2, doFill);
    }

    public FluidStack drainFromSlave(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.inputTank.getFluid())) {
            return null;
        }
        int max = this.inputTank.getFluidAmount() - this.getCurrentMaxFluidValue();
        if (max < 0) {
            max = 0;
        }
        return this.inputTank.drain(resource.amount < max ? resource.amount : max, doDrain);
    }

    public FluidStack drainFromSlave(ForgeDirection from, int maxDrain, boolean doDrain) {
        int max = this.inputTank.getFluidAmount() - this.getCurrentMaxFluidValue();
        if (max < 0) {
            max = 0;
        }
        return this.inputTank.drain(maxDrain < max ? maxDrain : max, doDrain);
    }

    public boolean canFillFromSlave(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrainFromSlave(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.inputTank.getInfo()};
    }

    public void setFluidAmountIn(int value) {
        FluidStack fluid = this.inputTank.getFluid();
        if (fluid != null) {
            fluid.amount = value;
        }
    }

    public void setFluidTypeIn(int id) {
        Fluid f = FluidRegistry.getFluid((int)id);
        if (f != null) {
            this.inputTank.setFluid(new FluidStack(f, 0));
        } else {
            this.inputTank.setFluid(null);
        }
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply) {
        if (id <= 2) {
            super.buttonClicked(id, ply);
        } else if (this.func_70300_a(ply)) {
            switch (id) {
                case 3: {
                    if (this.liquidLevel >= 10) break;
                    this.liquidLevel = (byte)(this.liquidLevel + 1);
                    break;
                }
                case 4: {
                    if (this.liquidLevel <= 0) break;
                    this.liquidLevel = (byte)(this.liquidLevel - 1);
                    break;
                }
                case 5: {
                    if (this.intensity >= 10) break;
                    this.intensity = (byte)(this.intensity + 1);
                    break;
                }
                case 6: {
                    if (this.intensity <= 0) break;
                    this.intensity = (byte)(this.intensity - 1);
                    break;
                }
                case 7: {
                    this.inputTank.setFluid(null);
                    this.needUpdate();
                }
            }
        }
    }

    void playAmbientSound(boolean goodTick) {
        ReactionBeamFocus focus;
        ItemStack focusitem = this.content[1];
        if (focusitem != null && (focus = ReactionBeamFocus.getBeamFocus(focusitem)) != null) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, focus.getSound(), 1.0f, 1.0f, true);
        }
        BlockCoords pos = this.getCenterPos();
        Random rng = new Random();
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_72869_a("spell", (double)((float)pos.x + rng.nextFloat()), (double)((float)pos.y + rng.nextFloat()), (double)((float)pos.z + rng.nextFloat()), 0.0, 1.0, 0.0);
        }
        if (goodTick) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.rc_beep", 1.0f, 1.0f, true);
        } else {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.rc_warning", 1.0f, 1.0f, true);
        }
    }

    public int getCurrentMaxFluidValue() {
        return this.liquidLevel * 1000;
    }

    public int getValidSlotForItemInMachine(ItemStack stack1) {
        if (stack1.func_77973_b() == TGItems.sharedItem && TGItems.sharedItem.slotType[stack1.func_77960_j()] == TGSlotType.REACTION_CHAMBER_FOCUS) {
            return 1;
        }
        return 0;
    }
}

