/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.util.PacketUtil;

public class PacketTGExtendedPlayerSync
implements IMessage {
    public int entityId;
    public ItemStack[] inv;
    public int radlevel;
    public int foodLeft = 0;
    public boolean nightVisionEnabled = false;
    public boolean safemodeEnabled = true;
    public float lastSaturation = 0.0f;
    public boolean hovermodeEnabled = false;
    public byte size;
    public boolean stepAssist;
    public boolean showHUD;
    private boolean allSlots = false;

    public PacketTGExtendedPlayerSync() {
    }

    public PacketTGExtendedPlayerSync(EntityPlayer ply, TechgunsExtendedPlayerProperties props, boolean allSlots) {
        this.entityId = ply.func_145782_y();
        this.radlevel = props.radlevel;
        this.nightVisionEnabled = props.enableNightVision;
        this.safemodeEnabled = props.enableSafemode;
        this.hovermodeEnabled = props.enableHovermode;
        this.inv = props.TG_inventory.inventory;
        this.size = (byte)(allSlots ? (int)this.inv.length : 2);
        if (allSlots) {
            this.foodLeft = props.foodleft;
            this.lastSaturation = props.lastSaturation;
            this.stepAssist = props.enableStepAssist;
            this.showHUD = props.showTGHudElements;
        }
        this.allSlots = allSlots;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.radlevel = buf.readInt();
        this.size = buf.readByte();
        this.inv = new ItemStack[this.size];
        for (int i = 0; i < this.size; ++i) {
            try {
                this.inv[i] = PacketUtil.readItemStackFromBuffer(buf);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.size > 2) {
            this.foodLeft = buf.readShort();
            this.lastSaturation = buf.readFloat();
            this.nightVisionEnabled = buf.readBoolean();
            this.safemodeEnabled = buf.readBoolean();
            this.hovermodeEnabled = buf.readBoolean();
            this.stepAssist = buf.readBoolean();
            this.showHUD = buf.readBoolean();
            this.allSlots = true;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.radlevel);
        buf.writeByte((int)this.size);
        for (int i = 0; i < this.size; ++i) {
            try {
                PacketUtil.writeItemStackToBuffer(buf, this.inv[i]);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.size > 2) {
            buf.writeShort(this.foodLeft);
            buf.writeFloat(this.lastSaturation);
            buf.writeBoolean(this.nightVisionEnabled);
            buf.writeBoolean(this.safemodeEnabled);
            buf.writeBoolean(this.hovermodeEnabled);
            buf.writeBoolean(this.stepAssist);
            buf.writeBoolean(this.showHUD);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketTGExtendedPlayerSync, IMessage> {
        public IMessage onMessage(PacketTGExtendedPlayerSync message, MessageContext ctx) {
            EntityPlayer local_ply = TGPackets.getPlayerFromContext(ctx);
            Entity ent = local_ply.field_70170_p.func_73045_a(message.entityId);
            if (ent != null && ent instanceof EntityPlayer) {
                EntityPlayer ply = (EntityPlayer)ent;
                TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(ply);
                if (props == null) {
                    props = Techguns.proxy.registerExtendedProperties(ply);
                }
                props.radlevel = message.radlevel;
                props.lastSaturation = message.lastSaturation;
                props.foodleft = message.foodLeft;
                props.enableNightVision = message.nightVisionEnabled;
                props.enableSafemode = message.safemodeEnabled;
                props.enableHovermode = message.hovermodeEnabled;
                props.enableStepAssist = message.stepAssist;
                props.showTGHudElements = message.showHUD;
                for (int i = 0; i < message.size; ++i) {
                    props.TG_inventory.inventory[i] = ItemStack.func_77944_b((ItemStack)message.inv[i]);
                }
            }
            return null;
        }
    }
}

