/*
 * Decompiled with CFR 0.152.
 */
package techguns.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.Optional;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import techguns.gui.GuiAmmoPress;
import techguns.gui.GuiMetalPress;
import techguns.inventory.MetalPressRecipes;
import techguns.util.TextUtil;

@Optional.Interface(iface="codechicken.nei.api.API", modid="NotEnoughItems")
public class TechgunsMetalPressNEIRecipeHandler
extends TemplateRecipeHandler {
    private static final String ID = "Techguns:MetalPress";
    public static final int ICON_OFFSET_X = -5;
    public static final int ICON_OFFSET_Y = -11;
    private ResourceLocation texture_gui_elemets = GuiAmmoPress.texture;

    @Optional.Method(modid="NotEnoughItems")
    public String getRecipeName() {
        return TextUtil.trans("techguns.container.metalpress");
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getGuiTexture() {
        return GuiMetalPress.texture.toString();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(-5 + 123 - 1, -11 + 36 - 1, 12, 23), TechgunsMetalPressNEIRecipeHandler.getIDString(), new Object[0]));
    }

    public static String getIDString() {
        return ID;
    }

    public void loadAllRecipes() {
        for (MetalPressRecipes.MetalPressRecipe recipe : MetalPressRecipes.getRecipes()) {
            if (recipe == null) continue;
            ArrayList<ItemStack> inputs1 = recipe.getInputs(1);
            ArrayList<ItemStack> inputs2 = recipe.getInputs(2);
            this.arecipes.add(new CachedMetalPressRecipe(new MetalPressRecipe(inputs1, inputs2, recipe.output)));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(ID)) {
            this.loadAllRecipes();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void drawExtras(int recipe) {
        int color = -1;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture_gui_elemets);
        this.drawProgressBar(3, 6, 251, 1, 4, 48, 100, 7);
        this.drawProgressBar(118, 25, 180, 0, 10, 21, 100, 1);
        int power = MetalPressRecipes.getTotalPower(recipe);
        int time = MetalPressRecipes.getTotaltime(recipe);
        GuiDraw.gui.func_73732_a(GuiDraw.fontRenderer, power + " RF", 52, 14, color);
        GuiDraw.gui.func_73732_a(GuiDraw.fontRenderer, time + " ticks", 52, 24, color);
    }

    public void loadCraftingRecipes(ItemStack result) {
        MetalPressRecipes.MetalPressRecipe recipe = MetalPressRecipes.getRecipesFor(result);
        if (recipe != null) {
            ArrayList<ItemStack> inputs1 = recipe.getInputs(1);
            ArrayList<ItemStack> inputs2 = recipe.getInputs(2);
            ItemStack res2 = result.func_77946_l();
            res2.field_77994_a = recipe.output.field_77994_a;
            this.arecipes.add(new CachedMetalPressRecipe(new MetalPressRecipe(inputs1, inputs2, res2)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (MetalPressRecipes.hasRecipeUsing(ingredient)) {
            ArrayList<MetalPressRecipes.MetalPressRecipe> recipes = MetalPressRecipes.getRecipesUsing(ingredient);
            for (MetalPressRecipes.MetalPressRecipe r : recipes) {
                ArrayList<ItemStack> slot1 = r.slot1.getItemStacks();
                ArrayList<ItemStack> slot2 = r.slot2.getItemStacks();
                this.arecipes.add(new CachedMetalPressRecipe(new MetalPressRecipe(slot1, slot2, r.output)));
            }
        }
    }

    public class CachedMetalPressRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public MetalPressRecipe recipe;

        public CachedMetalPressRecipe(MetalPressRecipe recipe) {
            super((TemplateRecipeHandler)TechgunsMetalPressNEIRecipeHandler.this);
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return this.recipe.output;
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            return super.getCycledIngredients(cycle, ingredients);
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.recipe.input1);
            recipestacks.add(this.recipe.input2);
            return (ArrayList)this.getCycledIngredients(TechgunsMetalPressNEIRecipeHandler.this.cycleticks / 24, recipestacks);
        }
    }

    public static class MetalPressRecipe {
        public PositionedStack input1;
        public PositionedStack input2;
        public PositionedStack output;

        public MetalPressRecipe(List<ItemStack> input1, List<ItemStack> input2, ItemStack output) {
            this.input1 = new PositionedStack(input1, 105, 6);
            this.input2 = new PositionedStack(input2, 125, 6);
            this.output = new PositionedStack((Object)new ItemStack(output.func_77973_b(), output.field_77994_a, output.func_77960_j()), 115, 49);
        }
    }
}

