/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.entities.projectiles.TeslaBeam;
import techguns.util.EntityDeathUtils;

public class TeslaProjectile
extends GenericProjectile {
    float chainDmgDrop;
    int chain;

    public TeslaProjectile(World par1World) {
        super(par1World);
        this.speed = 5.0f;
        this.ticksToLive = 10;
        this.lifetime = 10;
    }

    public TeslaProjectile(World par2World, EntityLivingBase par3Player, float damage, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, int chain, float chainDmgDrop, boolean blockdamage) {
        super(par2World, par3Player, damage, 5.0f, 10, 0.0f, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
        this.speed = 5.0f;
        this.ticksToLive = 10;
        this.lifetime = 10;
        this.chain = chain;
        this.chainDmgDrop = chainDmgDrop;
    }

    public TeslaProjectile(World par2World, EntityLivingBase par3Player, double x, double y, double z, Entity target, float damage, int dmgDropStart, int dmgDropEnd, float dmgMin, int chain, float chainDmgDrop) {
        super(par2World);
        this.speed = 5.0f;
        this.ticksToLive = 10;
        this.lifetime = 10;
        this.shooter = par3Player;
        this.func_70105_a(0.25f, 0.25f);
        double dX = x - target.field_70165_t;
        double dY = y - target.field_70163_u;
        double dZ = z - target.field_70161_v;
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        this.func_70012_b(x, y, z, (float)yaw, (float)pitch);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        Vec3 motion = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
        motion.func_72432_b();
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        this.field_70159_w *= (double)this.speed;
        this.field_70181_x *= (double)this.speed;
        this.field_70179_y *= (double)this.speed;
        this.damage = damage;
        this.damageMin = dmgMin;
        this.damageDropStart = dmgDropStart;
        this.damageDropEnd = dmgDropEnd;
        this.chain = chain;
        this.chainDmgDrop = chainDmgDrop;
    }

    @Override
    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (par1MovingObjectPosition.field_72308_g != null) {
            float dmg = 1.0f;
            if (par1MovingObjectPosition.field_72308_g instanceof EntityLivingBase) {
                dmg = DamageSystem.getDamageFactor(this.shooter, (EntityLivingBase)par1MovingObjectPosition.field_72308_g);
            }
            par1MovingObjectPosition.field_72308_g.func_70097_a((DamageSource)this.getProjectileDamageSource(), this.getDamage() * dmg);
            if (par1MovingObjectPosition.field_72308_g instanceof EntityLiving) {
                this.setAIRevengeTarget((EntityLiving)par1MovingObjectPosition.field_72308_g);
            }
            Entity target = par1MovingObjectPosition.field_72308_g;
            double lastx = target.field_70165_t;
            double lasty = target.field_70163_u + (double)(target.field_70131_O / 2.0f);
            double lastz = target.field_70161_v;
            List<Entity> targets = this.getChainingTargets(par1MovingObjectPosition.field_72308_g, this.chain);
            for (int i = 0; i < targets.size(); ++i) {
                Entity t = targets.get(i);
                this.field_70170_p.func_72838_d((Entity)new TeslaBeam(this.field_70170_p, this.shooter, lastx, lasty, lastz, t));
                dmg = 1.0f;
                if (t instanceof EntityLivingBase) {
                    dmg = DamageSystem.getDamageFactor(this.shooter, (EntityLivingBase)t);
                }
                t.func_70097_a((DamageSource)this.getProjectileDamageSource(), this.getDamage() - this.chainDmgDrop * (float)(i + 1) * dmg);
                if (t instanceof EntityLiving) {
                    this.setAIRevengeTarget((EntityLiving)t);
                }
                lastx = t.field_70165_t;
                lasty = t.field_70163_u + (double)(t.field_70131_O / 2.0f);
                lastz = t.field_70161_v;
            }
        }
        this.func_70106_y();
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeLightningDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    private List<Entity> getChainingTargets(Entity lastTarget, int num) {
        List targets = this.field_70170_p.func_72839_b(lastTarget, AxisAlignedBB.func_72330_a((double)(lastTarget.field_70165_t - 5.0), (double)(lastTarget.field_70163_u - 5.0), (double)(lastTarget.field_70161_v - 5.0), (double)(lastTarget.field_70165_t + 5.0), (double)(lastTarget.field_70163_u + 5.0), (double)(lastTarget.field_70161_v + 5.0)));
        ArrayList<Entity> chainTargets = new ArrayList<Entity>(num);
        for (int i1 = 0; i1 < targets.size(); ++i1) {
            Entity entity = (Entity)targets.get(i1);
            try {
                EntityLivingBase elb = (EntityLivingBase)entity;
                if (elb.equals((Object)this.shooter)) continue;
                chainTargets.add((Entity)elb);
                if (--num > 0) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return chainTargets;
    }

    private Entity findNextTarget(Entity lastTarget) {
        List list = this.field_70170_p.func_72839_b(lastTarget, AxisAlignedBB.func_72330_a((double)(lastTarget.field_70165_t - 5.0), (double)(lastTarget.field_70163_u - 5.0), (double)(lastTarget.field_70161_v - 5.0), (double)(lastTarget.field_70165_t + 5.0), (double)(lastTarget.field_70163_u + 5.0), (double)(lastTarget.field_70161_v + 5.0)));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            Entity entity = (Entity)list.get(i1);
            System.out.println(entity.toString());
            double distance = entity.func_70011_f(lastTarget.field_70165_t, lastTarget.field_70163_u, lastTarget.field_70161_v);
            if (!(distance < 5.0) || !entity.func_70089_S() || entity == lastTarget) continue;
            try {
                EntityLivingBase elb = (EntityLivingBase)entity;
                if (elb.equals((Object)this.shooter)) continue;
                return entity;
            }
            catch (Exception e) {
                System.out.println("Not a living entity.");
            }
        }
        return null;
    }
}

