/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import techguns.TGPackets;
import techguns.damagesystem.DamageSystem;
import techguns.entities.projectiles.GenericProjectile;
import techguns.packets.PacketSpawnParticle;
import techguns.util.ProjectileExplosion;

public class GrenadeProjectile
extends GenericProjectile {
    protected float radius;
    protected float gravity;
    protected boolean blockdamage;
    protected int bounces;

    public GrenadeProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.01f;
    }

    public GrenadeProjectile(World par2World, EntityLivingBase par3Player, float damage, float radius, float speed, int TTL, float spread, float gravity, boolean blockdamage, float penetration, int maxBounces) {
        super(par2World, par3Player, damage, speed, TTL, spread, 0, 0, 0.0f, penetration, blockdamage);
        this.radius = radius;
        this.gravity = gravity;
        this.blockdamage = blockdamage;
        this.bounces = maxBounces;
    }

    public GrenadeProjectile(World par2World, EntityLivingBase par3Player, float damage, float radius, float speed, int TTL, float spread, float gravity, boolean blockdamage, float penetration, int maxBounces, double x, double y, double z) {
        super(par2World, par3Player, damage, speed, TTL, spread, 0, 0, 0.0f, penetration, blockdamage);
        this.func_70107_b(x, y, z);
        this.radius = radius;
        this.gravity = gravity;
        this.blockdamage = blockdamage;
        this.bounces = maxBounces;
    }

    public GrenadeProjectile(World par2World, double posx, double posy, double posz, float damage, float radius, float speed, int TTL, float spread, float gravity, boolean blockdamage, float penetration, int maxBounces, double x, double y, double z) {
        super(par2World, posx, posy, posz, damage, speed, TTL, spread, 0, 0, 0.0f, penetration, blockdamage);
        this.func_70107_b(x, y, z);
        this.radius = radius;
        this.gravity = gravity;
        this.blockdamage = blockdamage;
        this.bounces = maxBounces;
    }

    protected void explode(Entity enthit) {
        ProjectileExplosion explosion = new ProjectileExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this, this.radius, (int)this.damage, this.radius * 0.5f, this.radius * 1.5f);
        explosion.setExplosionSound("techguns:effects.explosion1");
        if (enthit != null) {
            float dmg = 1.0f;
            if (enthit instanceof EntityLivingBase) {
                dmg = DamageSystem.getDamageFactor(this.shooter, (EntityLivingBase)enthit);
            }
            if (dmg > 0.0f) {
                enthit.func_70097_a(DamageSource.func_94539_a((Explosion)explosion.explosion), dmg * this.damage);
                if (enthit instanceof EntityLiving) {
                    this.setAIRevengeTarget((EntityLiving)enthit);
                }
            }
        }
        explosion.doExplosion(this.blockdamage, this.shooter);
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("RocketExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
    }

    @Override
    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (par1MovingObjectPosition.field_72308_g != null || this.bounces <= 0) {
            this.explode(par1MovingObjectPosition.field_72308_g);
            this.func_70106_y();
        } else {
            --this.bounces;
            int sideHit = par1MovingObjectPosition.field_72310_e;
            if (sideHit != -1) {
                Vec3 normal = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
                switch (sideHit) {
                    case 0: {
                        normal = Vec3.func_72443_a((double)0.0, (double)-1.0, (double)0.0);
                        break;
                    }
                    case 1: {
                        normal = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
                        break;
                    }
                    case 2: {
                        normal = Vec3.func_72443_a((double)0.0, (double)0.0, (double)-1.0);
                        break;
                    }
                    case 3: {
                        normal = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
                        break;
                    }
                    case 4: {
                        normal = Vec3.func_72443_a((double)-1.0, (double)0.0, (double)0.0);
                        break;
                    }
                    case 5: {
                        normal = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
                    }
                }
                Vec3 motion = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
                float len = this.getBounceSpeedFactor();
                double factor = 2.0 * normal.func_72430_b(motion);
                Vec3 n = Vec3.func_72443_a((double)(normal.field_72450_a * factor), (double)(normal.field_72448_b * factor), (double)(normal.field_72449_c * factor));
                Vec3 refl = n.func_72444_a(motion);
                this.playBounceSound();
                if (!this.field_70170_p.field_72995_K) {
                    GrenadeProjectile gren = this.createBounceProjectile();
                    gren.field_70159_w = refl.field_72450_a * (double)len;
                    gren.field_70181_x = refl.field_72448_b * (double)len;
                    gren.field_70179_y = refl.field_72449_c * (double)len;
                    this.field_70170_p.func_72838_d((Entity)gren);
                    this.createProjectileTrail(gren);
                }
                this.func_70106_y();
            }
        }
    }

    protected float getBounceSpeedFactor() {
        return 0.5f;
    }

    protected void playBounceSound() {
        this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.hit", 2.0f, 1.0f);
    }

    protected void createProjectileTrail(GrenadeProjectile gren) {
    }

    protected GrenadeProjectile createBounceProjectile() {
        if (this.shooter != null) {
            return new GrenadeProjectile(this.field_70170_p, this.shooter, this.damage, this.radius, this.speed, this.ticksToLive, 0.0f, this.gravity, false, this.penetration, this.bounces, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        return new GrenadeProjectile(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.damage, this.radius, this.speed, this.ticksToLive, 0.0f, this.gravity, false, this.penetration, this.bounces, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    protected float getGravityVelocity() {
        return this.gravity;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ticksToLive <= 1) {
            this.explode(null);
            this.func_70106_y();
        }
        if (this.func_70090_H()) {
            for (int l = 0; l < 2; ++l) {
                float f = 0.5f;
            }
            this.func_70106_y();
        } else {
            float f = 0.1f;
        }
    }
}

