/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.tileentity;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import techguns.blocks.machines.OreDrillBlock;
import techguns.client.renderer.block.OreDrillCube;
import techguns.tileentities.OreDrillTileEntMaster;

public class RenderOreDrill
extends TileEntitySpecialRenderer {
    private static final int DRILLERCUBESPERBLOCK = 4;
    private ResourceLocation texture = new ResourceLocation("techguns", "textures/blocks/drillhead.png");
    private OreDrillCube tessellatorcube = new OreDrillCube(this.texture);
    private ResourceLocation texture2 = new ResourceLocation("techguns", "textures/blocks/drillheadObsidian.png");
    private OreDrillCube tessellatorcube2 = new OreDrillCube(this.texture2);
    private ResourceLocation texture3 = new ResourceLocation("techguns", "textures/blocks/drillheadCarbon.png");
    private OreDrillCube tessellatorcube3 = new OreDrillCube(this.texture3);

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTick) {
        OreDrillTileEntMaster tile = (OreDrillTileEntMaster)te;
        if (tile.isComplete()) {
            byte direction = tile.dir;
            int[] vec = OreDrillBlock.getNextBlockInDirOffset(0, 0, 0, direction, tile.enginesize + 1);
            int[] dir = OreDrillBlock.getNextBlockInDir(0, 0, 0, direction);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f - (float)vec[0]), (float)((float)y + 1.25f - (float)vec[1]), (float)((float)z + 0.5f - (float)vec[2]));
            GL11.glPushMatrix();
            int rot = (int)(tile.func_145831_w().func_82737_E() % 360L);
            if (dir[1] < 0) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (dir[1] > 0) {
                GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            } else if (dir[0] != 0) {
                GL11.glRotatef((float)(-90.0f * (float)dir[0]), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)dir[0] * 0.75f), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
            } else if (dir[2] != 0) {
                GL11.glRotatef((float)(90.0f * (float)dir[2]), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)dir[2] * 0.75f));
                GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)(2 * (tile.enginesize + 1)), (float)0.0f);
            if (tile.hasDrill && tile.isRedstoneEnabled() && tile.haspower) {
                GL11.glRotatef((float)((float)rot * 10.0f + 0.027777778f * partialTick), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (tile.hasDrill) {
                if (tile.drillType == 1) {
                    this.drawDriller(tile, this.tessellatorcube);
                } else if (tile.drillType == 2) {
                    this.drawDriller(tile, this.tessellatorcube2);
                } else if (tile.drillType == 3) {
                    this.drawDriller(tile, this.tessellatorcube3);
                }
            } else {
                this.drawDrillRod(tile);
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    private void drawDriller(OreDrillTileEntMaster tile, OreDrillCube cube) {
        float height;
        short length = tile.rodsize;
        GL11.glPushMatrix();
        int[] axis = OreDrillBlock.getNextBlockInDir(0, 0, 0, tile.rotation);
        float pos = height = 0.25f;
        boolean negative = false;
        axis[0] = 0;
        axis[1] = 1;
        axis[2] = 0;
        float max = (float)Math.log((float)(length * 4) + 1.0f);
        float radiusfactor = 1.0f;
        switch (tile.radius) {
            case 0: 
            case 1: {
                radiusfactor = 0.35f;
                break;
            }
            case 2: {
                radiusfactor = 0.5f;
                break;
            }
            case 3: {
                radiusfactor = 0.55f;
                break;
            }
            case 4: {
                radiusfactor = 0.6f;
            }
        }
        int[] worldpos = OreDrillBlock.getNextBlockInDirOffset(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.rotation, tile.enginesize);
        for (int i = 0; i < length * 4; ++i) {
            boolean rotate = false;
            if (i % 2 == 1) {
                rotate = true;
            }
            float factor = (float)Math.log((float)(length * 4 - i) + 1.0f);
            float size = (tile.radius == 0 ? 1.0f : (float)tile.radius * 1.0f) * factor * (1.0f / max) * radiusfactor;
            GL11.glTranslatef((float)((float)axis[0] * height), (float)((float)axis[1] * height), (float)((float)axis[2] * height));
            if (rotate) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)45.0f, (float)Math.abs(axis[0]), (float)Math.abs(axis[1]), (float)Math.abs(axis[2]));
            }
            if (i % 4 == 0) {
                this.adjustLightFixture((IBlockAccess)tile.func_145831_w(), worldpos[0], worldpos[1], worldpos[2], tile.func_145838_q());
                worldpos = OreDrillBlock.getNextBlockInDir(worldpos[0], worldpos[1], worldpos[2], tile.rotation);
            }
            cube.drawCube(axis[0] == 0 ? size : pos, axis[1] == 0 ? size : pos, axis[2] == 0 ? size : pos);
            if (!rotate) continue;
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void drawDrillRod(OreDrillTileEntMaster tile) {
        float height;
        int length = tile.rodsize;
        GL11.glPushMatrix();
        int[] axis = OreDrillBlock.getNextBlockInDir(0, 0, 0, tile.rotation);
        float pos = height = 0.5f;
        axis[0] = 0;
        axis[1] = 1;
        axis[2] = 0;
        int[] worldpos = OreDrillBlock.getNextBlockInDirOffset(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.rotation, tile.enginesize);
        float f = -0.4f;
        GL11.glTranslatef((float)((float)axis[0] * height * f), (float)((float)axis[1] * height * f), (float)((float)axis[2] * height * f));
        for (int i = 0; i < length; ++i) {
            float size = 0.2f;
            GL11.glTranslatef((float)((float)axis[0] * height * 2.0f), (float)((float)axis[1] * height * 2.0f), (float)((float)axis[2] * height * 2.0f));
            GL11.glPushMatrix();
            GL11.glRotatef((float)45.0f, (float)Math.abs(axis[0]), (float)Math.abs(axis[1]), (float)Math.abs(axis[2]));
            this.adjustLightFixture((IBlockAccess)tile.func_145831_w(), worldpos[0], worldpos[1], worldpos[2], tile.func_145838_q());
            worldpos = OreDrillBlock.getNextBlockInDir(worldpos[0], worldpos[1], worldpos[2], tile.rotation);
            this.tessellatorcube.drawCube(axis[0] == 0 ? size : pos, axis[1] == 0 ? size : pos, axis[2] == 0 ? size : pos);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void adjustLightFixture(IBlockAccess world, int i, int j, int k, Block block) {
        Tessellator tess = Tessellator.field_78398_a;
        float brightness = block.getLightValue(world, i, j, k);
        int skyLight = world.func_72802_i(i, j, k, 0);
        int modulousModifier = skyLight % 65536;
        int divModifier = skyLight / 65536;
        tess.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)modulousModifier, (float)divModifier);
    }
}

