/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.net.URL;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.client.particle.EntityParticleSystem;
import techguns.client.particle.FXListType;
import techguns.client.particle.FXType;
import techguns.client.particle.ParticleSystemType;
import techguns.client.renderer.TGRenderHelper;

public class FXList {
    public static final String FXLIST_DIR = "/assets/techguns/particles/";
    public static String[] FXFILES = new String[]{"FXList.txt", "Nuke.txt"};
    public static HashMap<String, FXType> FXList = new HashMap();

    public static List<EntityParticleSystem> createFX(World world, String fx, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        if (FXList.containsKey(fx.toLowerCase())) {
            FXType fxtype = FXList.get(fx.toLowerCase());
            List<EntityParticleSystem> list = fxtype.createParticleSystems(world, posX, posY, posZ, motionX, motionY, motionZ);
            return list;
        }
        System.out.println("FX '" + fx + "' not found!");
        return null;
    }

    public static List<EntityParticleSystem> createFXOnEntity(Entity ent, String fx) {
        if (FXList.containsKey(fx.toLowerCase())) {
            FXType fxtype = FXList.get(fx.toLowerCase());
            List<EntityParticleSystem> list = fxtype.createParticleSystemsOnEntity(ent);
            return list;
        }
        System.out.println("FX '" + fx + "' not found!");
        return null;
    }

    public static void loadFXList() {
        URL url = FXList.class.getResource(FXLIST_DIR);
        if (url != null) {
            for (String filename : FXFILES) {
                techguns.client.particle.FXList.loadFXListFile(FXLIST_DIR + filename);
            }
        }
    }

    public static boolean loadFXListFile(String filename) {
        Scanner sc = new Scanner(FXList.class.getResourceAsStream(filename));
        sc.useLocale(Locale.ENGLISH);
        sc.useDelimiter("(\\s*=\\s*)|\\s\\{|\\s*//.*|\\r\\n|\\s+");
        String error = "";
        String next = "";
        String value = "";
        int count = 0;
        try {
            while (sc.hasNextLine() && error.equals("")) {
                boolean end;
                FXType type;
                String name;
                if (sc.hasNext()) {
                    next = sc.next();
                }
                if (next.toLowerCase().equals("fxlist") && sc.hasNext()) {
                    name = sc.next();
                    type = new FXListType();
                    end = false;
                    while (sc.hasNextLine() && !end && error.equals("")) {
                        if (!sc.hasNext() || (next = sc.next()).equals("")) continue;
                        if (next.equals("}")) {
                            end = true;
                            continue;
                        }
                        ((FXListType)type).addParticleSystem(next.toLowerCase());
                    }
                    ++count;
                    FXList.put(name.toLowerCase(), type);
                    continue;
                }
                if (next.equals("")) continue;
                name = next;
                type = new ParticleSystemType();
                end = false;
                while (sc.hasNextLine() && !end && error.equals("")) {
                    if (!sc.hasNext() || (next = sc.next()).equals("")) continue;
                    String key = next;
                    block41 : switch (key.toLowerCase()) {
                        case "extends": {
                            value = sc.next();
                            if (FXList.containsKey(value.toLowerCase())) {
                                FXType fxtype = FXList.get(value.toLowerCase());
                                if (fxtype instanceof ParticleSystemType) {
                                    ((ParticleSystemType)type).extend((ParticleSystemType)fxtype);
                                    break;
                                }
                                error = "'EXTENDS' must specifiy a ParticleSystem, not an FXList.";
                                break;
                            }
                            error = "ParticleSystem '" + value.toLowerCase() + "' not found. Can't extend.";
                            break;
                        }
                        case "rendertype": {
                            value = sc.next();
                            switch (value.toUpperCase().trim()) {
                                case "ADDITIVE": {
                                    ((ParticleSystemType)type).renderType = TGRenderHelper.RenderType.ADDITIVE;
                                    break block41;
                                }
                                case "ALPHA": {
                                    ((ParticleSystemType)type).renderType = TGRenderHelper.RenderType.ALPHA;
                                    break block41;
                                }
                                case "ALPHA_SHADED": {
                                    ((ParticleSystemType)type).renderType = TGRenderHelper.RenderType.ALPHA_SHADED;
                                    break block41;
                                }
                                case "SOLID": {
                                    ((ParticleSystemType)type).renderType = TGRenderHelper.RenderType.SOLID;
                                    break block41;
                                }
                                case "NO_Z_TEST": {
                                    ((ParticleSystemType)type).renderType = TGRenderHelper.RenderType.NO_Z_TEST;
                                    break block41;
                                }
                            }
                            error = name;
                            break;
                        }
                        case "texture": {
                            value = sc.next();
                            ((ParticleSystemType)type).texture = new ResourceLocation(value);
                            break;
                        }
                        case "rows": {
                            ((ParticleSystemType)type).rows = sc.nextInt();
                            break;
                        }
                        case "columns": {
                            ((ParticleSystemType)type).columns = sc.nextInt();
                            break;
                        }
                        case "frames": {
                            ((ParticleSystemType)type).frames = sc.nextInt();
                            break;
                        }
                        case "hasvariations": {
                            ((ParticleSystemType)type).hasVariations = sc.nextBoolean();
                            break;
                        }
                        case "randomrotation": {
                            ((ParticleSystemType)type).randomRotation = sc.nextBoolean();
                            break;
                        }
                        case "lifetime": {
                            ((ParticleSystemType)type).lifetimeMin = sc.nextInt();
                            ((ParticleSystemType)type).lifetimeMax = sc.nextInt();
                            break;
                        }
                        case "systemlifetime": {
                            ((ParticleSystemType)type).systemLifetimeMin = sc.nextInt();
                            ((ParticleSystemType)type).systemLifetimeMax = sc.nextInt();
                            break;
                        }
                        case "animationspeed": {
                            ((ParticleSystemType)type).animationSpeedMin = sc.nextFloat();
                            ((ParticleSystemType)type).animationSpeedMax = sc.nextFloat();
                            break;
                        }
                        case "size": {
                            ((ParticleSystemType)type).sizeMin = sc.nextFloat();
                            ((ParticleSystemType)type).sizeMax = sc.nextFloat();
                            break;
                        }
                        case "sizerate": {
                            ((ParticleSystemType)type).sizeRateMin = sc.nextFloat();
                            ((ParticleSystemType)type).sizeRateMax = sc.nextFloat();
                            break;
                        }
                        case "sizeratedamping": {
                            ((ParticleSystemType)type).sizeRateDampingMin = sc.nextFloat();
                            ((ParticleSystemType)type).sizeRateDampingMax = sc.nextFloat();
                            break;
                        }
                        case "startsizerate": {
                            ((ParticleSystemType)type).startSizeRateMin = sc.nextFloat();
                            ((ParticleSystemType)type).startSizeRateMax = sc.nextFloat();
                            break;
                        }
                        case "startsizeratedamping": {
                            ((ParticleSystemType)type).startSizeRateDampingMin = sc.nextFloat();
                            ((ParticleSystemType)type).startSizeRateDampingMax = sc.nextFloat();
                            break;
                        }
                        case "alpha": {
                            ((ParticleSystemType)type).alphaEntries.add(new ParticleSystemType.AlphaEntry(sc.nextFloat(), sc.nextFloat()));
                            break;
                        }
                        case "color": {
                            ((ParticleSystemType)type).colorEntries.add(new ParticleSystemType.ColorEntry(sc.nextInt(), sc.nextInt(), sc.nextInt(), sc.nextFloat()));
                            break;
                        }
                        case "particlecount": {
                            ((ParticleSystemType)type).particleCountMin = sc.nextInt();
                            ((ParticleSystemType)type).particleCountMax = sc.nextInt();
                            break;
                        }
                        case "initialdelay": {
                            ((ParticleSystemType)type).initialDelayMin = sc.nextInt();
                            ((ParticleSystemType)type).initialDelayMax = sc.nextInt();
                            break;
                        }
                        case "spawndelay": {
                            ((ParticleSystemType)type).spawnDelayMin = sc.nextInt();
                            ((ParticleSystemType)type).spawnDelayMax = sc.nextInt();
                            break;
                        }
                        case "velocitytype": {
                            value = sc.next();
                            switch (value.toUpperCase()) {
                                case "SPHERICAL": {
                                    ((ParticleSystemType)type).velocityType = ParticleSystemType.VEL_SPHERICAL;
                                    break block41;
                                }
                                case "ORTHO": {
                                    ((ParticleSystemType)type).velocityType = ParticleSystemType.VEL_ORTHO;
                                    break block41;
                                }
                                case "HEMISPHERICAL": {
                                    ((ParticleSystemType)type).velocityType = ParticleSystemType.VEL_HEMISPHERICAL;
                                    break block41;
                                }
                                case "OUTWARD": {
                                    ((ParticleSystemType)type).velocityType = ParticleSystemType.VEL_OUTWARD;
                                    break block41;
                                }
                            }
                            error = name;
                            break;
                        }
                        case "velocity1": {
                            ((ParticleSystemType)type).velocityDataMin[0] = sc.nextFloat();
                            ((ParticleSystemType)type).velocityDataMax[0] = sc.nextFloat();
                            break;
                        }
                        case "velocity2": {
                            ((ParticleSystemType)type).velocityDataMin[1] = sc.nextFloat();
                            ((ParticleSystemType)type).velocityDataMax[1] = sc.nextFloat();
                            break;
                        }
                        case "velocity3": {
                            ((ParticleSystemType)type).velocityDataMin[2] = sc.nextFloat();
                            ((ParticleSystemType)type).velocityDataMax[2] = sc.nextFloat();
                            break;
                        }
                        case "velocitydamping": {
                            ((ParticleSystemType)type).velocityDampingMin = sc.nextFloat();
                            ((ParticleSystemType)type).velocityDampingMax = sc.nextFloat();
                            break;
                        }
                        case "volumetype": {
                            value = sc.next();
                            switch (value.toUpperCase()) {
                                case "SPHERE": {
                                    ((ParticleSystemType)type).volumeType = ParticleSystemType.VOL_SPHERE;
                                    break block41;
                                }
                                case "CYLINDER": {
                                    ((ParticleSystemType)type).volumeType = ParticleSystemType.VOL_CYLINDER;
                                    break block41;
                                }
                                case "CYLINDER2": {
                                    ((ParticleSystemType)type).volumeType = ParticleSystemType.VOL_CYLINDER2;
                                    break block41;
                                }
                                case "POINT": {
                                    ((ParticleSystemType)type).volumeType = ParticleSystemType.VOL_POINT;
                                    break block41;
                                }
                                case "HEMISPHERE": {
                                    ((ParticleSystemType)type).volumeType = ParticleSystemType.VOL_HEMISPHERE;
                                    break block41;
                                }
                                case "TRAIL": {
                                    ((ParticleSystemType)type).volumeType = ParticleSystemType.VOL_TRAIL;
                                    break block41;
                                }
                            }
                            error = name;
                            break;
                        }
                        case "volume1": {
                            ((ParticleSystemType)type).volumeData[0] = sc.nextFloat();
                            break;
                        }
                        case "volume2": {
                            ((ParticleSystemType)type).volumeData[1] = sc.nextFloat();
                            break;
                        }
                        case "volume3": {
                            ((ParticleSystemType)type).volumeData[2] = sc.nextFloat();
                            break;
                        }
                        case "gravity": {
                            ((ParticleSystemType)type).gravity = sc.nextFloat();
                            break;
                        }
                        case "ishollow": {
                            ((ParticleSystemType)type).isHollow = sc.nextBoolean();
                            break;
                        }
                        case "removeonground": {
                            ((ParticleSystemType)type).removeOnGround = sc.nextBoolean();
                            break;
                        }
                        case "systemvelocityfactor": {
                            ((ParticleSystemType)type).systemVelocityFactorMin = sc.nextFloat();
                            ((ParticleSystemType)type).systemVelocityFactorMax = sc.nextFloat();
                            break;
                        }
                        case "velocitydampingonground": {
                            ((ParticleSystemType)type).velocityDampingOnGroundMin = sc.nextFloat();
                            ((ParticleSystemType)type).velocityDampingOnGroundMax = sc.nextFloat();
                            break;
                        }
                        case "offset": {
                            float x = sc.nextFloat();
                            float y = sc.nextFloat();
                            float z = sc.nextFloat();
                            ((ParticleSystemType)type).offset = Vec3.func_72443_a((double)x, (double)y, (double)z);
                            break;
                        }
                        case "particlesmovewithsystem": {
                            ((ParticleSystemType)type).particlesMoveWithSystem = sc.nextBoolean();
                            break;
                        }
                        case "}": {
                            end = true;
                            System.out.println("Successfully parsed ParticleSystem " + name);
                        }
                    }
                }
                if (error.equals("")) {
                    ++count;
                    FXList.put(name.toLowerCase(), type);
                    continue;
                }
                System.err.println("Error(s) while parsing particle " + name + " in file '" + filename + "'.");
                System.err.println("error");
                sc.close();
                return false;
            }
        }
        catch (InputMismatchException e) {
            e.printStackTrace();
            sc.close();
            return false;
        }
        sc.close();
        System.out.println("Successfully parsed file " + filename + ". " + count + " ParticleSystems loaded.");
        return true;
    }

    public static void killAllParticles() {
        Iterator iter = Minecraft.func_71410_x().field_71441_e.field_72996_f.iterator();
        while (iter.hasNext()) {
            try {
                Entity e = (Entity)iter.next();
                if (!(e instanceof EntityFX)) continue;
                e.func_70106_y();
                Minecraft.func_71410_x().field_71441_e.func_72900_e(e);
                System.out.println("Removed FX entity.");
            }
            catch (Exception exception) {}
        }
    }
}

