/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.Techguns;
import techguns.tileentities.AmmoPressTileEnt;
import techguns.tileentities.BasicInventoryTileEnt;
import techguns.tileentities.BasicPoweredTileEnt;
import techguns.tileentities.CamoBenchTileEnt;
import techguns.tileentities.CampFlagTileEnt;
import techguns.tileentities.ChargingStationTileEnt;
import techguns.tileentities.ChemLabTileEnt;
import techguns.tileentities.ExplosiveChargeAdvTileEnt;
import techguns.tileentities.ExplosiveChargeTileEnt;
import techguns.tileentities.MetalPressTileEnt;
import techguns.tileentities.RepairBenchTileEnt;
import techguns.tileentities.TurretBaseEnt;
import techguns.util.TextUtil;

public class BasicMachine
extends BlockContainer {
    protected static final int MAXMETADATA_VALUE = 10;

    public BasicMachine() {
        this(Material.field_151573_f);
    }

    public BasicMachine(Material mat) {
        super(mat);
        this.func_149647_a(Techguns.tabTechgun);
        this.func_149711_c(4.0f);
        this.func_149663_c("BasicMachine");
        this.func_149672_a(field_149777_j);
        this.func_149752_b(20.0f);
        for (int i = 0; i < 6; ++i) {
            this.setHarvestLevel("pickaxe", 1, i);
        }
        this.setHarvestLevel("pickaxe", 1, 7);
        this.func_149658_d("techguns:screen_top");
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (meta == 6 || meta == 8) {
            return true;
        }
        return super.canHarvestBlock(player, meta);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6 || meta == 8) {
            return 0.1f;
        }
        return this.field_149782_v;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof BasicPoweredTileEnt) {
            ((BasicPoweredTileEnt)tile).onNeighborBlockChange();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int ix = 0; ix < 10; ++ix) {
            if (ix == 7) continue;
            subItems.add(new ItemStack(item, 1, ix));
        }
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        this.func_149719_a((IBlockAccess)p_149668_1_, p_149668_2_, p_149668_3_, p_149668_4_);
        return super.func_149668_a(p_149668_1_, p_149668_2_, p_149668_3_, p_149668_4_);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World p_149633_1_, int p_149633_2_, int p_149633_3_, int p_149633_4_) {
        this.func_149719_a((IBlockAccess)p_149633_1_, p_149633_2_, p_149633_3_, p_149633_4_);
        return super.func_149633_g(p_149633_1_, p_149633_2_, p_149633_3_, p_149633_4_);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6 || meta == 8) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof ExplosiveChargeTileEnt) {
                ExplosiveChargeTileEnt charge = (ExplosiveChargeTileEnt)tile;
                float w = 0.2f;
                float h = 0.3f;
                if (charge.orientation == 0) {
                    this.func_149676_a(w, 1.0f - h, w, 1.0f - w, 1.0f, 1.0f - w);
                } else if (charge.orientation == 1) {
                    this.func_149676_a(w, 0.0f, w, 1.0f - w, h, 1.0f - w);
                } else if (charge.orientation == 2) {
                    this.func_149676_a(w, w, 1.0f - h, 1.0f - w, 1.0f - w, 1.0f);
                } else if (charge.orientation == 3) {
                    this.func_149676_a(w, w, 0.0f, 1.0f - w, 1.0f - w, h);
                } else if (charge.orientation == 4) {
                    this.func_149676_a(1.0f - h, w, w, 1.0f, 1.0f - w, 1.0f - w);
                } else if (charge.orientation == 5) {
                    this.func_149676_a(0.0f, w, w, h, 1.0f - w, 1.0f - w);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new AmmoPressTileEnt();
            }
            case 1: {
                return new MetalPressTileEnt();
            }
            case 2: {
                return new TurretBaseEnt();
            }
            case 3: {
                return new CamoBenchTileEnt();
            }
            case 4: {
                return new ChemLabTileEnt();
            }
            case 5: {
                return new RepairBenchTileEnt();
            }
            case 6: {
                return new ExplosiveChargeTileEnt();
            }
            case 7: {
                return new CampFlagTileEnt();
            }
            case 8: {
                return new ExplosiveChargeAdvTileEnt();
            }
            case 9: {
                return new ChargingStationTileEnt();
            }
        }
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile;
        if (meta == 2) {
            TurretBaseEnt ent = (TurretBaseEnt)world.func_147438_o(x, y, z);
            if (ent.mountedTurret != null) {
                ent.mountedTurret.destroy();
            }
        }
        if ((tile = world.func_147438_o(x, y, z)) instanceof BasicInventoryTileEnt) {
            ((BasicInventoryTileEnt)tile).onBlockBreak();
        }
        world.func_147475_p(x, y, z);
    }

    public Item func_149650_a(int meta, Random rnd, int i2) {
        if (meta != 7) {
            return Item.func_150898_a((Block)this);
        }
        return Items.field_151042_j;
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.direction(world, x, y, z);
    }

    protected void direction(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 1;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 0;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 3;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 2;
            }
            BasicInventoryTileEnt tile = (BasicInventoryTileEnt)world.func_147438_o(x, y, z);
            tile.rotation = (byte)b0;
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase ent, ItemStack item) {
        int dir = MathHelper.func_76128_c((double)((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        BasicInventoryTileEnt tile = (BasicInventoryTileEnt)world.func_147438_o(x, y, z);
        if (ent instanceof EntityPlayer && tile instanceof BasicPoweredTileEnt) {
            ((BasicPoweredTileEnt)tile).setOwner((EntityPlayer)ent);
        }
        if (!world.field_72995_K) {
            NBTTagCompound data = item.func_77978_p();
            if (data != null && data.func_74764_b("TileEntityData")) {
                tile.readEntityDataFromNBT(data.func_74775_l("TileEntityData"));
                tile.rotation = (byte)((dir + 2) % 4);
            }
            if (tile instanceof TurretBaseEnt && !((TurretBaseEnt)tile).turretDeath) {
                ((TurretBaseEnt)tile).spawnTurret(world, x, y, z);
            }
            tile.needUpdate();
        } else {
            tile.rotation = (byte)((dir + 2) % 4);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i1, float f1, float f2, float f3) {
        int meta = world.func_72805_g(x, y, z);
        ItemStack helditem = player.func_70694_bm();
        if (helditem != null && helditem.func_77973_b().getToolClasses(helditem).contains("wrench") && meta != 6 && meta != 8 && meta != 7) {
            BasicInventoryTileEnt tileent = (BasicInventoryTileEnt)world.func_147438_o(x, y, z);
            if (!player.func_70093_af()) {
                tileent.rotate();
                return true;
            }
            if (!world.field_72995_K) {
                NBTTagCompound tileEntTags = new NBTTagCompound();
                tileent.writeEntityDataToNBT(tileEntTags);
                ItemStack item = new ItemStack(Item.func_150898_a((Block)TGBlocks.basicMachine), 1, meta);
                NBTTagCompound itemnbt = item.func_77978_p();
                if (itemnbt == null) {
                    itemnbt = new NBTTagCompound();
                    item.func_77982_d(itemnbt);
                }
                itemnbt.func_74782_a("TileEntityData", (NBTBase)tileEntTags);
                tileent.emptyContent();
                world.func_147468_f(x, y, z);
                world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, item));
            }
            return false;
        }
        if (meta < 10) {
            if (meta == 6 || meta == 8) {
                ExplosiveChargeTileEnt charge = (ExplosiveChargeTileEnt)world.func_147438_o(x, y, z);
                if (charge.isArmed()) {
                    return false;
                }
                player.openGui((Object)"Techguns", 6, world, x, y, z);
                return true;
            }
            if (meta == 7) {
                return false;
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof BasicPoweredTileEnt) {
                BasicPoweredTileEnt pwrtile = (BasicPoweredTileEnt)tile;
                if (pwrtile.func_70300_a(player)) {
                    player.openGui((Object)"Techguns", meta, world, x, y, z);
                    return true;
                }
                if (player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.container.security.denied")));
                }
                return true;
            }
            player.openGui((Object)"Techguns", meta, world, x, y, z);
            return true;
        }
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta <= 5 && meta < 9;
    }
}

