/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdDelay
extends WBCmd {
    public CmdDelay() {
        this.permission = "delay";
        this.name = "delay";
        this.maxParams = 1;
        this.minParams = 1;
        this.addCmdExample(this.nameEmphasized() + "<amount> - time between border checks.");
        this.helpText = "Default value: 5. The <amount> is in server ticks, of which there are roughly 20 every second, each tick taking ~50ms. The default value therefore has border checks run about 4 times per second.";
    }

    @Override
    public void cmdStatus(ICommandSender sender) {
        int delay = Config.getTimerTicks();
        Util.chat(sender, C_HEAD + "Timer delay is set to " + delay + " tick(s). That is roughly " + delay * 50 + "ms.", new Object[0]);
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        int delay = 0;
        try {
            delay = Integer.parseInt(params.get(0));
            if (delay < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "The timer delay must be an integer of 1 or higher.");
            return;
        }
        Config.setTimerTicks(delay);
        if (player != null) {
            this.cmdStatus(sender);
        }
    }
}

