/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdClear
extends WBCmd {
    public CmdClear() {
        this.permission = "clear";
        this.name = "clear";
        this.hasWorldNameInput = true;
        this.consoleRequiresWorldName = false;
        this.minParams = 0;
        this.maxParams = 1;
        this.addCmdExample(this.nameEmphasizedW() + "- remove border for this world.");
        this.addCmdExample(this.nameEmphasized() + "^all - remove border for all worlds.");
        this.helpText = "If run by an in-game player and [world] or \"all\" isn't specified, the world you are currently in is used.";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        BorderData border;
        if (params.size() == 1 && params.get(0).equalsIgnoreCase("all")) {
            if (worldName != null) {
                this.sendErrorAndHelp(sender, "You should not specify a world with \"clear all\".");
                return;
            }
            Config.removeAllBorders();
            if (player != null) {
                Util.chat(sender, "All borders have been cleared for all worlds.", new Object[0]);
            }
            return;
        }
        if (worldName == null) {
            if (player == null) {
                this.sendErrorAndHelp(sender, "You must specify a world name from console if not using \"clear all\".");
                return;
            }
            worldName = Worlds.getWorldName(player.field_70170_p);
        }
        if ((border = Config.Border(worldName)) == null) {
            this.sendErrorAndHelp(sender, "This world (\"" + worldName + "\") does not have a border set.");
            return;
        }
        Config.removeBorder(worldName);
        if (player != null) {
            Util.chat(sender, "Border cleared for world \"" + worldName + "\".", new Object[0]);
        }
    }
}

