/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.forge.Location;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Worlds;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class BorderData {
    private double x = 0.0;
    private double z = 0.0;
    private int radiusX = 0;
    private int radiusZ = 0;
    private Boolean shapeRound = null;
    private boolean wrapping = false;
    private double maxX;
    private double minX;
    private double maxZ;
    private double minZ;
    private double radiusXSquared;
    private double radiusZSquared;
    private double DefiniteRectangleX;
    private double DefiniteRectangleZ;
    private double radiusSquaredQuotient;
    public static final LinkedHashSet<Integer> safeOpenBlocks = new LinkedHashSet<Integer>(Arrays.asList(0, 6, 8, 9, 27, 28, 30, 31, 32, 37, 38, 39, 40, 50, 55, 59, 63, 64, 65, 66, 68, 69, 70, 71, 72, 75, 76, 77, 78, 83, 90, 93, 94, 96, 104, 105, 106, 115, 131, 132, 141, 142, 149, 150, 157, 171));
    public static final LinkedHashSet<Integer> painfulBlocks = new LinkedHashSet<Integer>(Arrays.asList(10, 11, 51, 81, 119));
    private static final int limBot = 1;

    public BorderData(double x, double z, int radiusX, int radiusZ, Boolean shapeRound, boolean wrap) {
        this.setData(x, z, radiusX, radiusZ, shapeRound, wrap);
    }

    public BorderData(double x, double z, int radiusX, int radiusZ) {
        this.setData(x, z, radiusX, radiusZ, null);
    }

    public BorderData(double x, double z, int radiusX, int radiusZ, Boolean shapeRound) {
        this.setData(x, z, radiusX, radiusZ, shapeRound);
    }

    public BorderData(double x, double z, int radius) {
        this.setData(x, z, radius, null);
    }

    public BorderData(double x, double z, int radius, Boolean shapeRound) {
        this.setData(x, z, radius, shapeRound);
    }

    public final void setData(double x, double z, int radiusX, int radiusZ, Boolean shapeRound, boolean wrap) {
        this.x = x;
        this.z = z;
        this.shapeRound = shapeRound;
        this.wrapping = wrap;
        this.setRadiusX(radiusX);
        this.setRadiusZ(radiusZ);
    }

    public final void setData(double x, double z, int radiusX, int radiusZ, Boolean shapeRound) {
        this.setData(x, z, radiusX, radiusZ, shapeRound, false);
    }

    public final void setData(double x, double z, int radius, Boolean shapeRound) {
        this.setData(x, z, radius, radius, shapeRound, false);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.maxX = x + (double)this.radiusX;
        this.minX = x - (double)this.radiusX;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
        this.maxZ = z + (double)this.radiusZ;
        this.minZ = z - (double)this.radiusZ;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusX(int radiusX) {
        this.radiusX = radiusX;
        this.maxX = this.x + (double)radiusX;
        this.minX = this.x - (double)radiusX;
        this.radiusXSquared = (double)radiusX * (double)radiusX;
        this.radiusSquaredQuotient = this.radiusXSquared / this.radiusZSquared;
        this.DefiniteRectangleX = Math.sqrt(0.5 * this.radiusXSquared);
    }

    public void setRadiusZ(int radiusZ) {
        this.radiusZ = radiusZ;
        this.maxZ = this.z + (double)radiusZ;
        this.minZ = this.z - (double)radiusZ;
        this.radiusZSquared = (double)radiusZ * (double)radiusZ;
        this.radiusSquaredQuotient = this.radiusXSquared / this.radiusZSquared;
        this.DefiniteRectangleZ = Math.sqrt(0.5 * this.radiusZSquared);
    }

    public void setRadius(int radius) {
        this.setRadiusX(radius);
        this.setRadiusZ(radius);
    }

    public Boolean getShape() {
        return this.shapeRound;
    }

    public void setShape(Boolean shapeRound) {
        this.shapeRound = shapeRound;
    }

    public boolean getWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean wrap) {
        this.wrapping = wrap;
    }

    public BorderData copy() {
        return new BorderData(this.x, this.z, this.radiusX, this.radiusZ, this.shapeRound, this.wrapping);
    }

    public String toString() {
        return String.format("radius %s at X: %s Z: %s%s%s", this.radiusX == this.radiusZ ? Integer.valueOf(this.radiusX) : this.radiusX + "*" + this.radiusZ, Config.COORD_FORMAT.format(this.x), Config.COORD_FORMAT.format(this.z), this.shapeRound != null ? String.format(" (shape override: %s)", Config.getShapeName(this.shapeRound)) : "", this.wrapping ? " (wrapping)" : "");
    }

    public boolean insideBorder(double xLoc, double zLoc, boolean round) {
        if (this.shapeRound != null) {
            round = this.shapeRound;
        }
        if (!round) {
            return !(xLoc < this.minX || xLoc > this.maxX || zLoc < this.minZ || zLoc > this.maxZ);
        }
        double X = Math.abs(this.x - xLoc);
        double Z = Math.abs(this.z - zLoc);
        if (X < this.DefiniteRectangleX && Z < this.DefiniteRectangleZ) {
            return true;
        }
        if (X >= (double)this.radiusX || Z >= (double)this.radiusZ) {
            return false;
        }
        return X * X + Z * Z * this.radiusSquaredQuotient < this.radiusXSquared;
    }

    public boolean insideBorder(double xLoc, double zLoc) {
        return this.insideBorder(xLoc, zLoc, Config.getShapeRound());
    }

    public boolean insideBorder(Location loc) {
        return this.insideBorder(loc.posX, loc.posZ, Config.getShapeRound());
    }

    public boolean insideBorder(CoordXZ coord, boolean round) {
        return this.insideBorder(coord.x, coord.z, round);
    }

    public boolean insideBorder(CoordXZ coord) {
        return this.insideBorder(coord.x, coord.z, Config.getShapeRound());
    }

    public Location correctedPosition(Location loc, boolean round, boolean flying) {
        if (this.shapeRound != null) {
            round = this.shapeRound;
        }
        double xLoc = loc.posX;
        double yLoc = loc.posY;
        double zLoc = loc.posZ;
        double knock = Config.getKnockBack();
        if (knock >= (double)(this.radiusX * 2) || knock >= (double)(this.radiusZ * 2)) {
            Log.warn("Knockback %.2f is too big for border. Defaulting to 3.0.", knock);
            knock = 3.0;
        }
        if (!round) {
            if (this.wrapping) {
                if (xLoc <= this.minX) {
                    xLoc = this.maxX - knock;
                } else if (xLoc >= this.maxX) {
                    xLoc = this.minX + knock;
                }
                if (zLoc <= this.minZ) {
                    zLoc = this.maxZ - knock;
                } else if (zLoc >= this.maxZ) {
                    zLoc = this.minZ + knock;
                }
            } else {
                if (xLoc <= this.minX) {
                    xLoc = this.minX + knock;
                } else if (xLoc >= this.maxX) {
                    xLoc = this.maxX - knock;
                }
                if (zLoc <= this.minZ) {
                    zLoc = this.minZ + knock;
                } else if (zLoc >= this.maxZ) {
                    zLoc = this.maxZ - knock;
                }
            }
        } else {
            double dX = xLoc - this.x;
            double dZ = zLoc - this.z;
            double dU = Math.sqrt(dX * dX + dZ * dZ);
            double dT = Math.sqrt(dX * dX / this.radiusXSquared + dZ * dZ / this.radiusZSquared);
            double f = 1.0 / dT - knock / dU;
            if (this.wrapping) {
                xLoc = this.x - dX * f;
                zLoc = this.z - dZ * f;
            } else {
                xLoc = this.x + dX * f;
                zLoc = this.z + dZ * f;
            }
        }
        int ixLoc = Location.locToBlock(xLoc);
        int izLoc = Location.locToBlock(zLoc);
        int icxLoc = CoordXZ.blockToChunk(ixLoc);
        int icZLoc = CoordXZ.blockToChunk(izLoc);
        Chunk tChunk = loc.world.func_72938_d(ixLoc, izLoc);
        if (!tChunk.field_76636_d) {
            loc.world.field_73059_b.func_73158_c(icxLoc, icZLoc);
        }
        if ((yLoc = this.getSafeY(loc.world, ixLoc, Location.locToBlock(yLoc), izLoc, flying)) == -1.0) {
            return null;
        }
        return new Location(loc.world, Math.floor(xLoc) + 0.5, yLoc, Math.floor(zLoc) + 0.5, loc.yaw, loc.pitch);
    }

    public Location correctedPosition(Location loc, boolean round) {
        return this.correctedPosition(loc, round, false);
    }

    public Location correctedPosition(Location loc) {
        return this.correctedPosition(loc, Config.getShapeRound(), false);
    }

    private boolean isSafeSpot(WorldServer world, int X, int Y, int Z, boolean flying) {
        boolean safe;
        boolean bl = safe = safeOpenBlocks.contains(Worlds.getBlockID((World)world, X, Y, Z)) && safeOpenBlocks.contains(Worlds.getBlockID((World)world, X, Y + 1, Z));
        if (!safe || flying) {
            return safe;
        }
        int below = Worlds.getBlockID((World)world, X, Y - 1, Z);
        return !(below == 7 && world.field_73011_w.field_76574_g == -1 || safeOpenBlocks.contains(below) && below != 8 && below != 9 || painfulBlocks.contains(below));
    }

    public double getSafeY(WorldServer world, int X, int Y, int Z, boolean flying) {
        int limTop = world.func_72800_K() - 2;
        int y1 = Y;
        for (int y2 = Y; y1 > 1 || y2 < limTop; --y1, ++y2) {
            if (y1 > 1 && this.isSafeSpot(world, X, y1, Z, flying)) {
                return y1;
            }
            if (y2 >= limTop || y2 == y1 || !this.isSafeSpot(world, X, y2, Z, flying)) continue;
            return y2;
        }
        return -1.0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BorderData test = (BorderData)obj;
        return test.x == this.x && test.z == this.z && test.radiusX == this.radiusX && test.radiusZ == this.radiusZ;
    }

    public int hashCode() {
        return ((int)(this.x * 10.0) << 4) + (int)this.z + (this.radiusX << 2) + (this.radiusZ << 3);
    }
}

