/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.recipes;

import com.google.common.base.Preconditions;
import com.piepenguin.rfwindmill.blocks.ModBlocks;
import com.piepenguin.rfwindmill.items.ModItems;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    public static void init() {
        ModRecipes.registerCommonRecipes();
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            ModRecipes.registerThermalExpansionRecipes();
        } else {
            ModRecipes.registerVanillaRecipes();
        }
    }

    public static void registerCommonRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor1, new Object[]{"i  ", "iii", "  i", Character.valueOf('i'), "ingotIron"}));
    }

    public static void registerVanillaRecipes() {
        String ingotTin = ModRecipes.getOreWithFallback("ingotTin", "ingotIron");
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor2, new Object[]{"g  ", "gig", "  g", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor3, new Object[]{"n  ", "non", "  n", Character.valueOf('n'), Items.field_151128_bU, Character.valueOf('o'), Blocks.field_150343_Z}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor4, new Object[]{"d  ", "dgd", "  d", Character.valueOf('d'), "gemDiamond", Character.valueOf('g'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock1, new Object[]{" x ", "ibi", "iri", Character.valueOf('x'), ModItems.rotor1, Character.valueOf('i'), ingotTin, Character.valueOf('r'), "dustRedstone", Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock2, new Object[]{" x ", "ibi", "iri", Character.valueOf('x'), ModItems.rotor2, Character.valueOf('i'), "ingotGold", Character.valueOf('r'), "dustRedstone", Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock3, new Object[]{" x ", "ibi", "oro", Character.valueOf('x'), ModItems.rotor3, Character.valueOf('i'), Blocks.field_150371_ca, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('r'), "dustRedstone", Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock4, new Object[]{" x ", "dbd", "iri", Character.valueOf('x'), ModItems.rotor4, Character.valueOf('d'), "gemDiamond", Character.valueOf('i'), "ingotGold", Character.valueOf('r'), "dustRedstone", Character.valueOf('b'), "blockIron"}));
    }

    public static void registerThermalExpansionRecipes() {
        ItemStack powerCoilSilver = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilSilver", (int)1));
        ItemStack machineFrameBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineBasic", (int)1));
        ItemStack machineFrameHardened = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineHardened", (int)1));
        ItemStack machineFrameReinforced = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineReinforced", (int)1));
        ItemStack machineFrameResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineResonant", (int)1));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor2, new Object[]{"e  ", "eie", "  e", Character.valueOf('i'), "ingotInvar", Character.valueOf('e'), "ingotElectrum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor3, new Object[]{"s  ", "ses", "  s", Character.valueOf('s'), "ingotSignalum", Character.valueOf('e'), "ingotElectrum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.rotor4, new Object[]{"e  ", "eie", "  e", Character.valueOf('e'), "ingotEnderium", Character.valueOf('i'), "ingotInvar"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock1, new Object[]{" x ", "imi", " c ", Character.valueOf('x'), ModItems.rotor1, Character.valueOf('i'), "ingotTin", Character.valueOf('m'), machineFrameBasic, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock2, new Object[]{" x ", "imi", " c ", Character.valueOf('x'), ModItems.rotor2, Character.valueOf('i'), "ingotInvar", Character.valueOf('m'), machineFrameHardened, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock3, new Object[]{" x ", "imi", " c ", Character.valueOf('x'), ModItems.rotor3, Character.valueOf('i'), "ingotSilver", Character.valueOf('m'), machineFrameReinforced, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.windmillBlock4, new Object[]{" x ", "imi", " c ", Character.valueOf('x'), ModItems.rotor4, Character.valueOf('i'), "ingotPlatinum", Character.valueOf('m'), machineFrameResonant, Character.valueOf('c'), powerCoilSilver}));
    }

    public static String getOreWithFallback(String ore, String fallback) {
        if (OreDictionary.getOres((String)ore).isEmpty()) {
            return fallback;
        }
        return ore;
    }
}

