/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks.modules;

import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Lists;
import com.nauktis.core.utility.BlockPosition;
import com.nauktis.solarflux.blocks.SolarPanelTileEntity;
import com.nauktis.solarflux.blocks.modules.AbstractSolarPanelModule;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.init.ModItems;
import java.util.List;
import net.minecraft.block.BlockFurnace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SimpleEnergyDispenserModule
extends AbstractSolarPanelModule {
    private final List<BlockPosition> mTargets = Lists.newArrayList();
    private int mTargetStartingIndex;
    private int mFurnaceEnergyBuffer;

    public SimpleEnergyDispenserModule(SolarPanelTileEntity pSolarPanelTileEntity) {
        super(pSolarPanelTileEntity);
    }

    @Override
    public void tick() {
        this.sendEnergyToTargets();
        if (this.atRate(this.getTargetRefreshRate())) {
            this.searchTargets();
        }
    }

    protected int getTargetRefreshRate() {
        return 40;
    }

    protected void searchTargets() {
        this.mTargets.clear();
        BlockPosition position = new BlockPosition(((SolarPanelTileEntity)((Object)this.getTileEntity())).x(), ((SolarPanelTileEntity)((Object)this.getTileEntity())).y(), ((SolarPanelTileEntity)((Object)this.getTileEntity())).z());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition neighbor = position.move(direction);
            if (!this.isValidTarget(neighbor)) continue;
            this.mTargets.add(neighbor);
        }
    }

    protected List<BlockPosition> getTargets() {
        return this.mTargets;
    }

    protected void sendEnergyToTargets() {
        if (this.mTargets.size() > 0 && ((SolarPanelTileEntity)((Object)this.getTileEntity())).getEnergyStored() > 0) {
            for (int i = 0; i < this.mTargets.size(); ++i) {
                this.sendEnergyTo(this.mTargets.get((this.mTargetStartingIndex + i) % this.mTargets.size()));
            }
            this.mTargetStartingIndex = (this.mTargetStartingIndex + 1) % this.mTargets.size();
        }
    }

    protected boolean isValidTarget(BlockPosition pPosition) {
        TileEntity tile = ((SolarPanelTileEntity)((Object)this.getTileEntity())).func_145831_w().func_147438_o(pPosition.x(), pPosition.y(), pPosition.z());
        return tile instanceof IEnergyReceiver || ((SolarPanelTileEntity)((Object)this.getTileEntity())).getUpgradeCount(ModItems.mUpgradeFurnace) > 0 && tile instanceof TileEntityFurnace;
    }

    protected void sendEnergyTo(BlockPosition pBlockPosition) {
        TileEntity tile = ((SolarPanelTileEntity)((Object)this.getTileEntity())).func_145831_w().func_147438_o(pBlockPosition.x(), pBlockPosition.y(), pBlockPosition.z());
        if (tile instanceof IEnergyReceiver) {
            this.sendEnergyToReceiver((IEnergyReceiver)tile, pBlockPosition.getDirection().getOpposite());
        } else if (((SolarPanelTileEntity)((Object)this.getTileEntity())).getUpgradeCount(ModItems.mUpgradeFurnace) > 0 && tile instanceof TileEntityFurnace) {
            this.sendEnergyToFurnace((TileEntityFurnace)tile);
        }
    }

    protected void sendEnergyToReceiver(IEnergyReceiver pEnergyReceiver, ForgeDirection pFrom) {
        ((SolarPanelTileEntity)((Object)this.getTileEntity())).getEnergyStorage().sendMaxTo(pEnergyReceiver, pFrom);
    }

    protected void sendEnergyToFurnace(TileEntityFurnace pFurnace) {
        int burnTicksAvailable;
        int FURNACE_COOKING_TICKS = 200;
        int FURNACE_COOKING_ENERGY = 200 * ModConfiguration.getFurnaceUpgradeHeatingConsumption();
        if (this.mFurnaceEnergyBuffer < FURNACE_COOKING_ENERGY) {
            this.mFurnaceEnergyBuffer += ((SolarPanelTileEntity)((Object)this.getTileEntity())).getEnergyStorage().extractEnergy(FURNACE_COOKING_ENERGY - this.mFurnaceEnergyBuffer, false);
        }
        if (pFurnace.func_70301_a(0) != null && pFurnace.field_145956_a < 200 && (burnTicksAvailable = this.mFurnaceEnergyBuffer / ModConfiguration.getFurnaceUpgradeHeatingConsumption()) >= 200) {
            if (pFurnace.field_145956_a == 0) {
                ++pFurnace.field_145956_a;
                BlockFurnace.func_149931_a((pFurnace.field_145956_a > 0 ? 1 : 0) != 0, (World)pFurnace.func_145831_w(), (int)pFurnace.field_145851_c, (int)pFurnace.field_145848_d, (int)pFurnace.field_145849_e);
            }
            pFurnace.field_145956_a += 200;
            this.mFurnaceEnergyBuffer -= 200 * ModConfiguration.getFurnaceUpgradeHeatingConsumption();
        }
    }
}

