/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.core.utility;

import com.google.common.base.Objects;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockPosition {
    private final int mX;
    private final int mY;
    private final int mZ;
    private final ForgeDirection mDirection;

    public BlockPosition(int pX, int pY, int pZ) {
        this(pX, pY, pZ, null);
    }

    public BlockPosition(int pX, int pY, int pZ, ForgeDirection pDirection) {
        this.mX = pX;
        this.mY = pY;
        this.mZ = pZ;
        this.mDirection = pDirection;
    }

    public int x() {
        return this.mX;
    }

    public int y() {
        return this.mY;
    }

    public int z() {
        return this.mZ;
    }

    public ForgeDirection getDirection() {
        return this.mDirection;
    }

    public BlockPosition forward() {
        return new BlockPosition(this.mX + this.mDirection.offsetX, this.mY + this.mDirection.offsetY, this.mZ + this.mDirection.offsetZ, this.mDirection);
    }

    public BlockPosition move(ForgeDirection pDirection) {
        return new BlockPosition(this.mX + pDirection.offsetX, this.mY + pDirection.offsetY, this.mZ + pDirection.offsetZ, pDirection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPosition that = (BlockPosition)o;
        return Objects.equal((Object)this.mX, (Object)that.mX) && Objects.equal((Object)this.mY, (Object)that.mY) && Objects.equal((Object)this.mZ, (Object)that.mZ);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mX, this.mY, this.mZ});
    }

    public String toString() {
        return String.format("[%s,%s,%s]", this.mX, this.mY, this.mZ);
    }
}

