/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.plate;

import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabSecurity;
import cofh.core.render.IconRegistry;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementFluid;
import cofh.lib.gui.element.ElementIcon;
import cofh.lib.gui.element.ElementSimpleToolTip;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.thermalexpansion.block.plate.TilePlateImpulse;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalfoundation.fluid.TFFluids;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiPlateImpulse
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/plate/Plate.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/plate/Plate.png");
    TilePlateImpulse myTile;
    UUID playerName;
    ElementButton decIntensity;
    ElementButton incIntensity;
    ElementButton decAngle;
    ElementButton incAngle;
    ElementIcon plateTop;

    public GuiPlateImpulse(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new ContainerTEBase(inventoryPlayer, tileEntity, false, false), TEXTURE);
        this.myTile = (TilePlateImpulse)tileEntity;
        ((GuiBase)this).name = this.myTile.func_145825_b();
        this.playerName = SecurityHelper.getID((EntityPlayer)inventoryPlayer.field_70458_d);
        ((GuiBase)this).drawInventory = false;
        ((GuiContainer)this).field_147000_g = 100;
        this.generateInfo("tab.thermalexpansion.plate.impulse", 2);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerName));
        }
        this.addElement(new ElementSimpleToolTip((GuiBase)this, 13, 24).setToolTip("info.cofh.force").setSize(24, 24).setTexture("cofh:textures/gui/elements/Info_Force.png", 32, 32));
        this.addElement(new ElementSimpleToolTip((GuiBase)this, 85, 24).setToolTip("info.cofh.angle").setSize(24, 24).setTexture("cofh:textures/gui/elements/Info_Angle.png", 32, 32));
        this.addElement(new ElementFluid((GuiBase)this, 134, 32).setFluid(TFFluids.fluidGlowstone).setSize(16, 16));
        this.decIntensity = new ElementButton((GuiBase)this, 10, 66, "decIntensity", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incIntensity = new ElementButton((GuiBase)this, 26, 66, "incIntensity", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decAngle = new ElementButton((GuiBase)this, 82, 66, "decAngle", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incAngle = new ElementButton((GuiBase)this, 98, 66, "incAngle", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decIntensity);
        this.addElement((ElementBase)this.incIntensity);
        this.addElement((ElementBase)this.decAngle);
        this.addElement((ElementBase)this.incAngle);
        this.plateTop = new ElementIcon((GuiBase)this, 134, 32, IconRegistry.getIcon((String)"PlateTop", (int)this.myTile.getFacing()));
        this.addElement((ElementBase)this.plateTop);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        int n2 = 1;
        float f = 1.0f;
        int n3 = this.myTile.intensity;
        int n4 = this.myTile.angle;
        if (GuiScreen.func_146272_n()) {
            n2 = 100;
            f = 0.9f;
            if (n == 1) {
                n2 = 10;
                f = 0.8f;
            }
        } else if (GuiScreen.func_146271_m()) {
            n2 = 5;
            f = 0.5f;
            if (n == 1) {
                n2 = 1;
                f = 0.4f;
            }
        } else {
            n2 = 50;
            f = 0.7f;
            if (n == 1) {
                n2 = 10;
                f = 0.6f;
            }
        }
        if (string.equalsIgnoreCase("decIntensity")) {
            this.myTile.intensity -= Math.max(1, n2 / 5);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("incIntensity")) {
            this.myTile.intensity += Math.max(1, n2 / 5);
            f += 0.1f;
        } else if (string.equalsIgnoreCase("decAngle")) {
            this.myTile.angle -= n2;
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("incAngle")) {
            this.myTile.angle += n2;
            f += 0.1f;
        }
        GuiPlateImpulse.playSound((String)"random.click", (float)1.0f, (float)f);
        this.myTile.sendModePacket();
        this.myTile.intensity = n3;
        this.myTile.angle = n4;
    }

    protected void updateElementInformation() {
        if (this.myTile.intensity > 0) {
            this.decIntensity.setActive();
        } else {
            this.decIntensity.setDisabled();
        }
        if (this.myTile.intensity < 35) {
            this.incIntensity.setActive();
        } else {
            this.incIntensity.setDisabled();
        }
        if (this.myTile.angle > -150) {
            this.decAngle.setActive();
        } else {
            this.decAngle.setDisabled();
        }
        if (this.myTile.angle < 600) {
            this.incAngle.setActive();
        } else {
            this.incAngle.setDisabled();
        }
        this.plateTop.setIcon(IconRegistry.getIcon((String)"PlateTop", (int)this.myTile.getFacing()));
    }

    protected void func_146979_b(int n, int n2) {
        int n3 = 26;
        int n4 = 92;
        String string = String.format("%-8.1f", (double)this.myTile.intensity / 10.0);
        String string2 = String.format("%-8.1f", (double)this.myTile.angle / 10.0);
        if (this.myTile.angle < 100 && this.myTile.angle >= 0) {
            n4 += 6;
        } else if (this.myTile.angle <= -100) {
            n4 -= 6;
        }
        ((GuiScreen)this).field_146289_q.func_78276_b(string, n3, 56, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(string2, n4, 56, 0x404040);
        super.func_146979_b(n, n2);
    }

    protected void func_73864_a(int n, int n2, int n3) {
        if (134 <= ((GuiBase)this).mouseX && ((GuiBase)this).mouseX < 150 && 32 <= ((GuiBase)this).mouseY && ((GuiBase)this).mouseY < 48) {
            int n4 = this.myTile.getFacing();
            float f = 0.7f;
            if (n3 == 1) {
                n4 += 5;
                f -= 0.1f;
            } else {
                ++n4;
                f += 0.1f;
            }
            if (this.myTile.setFacing(n4 %= 6)) {
                GuiPlateImpulse.playSound((String)"random.click", (float)1.0f, (float)f);
                this.myTile.sendModePacket();
            }
        } else {
            super.func_73864_a(n, n2, n3);
        }
    }
}

