/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenSmallTree;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class SmallTreeParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        Object object;
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        ArrayList<WeightedRandomBlock> arrayList2 = new ArrayList<WeightedRandomBlock>();
        if (jsonObject.has("genMaterial")) {
            object = jsonObject.get("genMaterial");
            if (!object.isJsonNull() && !FeatureParser.parseResList(object, arrayList2, false)) {
                logger.warn("Entry specifies invalid genMaterial for 'smalltree' generator! Using air!");
                arrayList2.clear();
                arrayList2.add(new WeightedRandomBlock(Blocks.field_150350_a));
            }
        } else {
            logger.info("Entry does not specify genMaterial for 'smalltree' generator! There are no restrictions!");
        }
        if (jsonObject.has("leaves")) {
            arrayList = new ArrayList();
            object = jsonObject.get("leaves");
            if (!object.isJsonNull() && !FeatureParser.parseResList(object, arrayList, true)) {
                logger.warn("Entry specifies invalid leaves for 'smalltree' generator!");
                arrayList.clear();
            }
        } else {
            logger.info("Entry does not specify leaves for 'smalltree' generator! There are none!");
        }
        object = new WorldGenSmallTree(list, arrayList, arrayList2);
        object.genSurface = list2.toArray(new WeightedRandomBlock[list2.size()]);
        if (jsonObject.has("minHeight")) {
            object.minHeight = jsonObject.get("minHeight").getAsInt();
        }
        if (jsonObject.has("heightVariance")) {
            object.heightVariance = jsonObject.get("heightVariance").getAsInt();
        }
        if (jsonObject.has("treeChecks")) {
            object.treeChecks = jsonObject.get("treeChecks").getAsBoolean();
        }
        if (jsonObject.has("relaxedGrowth")) {
            object.relaxedGrowth = jsonObject.get("relaxedGrowth").getAsBoolean();
        }
        if (jsonObject.has("waterLoving")) {
            object.waterLoving = jsonObject.get("waterLoving").getAsBoolean();
        }
        if (jsonObject.has("leafVariance")) {
            object.leafVariance = jsonObject.get("leafVariance").getAsBoolean();
        }
        return object;
    }
}

