/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.api.rednet.connectivity;

import java.util.HashMap;
import java.util.Map;

public enum RedNetConnectionType {
    None,
    CableSingle,
    PlateSingle,
    CableAll,
    PlateAll,
    ForcedCableSingle,
    ForcedPlateSingle,
    ForcedCableAll,
    ForcedPlateAll,
    DecorativeSingle,
    DecorativeAll,
    ForcedDecorativeSingle,
    ForcedDecorativeAll;

    public final boolean isConnected = this.ordinal() != 0;
    public final boolean isSingleSubnet = this.name().endsWith("Single");
    public final boolean isAllSubnets = this.name().endsWith("All");
    public final boolean isPlate = this.name().contains("Plate");
    public final boolean isCable = this.name().contains("Cable");
    public final boolean isConnectionForced = this.name().startsWith("Forced");
    public final boolean isDecorative = this.name().contains("Decorative");
    public final short flags = RedNetConnectionType.toFlags(this.isConnected, this.isCable, this.isPlate, this.isSingleSubnet, this.isAllSubnets, this.isConnectionForced);
    private static final Map<Short, RedNetConnectionType> connections;

    public static final RedNetConnectionType fromFlags(short s) {
        return connections.get(s);
    }

    private static final short toFlags(boolean ... blArray) {
        short s = 0;
        int n = blArray.length;
        while (n-- > 0) {
            s = (short)(s | (blArray[n] ? 1 : 0) << n);
        }
        return s;
    }

    static {
        connections = new HashMap<Short, RedNetConnectionType>();
        for (RedNetConnectionType redNetConnectionType : RedNetConnectionType.values()) {
            connections.put(redNetConnectionType.flags, redNetConnectionType);
        }
    }
}

