/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.tank;

import cofh.core.item.ItemBlockBase;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.tank.BlockTank;
import cofh.thermalexpansion.block.tank.TileTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemBlockTank
extends ItemBlockBase
implements IFluidContainerItem {
    public ItemBlockTank(Block block) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public int getItemStackLimit(ItemStack itemStack) {
        if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("Fluid")) {
            return super.getItemStackLimit(itemStack);
        }
        return 64;
    }

    public String func_77667_c(ItemStack itemStack) {
        return "tile.thermalexpansion.tank." + BlockTank.NAMES[ItemHelper.getItemDamage((ItemStack)itemStack)] + ".name";
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        switch (BlockTank.Types.values()[ItemHelper.getItemDamage((ItemStack)itemStack)]) {
            case CREATIVE: {
                return EnumRarity.epic;
            }
            case RESONANT: {
                return EnumRarity.rare;
            }
            case REINFORCED: {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("Fluid")) {
            list.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (ItemHelper.getItemDamage((ItemStack)itemStack) == BlockTank.Types.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
            } else {
                list.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)] + " mB");
            }
            return;
        }
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"));
        if (fluidStack != null) {
            String string = "\u00a77";
            if (fluidStack.getFluid().getRarity() == EnumRarity.uncommon) {
                string = "\u00a7e";
            } else if (fluidStack.getFluid().getRarity() == EnumRarity.rare) {
                string = "\u00a7b";
            } else if (fluidStack.getFluid().getRarity() == EnumRarity.epic) {
                string = "\u00a7d";
            }
            list.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + string + fluidStack.getFluid().getLocalizedName(fluidStack) + "\u00a77");
            if (ItemHelper.getItemDamage((ItemStack)itemStack) == BlockTank.Types.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
            } else {
                list.add(StringHelper.localize((String)"info.cofh.level") + ": " + fluidStack.amount + " / " + TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)] + " mB");
            }
        } else {
            list.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (ItemHelper.getItemDamage((ItemStack)itemStack) == BlockTank.Types.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
            } else {
                list.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)] + " mB");
            }
        }
    }

    public FluidStack getFluid(ItemStack itemStack) {
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack itemStack) {
        return TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }

    public int fill(ItemStack itemStack, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || itemStack.field_77994_a > 1) {
            return 0;
        }
        int n = this.getCapacity(itemStack);
        if (!bl) {
            if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("Fluid")) {
                return Math.min(n, fluidStack.amount);
            }
            FluidStack fluidStack2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"));
            if (fluidStack2 == null) {
                return Math.min(n, fluidStack.amount);
            }
            if (!fluidStack2.isFluidEqual(fluidStack)) {
                return 0;
            }
            return Math.min(n - fluidStack2.amount, fluidStack.amount);
        }
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        if (!itemStack.field_77990_d.func_74764_b("Fluid")) {
            NBTTagCompound nBTTagCompound = fluidStack.writeToNBT(new NBTTagCompound());
            if (n < fluidStack.amount) {
                nBTTagCompound.func_74768_a("Amount", n);
                itemStack.field_77990_d.func_74782_a("Fluid", (NBTBase)nBTTagCompound);
                return n;
            }
            nBTTagCompound.func_74768_a("Amount", fluidStack.amount);
            itemStack.field_77990_d.func_74782_a("Fluid", (NBTBase)nBTTagCompound);
            return fluidStack.amount;
        }
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d.func_74775_l("Fluid");
        FluidStack fluidStack3 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound);
        if (!fluidStack3.isFluidEqual(fluidStack)) {
            return 0;
        }
        int n2 = n - fluidStack3.amount;
        if (fluidStack.amount < n2) {
            fluidStack3.amount += fluidStack.amount;
            n2 = fluidStack.amount;
        } else {
            fluidStack3.amount = n;
        }
        itemStack.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidStack3.writeToNBT(nBTTagCompound));
        return n2;
    }

    public FluidStack drain(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("Fluid") || n == 0 || itemStack.field_77994_a > 1) {
            return null;
        }
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"));
        if (fluidStack == null) {
            return null;
        }
        int n2 = Math.min(fluidStack.amount, n);
        if (bl && ItemHelper.getItemDamage((ItemStack)itemStack) != BlockTank.Types.CREATIVE.ordinal()) {
            if (n >= fluidStack.amount) {
                itemStack.field_77990_d.func_82580_o("Fluid");
                if (itemStack.field_77990_d.func_82582_d()) {
                    itemStack.field_77990_d = null;
                }
                return fluidStack;
            }
            NBTTagCompound nBTTagCompound = itemStack.field_77990_d.func_74775_l("Fluid");
            nBTTagCompound.func_74768_a("Amount", nBTTagCompound.func_74762_e("Amount") - n2);
            itemStack.field_77990_d.func_74782_a("Fluid", (NBTBase)nBTTagCompound);
        }
        fluidStack.amount = n2;
        return fluidStack;
    }
}

