/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdRadius
extends WBCmd {
    public CmdRadius() {
        this.permission = "radius";
        this.name = "radius";
        this.hasWorldNameInput = true;
        this.minParams = 1;
        this.maxParams = 2;
        this.addCmdExample(this.nameEmphasizedW() + "<radiusX> [radiusZ] - change radius.");
        this.helpText = "Using this command you can adjust the radius of an existing border. If [radiusZ] is not specified, the radiusX value will be used for both. You can also optionally specify + or - at the start of <radiusX> and [radiusZ] to increase or decrease the existing radius rather than setting a new value.";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        int radiusZ;
        int radiusX;
        BorderData border;
        if (worldName == null) {
            worldName = Worlds.getWorldName(player.field_70170_p);
        }
        if ((border = Config.Border(worldName)) == null) {
            this.sendErrorAndHelp(sender, "This world (\"" + worldName + "\") must first have a border set normally.");
            return;
        }
        double x = border.getX();
        double z = border.getZ();
        try {
            if (params.get(0).startsWith("+")) {
                radiusX = border.getRadiusX();
                radiusX += Integer.parseInt(params.get(0).substring(1));
            } else if (params.get(0).startsWith("-")) {
                radiusX = border.getRadiusX();
                radiusX -= Integer.parseInt(params.get(0).substring(1));
            } else {
                radiusX = Integer.parseInt(params.get(0));
            }
            if (params.size() == 2) {
                if (params.get(1).startsWith("+")) {
                    radiusZ = border.getRadiusZ();
                    radiusZ += Integer.parseInt(params.get(1).substring(1));
                } else if (params.get(1).startsWith("-")) {
                    radiusZ = border.getRadiusZ();
                    radiusZ -= Integer.parseInt(params.get(1).substring(1));
                } else {
                    radiusZ = Integer.parseInt(params.get(1));
                }
            } else {
                radiusZ = radiusX;
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "The radius value(s) must be integers.");
            return;
        }
        double minimum = Config.getKnockBack();
        if ((double)radiusX < minimum || (double)radiusZ < minimum) {
            this.sendErrorAndHelp(sender, "The resulting radius must be more than the knockback.");
            return;
        }
        Config.setBorder(worldName, radiusX, radiusZ, x, z);
        if (player != null) {
            Util.chat(sender, "Radius has been set. " + Config.BorderDescription(worldName), new Object[0]);
        }
    }
}

