/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Profiles;
import com.wimbli.WorldBorder.forge.Util;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdBypasslist
extends WBCmd {
    public CmdBypasslist() {
        this.permission = "bypasslist";
        this.name = "bypasslist";
        this.maxParams = 0;
        this.minParams = 0;
        this.addCmdExample(this.nameEmphasized() + "- list players with border bypass enabled.");
        this.helpText = "The bypass list will persist between server restarts, and applies to all worlds. Use the " + this.commandEmphasized("bypass") + C_DESC + "command to add or remove players.";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        UUID[] uuids = Config.getPlayerBypassList();
        if (uuids.length == 0) {
            Util.chat(sender, "Players with border bypass enabled: <none>", new Object[0]);
            return;
        }
        try {
            Object[] names = Profiles.fetchNames(uuids);
            String list = Arrays.toString(names);
            Util.chat(sender, "Players with border bypass enabled: " + list, new Object[0]);
        }
        catch (Exception ex) {
            this.sendErrorAndHelp(sender, "Failed to look up names for the UUIDs in the border bypass list: " + ex.getMessage());
        }
    }
}

